/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private final TagKey<Instrument> instruments;

    public InstrumentItem(TagKey<Instrument> $$0, Item.Properties $$1) {
        super($$1);
        this.instruments = $$0;
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        super.appendHoverText($$0, $$1, $$2, $$3);
        HolderLookup.Provider $$4 = $$1.registries();
        if ($$4 == null) {
            return;
        }
        Optional<Holder<Instrument>> $$5 = this.getInstrument($$0, $$4);
        if ($$5.isPresent()) {
            MutableComponent $$6 = $$5.get().value().description().copy();
            ComponentUtils.mergeStyles($$6, Style.EMPTY.withColor(ChatFormatting.GRAY));
            $$2.add($$6);
        }
    }

    public static ItemStack create(Item $$0, Holder<Instrument> $$1) {
        ItemStack $$2 = new ItemStack($$0);
        $$2.set(DataComponents.INSTRUMENT, $$1);
        return $$2;
    }

    @Override
    public InteractionResult use(Level $$0, Player $$1, InteractionHand $$2) {
        ItemStack $$3 = $$1.getItemInHand($$2);
        Optional<Holder<Instrument>> $$4 = this.getInstrument($$3, $$1.registryAccess());
        if ($$4.isPresent()) {
            Instrument $$5 = $$4.get().value();
            $$1.startUsingItem($$2);
            InstrumentItem.play($$0, $$1, $$5);
            $$1.getCooldowns().addCooldown($$3, Mth.floor($$5.useDuration() * 20.0f));
            $$1.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public int getUseDuration(ItemStack $$02, LivingEntity $$1) {
        Optional<Holder<Instrument>> $$2 = this.getInstrument($$02, $$1.registryAccess());
        return $$2.map($$0 -> Mth.floor(((Instrument)$$0.value()).useDuration() * 20.0f)).orElse(0);
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack $$0, HolderLookup.Provider $$1) {
        Iterator $$4;
        Holder<Instrument> $$2 = $$0.get(DataComponents.INSTRUMENT);
        if ($$2 != null) {
            return Optional.of($$2);
        }
        Optional<HolderSet.Named<Instrument>> $$3 = $$1.lookupOrThrow(Registries.INSTRUMENT).get(this.instruments);
        if ($$3.isPresent() && ($$4 = $$3.get().iterator()).hasNext()) {
            return Optional.of($$4.next());
        }
        return Optional.empty();
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack $$0) {
        return ItemUseAnimation.TOOT_HORN;
    }

    private static void play(Level $$0, Player $$1, Instrument $$2) {
        SoundEvent $$3 = $$2.soundEvent().value();
        float $$4 = $$2.range() / 16.0f;
        $$0.playSound($$1, $$1, $$3, SoundSource.RECORDS, $$4, 1.0f);
        $$0.gameEvent(GameEvent.INSTRUMENT_PLAY, $$1.position(), GameEvent.Context.of($$1));
    }
}

