/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public abstract class BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public BlockEntity(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2) {
        this.type = $$0;
        this.worldPosition = $$1.immutable();
        this.validateBlockState($$2);
        this.blockState = $$2;
    }

    private void validateBlockState(BlockState $$0) {
        if (!this.isValidBlockState($$0)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf($$0));
        }
    }

    public boolean isValidBlockState(BlockState $$0) {
        return this.type.isValid($$0);
    }

    public static BlockPos getPosFromTag(CompoundTag $$0) {
        return new BlockPos($$0.getInt("x"), $$0.getInt("y"), $$0.getInt("z"));
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level $$0) {
        this.level = $$0;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(CompoundTag $$0, HolderLookup.Provider $$1) {
    }

    public final void loadWithComponents(CompoundTag $$02, HolderLookup.Provider $$1) {
        this.loadAdditional($$02, $$1);
        ComponentHelper.COMPONENTS_CODEC.parse($$1.createSerializationContext(NbtOps.INSTANCE), (Object)$$02).resultOrPartial($$0 -> LOGGER.warn("Failed to load components: {}", $$0)).ifPresent($$0 -> {
            this.components = $$0;
        });
    }

    public final void loadCustomOnly(CompoundTag $$0, HolderLookup.Provider $$1) {
        this.loadAdditional($$0, $$1);
    }

    protected void saveAdditional(CompoundTag $$0, HolderLookup.Provider $$1) {
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider $$0) {
        CompoundTag $$1 = this.saveWithoutMetadata($$0);
        this.saveMetadata($$1);
        return $$1;
    }

    public final CompoundTag saveWithId(HolderLookup.Provider $$0) {
        CompoundTag $$1 = this.saveWithoutMetadata($$0);
        this.saveId($$1);
        return $$1;
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider $$02) {
        CompoundTag $$12 = new CompoundTag();
        this.saveAdditional($$12, $$02);
        ComponentHelper.COMPONENTS_CODEC.encodeStart($$02.createSerializationContext(NbtOps.INSTANCE), (Object)this.components).resultOrPartial($$0 -> LOGGER.warn("Failed to save components: {}", $$0)).ifPresent($$1 -> $$12.merge((CompoundTag)$$1));
        return $$12;
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider $$0) {
        CompoundTag $$1 = new CompoundTag();
        this.saveAdditional($$1, $$0);
        return $$1;
    }

    public final CompoundTag saveCustomAndMetadata(HolderLookup.Provider $$0) {
        CompoundTag $$1 = this.saveCustomOnly($$0);
        this.saveMetadata($$1);
        return $$1;
    }

    private void saveId(CompoundTag $$0) {
        ResourceLocation $$1 = BlockEntityType.getKey(this.getType());
        if ($$1 == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        $$0.putString("id", $$1.toString());
    }

    public static void addEntityType(CompoundTag $$0, BlockEntityType<?> $$1) {
        $$0.putString("id", BlockEntityType.getKey($$1).toString());
    }

    private void saveMetadata(CompoundTag $$0) {
        this.saveId($$0);
        $$0.putInt("x", this.worldPosition.getX());
        $$0.putInt("y", this.worldPosition.getY());
        $$0.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos $$0, BlockState $$1, CompoundTag $$2, HolderLookup.Provider $$32) {
        String $$4 = $$2.getString("id");
        ResourceLocation $$5 = ResourceLocation.tryParse($$4);
        if ($$5 == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)$$4);
            return null;
        }
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional($$5).map($$3 -> {
            try {
                return $$3.create($$0, $$1);
            }
            catch (Throwable $$4) {
                LOGGER.error("Failed to create block entity {}", (Object)$$4, (Object)$$4);
                return null;
            }
        }).map($$3 -> {
            try {
                $$3.loadWithComponents($$2, $$32);
                return $$3;
            }
            catch (Throwable $$4) {
                LOGGER.error("Failed to load data for block entity {}", (Object)$$4, (Object)$$4);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)$$4);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level $$0, BlockPos $$1, BlockState $$2) {
        $$0.blockEntityChanged($$1);
        if (!$$2.isAir()) {
            $$0.updateNeighbourForOutputSignal($$1, $$2.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider $$0) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public boolean triggerEvent(int $$0, int $$1) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory $$0) {
        $$0.setDetail("Name", this::getNameForReporting);
        if (this.level == null) {
            return;
        }
        CrashReportCategory.populateBlockDetails($$0, this.level, this.worldPosition, this.getBlockState());
        CrashReportCategory.populateBlockDetails($$0, this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
    }

    private String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + this.getClass().getCanonicalName();
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(BlockState $$0) {
        this.validateBlockState($$0);
        this.blockState = $$0;
    }

    protected void applyImplicitComponents(DataComponentInput $$0) {
    }

    public final void applyComponentsFromItemStack(ItemStack $$0) {
        this.applyComponents($$0.getPrototype(), $$0.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap $$0, DataComponentPatch $$1) {
        final HashSet<DataComponentType<Object>> $$2 = new HashSet<DataComponentType<Object>>();
        $$2.add(DataComponents.BLOCK_ENTITY_DATA);
        $$2.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap $$3 = PatchedDataComponentMap.fromPatch($$0, $$1);
        this.applyImplicitComponents(new DataComponentInput(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<T> $$0) {
                $$2.add($$0);
                return $$3.get($$0);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> $$0, T $$1) {
                $$2.add($$0);
                return $$3.getOrDefault($$0, $$1);
            }
        });
        DataComponentPatch $$4 = $$1.forget($$2::contains);
        this.components = $$4.split().added();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder $$0) {
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag $$0) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder $$0 = DataComponentMap.builder();
        $$0.addAll(this.components);
        this.collectImplicitComponents($$0);
        return $$0.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap $$0) {
        this.components = $$0;
    }

    @Nullable
    public static Component parseCustomNameSafe(String $$0, HolderLookup.Provider $$1) {
        try {
            return Component.Serializer.fromJson($$0, $$1);
        }
        catch (Exception $$2) {
            LOGGER.warn("Failed to parse custom name from string '{}', discarding", (Object)$$0, (Object)$$2);
            return null;
        }
    }

    static class ComponentHelper {
        public static final Codec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).codec();

        private ComponentHelper() {
        }
    }

    protected static interface DataComponentInput {
        @Nullable
        public <T> T get(DataComponentType<T> var1);

        public <T> T getOrDefault(DataComponentType<? extends T> var1, T var2);
    }
}

