/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;

public class MapFrame {
    private final BlockPos pos;
    private final int rotation;
    private final int entityId;

    public MapFrame(BlockPos $$0, int $$1, int $$2) {
        this.pos = $$0;
        this.rotation = $$1;
        this.entityId = $$2;
    }

    @Nullable
    public static MapFrame load(CompoundTag $$0) {
        Optional<BlockPos> $$1 = NbtUtils.readBlockPos($$0, "pos");
        if ($$1.isEmpty()) {
            return null;
        }
        int $$2 = $$0.getInt("rotation");
        int $$3 = $$0.getInt("entity_id");
        return new MapFrame($$1.get(), $$2, $$3);
    }

    public CompoundTag save() {
        CompoundTag $$0 = new CompoundTag();
        $$0.put("pos", NbtUtils.writeBlockPos(this.pos));
        $$0.putInt("rotation", this.rotation);
        $$0.putInt("entity_id", this.entityId);
        return $$0;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getId() {
        return MapFrame.frameId(this.pos);
    }

    public static String frameId(BlockPos $$0) {
        return "frame-" + $$0.getX() + "," + $$0.getY() + "," + $$0.getZ();
    }
}

