/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.unsafe;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.minecraftforge.unsafe.UnsafeFieldAccess;
import sun.misc.Unsafe;

public class UnsafeHacks {
    private static final Unsafe UNSAFE = UnsafeHacks.getUnsafe();
    private static final UnsafeFieldAccess<Class, Object> module = UnsafeHacks.findField(Class.class, "module");
    private static final Consumer<AccessibleObject> SETACCESSIBLE = UnsafeHacks.getSetAccessible();

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return UnsafeHacks.cast(UNSAFE.allocateInstance(clazz));
        }
        catch (InstantiationException e) {
            return (T)UnsafeHacks.sneak(e);
        }
    }

    public static <T> T getField(Field field, Object instance) {
        return UnsafeHacks.cast(UNSAFE.getObject(instance, UNSAFE.objectFieldOffset(field)));
    }

    public static void setField(Field field, Object instance, Object value) {
        UNSAFE.putObject(instance, UNSAFE.objectFieldOffset(field), value);
    }

    public static int getIntField(Field field, Object instance) {
        return UNSAFE.getInt(instance, UNSAFE.objectFieldOffset(field));
    }

    public static void setIntField(Field field, Object instance, int value) {
        UNSAFE.putInt(instance, UNSAFE.objectFieldOffset(field), value);
    }

    public static <O, T> UnsafeFieldAccess<O, T> findField(Class<O> clazz, String name) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return new UnsafeFieldAccess(UNSAFE.objectFieldOffset(f));
        }
        return null;
    }

    public static <O> UnsafeFieldAccess.Int<O> findIntField(Class<O> clazz, String name) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return new UnsafeFieldAccess.Int(UNSAFE.objectFieldOffset(f));
        }
        return null;
    }

    public static <O> UnsafeFieldAccess.Bool<O> findBooleanField(Class<O> clazz, String name) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return new UnsafeFieldAccess.Bool(UNSAFE.objectFieldOffset(f));
        }
        return null;
    }

    public static void setAccessible(AccessibleObject target) {
        SETACCESSIBLE.accept(target);
    }

    static Unsafe theUnsafe() {
        return UNSAFE;
    }

    private static Unsafe getUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return (Unsafe)UnsafeHacks.sneak(e);
        }
    }

    private static Consumer<AccessibleObject> getSetAccessible() {
        try {
            try {
                Method setAccessible0 = AccessibleObject.class.getDeclaredMethod("setAccessible0", Boolean.TYPE);
                UnsafeHacks.setAccessibleFallback(setAccessible0);
                return acc -> {
                    try {
                        setAccessible0.invoke(acc, true);
                    }
                    catch (Exception e) {
                        UnsafeHacks.sneak(e);
                    }
                };
            }
            catch (NoSuchMethodException nm) {
                Method setAccessible0 = AccessibleObject.class.getDeclaredMethod("setAccessible0", AccessibleObject.class, Boolean.TYPE);
                UnsafeHacks.setAccessibleFallback(setAccessible0);
                return acc -> {
                    try {
                        setAccessible0.invoke(acc, true);
                    }
                    catch (Exception e) {
                        UnsafeHacks.sneak(e);
                    }
                };
            }
        }
        catch (Exception e) {
            return (Consumer)UnsafeHacks.sneak(e);
        }
    }

    private static void setAccessibleFallback(AccessibleObject obj) {
        if (module != null) {
            Object old = module.get(UnsafeHacks.class);
            Object base = module.get(Object.class);
            module.set(UnsafeHacks.class, base);
            obj.setAccessible(true);
            module.set(UnsafeHacks.class, old);
        } else {
            obj.setAccessible(true);
        }
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }

    private static <T> T cast(Object inst) {
        return (T)inst;
    }
}

