/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.DimensionSpecialEffectsManager;

@OnlyIn(value=Dist.CLIENT)
public abstract class DimensionSpecialEffects {
    private static final Object2ObjectMap<ResourceLocation, DimensionSpecialEffects> EFFECTS = (Object2ObjectMap)Util.make(new Object2ObjectArrayMap(), p_108881_ -> {
        OverworldEffects dimensionspecialeffects$overworldeffects = new OverworldEffects();
        p_108881_.defaultReturnValue((Object)dimensionspecialeffects$overworldeffects);
        p_108881_.put((Object)BuiltinDimensionTypes.OVERWORLD_EFFECTS, (Object)dimensionspecialeffects$overworldeffects);
        p_108881_.put((Object)BuiltinDimensionTypes.NETHER_EFFECTS, (Object)new NetherEffects());
        p_108881_.put((Object)BuiltinDimensionTypes.END_EFFECTS, (Object)new EndEffects());
    });
    private final float cloudLevel;
    private final boolean hasGround;
    private final SkyType skyType;
    private final boolean forceBrightLightmap;
    private final boolean constantAmbientLight;

    public DimensionSpecialEffects(float p_108866_, boolean p_108867_, SkyType p_108868_, boolean p_108869_, boolean p_108870_) {
        this.cloudLevel = p_108866_;
        this.hasGround = p_108867_;
        this.skyType = p_108868_;
        this.forceBrightLightmap = p_108869_;
        this.constantAmbientLight = p_108870_;
    }

    public static DimensionSpecialEffects forType(DimensionType p_108877_) {
        return DimensionSpecialEffectsManager.getForType((ResourceLocation)p_108877_.effectsLocation());
    }

    public boolean isSunriseOrSunset(float p_361903_) {
        return false;
    }

    public int getSunriseOrSunsetColor(float p_367777_) {
        return 0;
    }

    public float getCloudHeight() {
        return this.cloudLevel;
    }

    public boolean hasGround() {
        return this.hasGround;
    }

    public abstract Vec3 getBrightnessDependentFogColor(Vec3 var1, float var2);

    public abstract boolean isFoggyAt(int var1, int var2);

    public SkyType skyType() {
        return this.skyType;
    }

    public boolean forceBrightLightmap() {
        return this.forceBrightLightmap;
    }

    public boolean constantAmbientLight() {
        return this.constantAmbientLight;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum SkyType {
        NONE,
        OVERWORLD,
        END;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static class OverworldEffects
    extends DimensionSpecialEffects {
        public static final int CLOUD_LEVEL = 192;
        private static final float SUNRISE_AND_SUNSET_TIMESPAN = 0.4f;

        public OverworldEffects() {
            super(192.0f, true, SkyType.OVERWORLD, false, false);
        }

        @Override
        public boolean isSunriseOrSunset(float p_364112_) {
            float f = Mth.cos(p_364112_ * ((float)Math.PI * 2));
            return f >= -0.4f && f <= 0.4f;
        }

        @Override
        public int getSunriseOrSunsetColor(float p_362545_) {
            float f = Mth.cos(p_362545_ * ((float)Math.PI * 2));
            float f1 = f / 0.4f * 0.5f + 0.5f;
            float f2 = Mth.square(1.0f - (1.0f - Mth.sin(f1 * (float)Math.PI)) * 0.99f);
            return ARGB.colorFromFloat(f2, f1 * 0.3f + 0.7f, f1 * f1 * 0.7f + 0.2f, 0.2f);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108908_, float p_108909_) {
            return p_108908_.multiply(p_108909_ * 0.94f + 0.06f, p_108909_ * 0.94f + 0.06f, p_108909_ * 0.91f + 0.09f);
        }

        @Override
        public boolean isFoggyAt(int p_108905_, int p_108906_) {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NetherEffects
    extends DimensionSpecialEffects {
        public NetherEffects() {
            super(Float.NaN, true, SkyType.NONE, false, true);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108901_, float p_108902_) {
            return p_108901_;
        }

        @Override
        public boolean isFoggyAt(int p_108898_, int p_108899_) {
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EndEffects
    extends DimensionSpecialEffects {
        public EndEffects() {
            super(Float.NaN, false, SkyType.END, true, false);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108894_, float p_108895_) {
            return p_108894_.scale(0.15f);
        }

        @Override
        public boolean isFoggyAt(int p_108891_, int p_108892_) {
            return false;
        }
    }
}

