/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import net.minecraftforge.client.event.ModelEvent;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockStateModelLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter BLOCKSTATE_LISTER = FileToIdConverter.json("blockstates");
    private static final String FRAME_MAP_PROPERTY = "map";
    private static final String FRAME_MAP_PROPERTY_TRUE = "map=true";
    private static final String FRAME_MAP_PROPERTY_FALSE = "map=false";
    private static final StateDefinition<Block, BlockState> ITEM_FRAME_FAKE_DEFINITION = new StateDefinition.Builder(Blocks.AIR).add(BooleanProperty.create("map")).create(Block::defaultBlockState, BlockState::new);
    private static final ResourceLocation GLOW_ITEM_FRAME_LOCATION = ResourceLocation.withDefaultNamespace("glow_item_frame");
    private static final ResourceLocation ITEM_FRAME_LOCATION = ResourceLocation.withDefaultNamespace("item_frame");
    private static final Map<ResourceLocation, StateDefinition<Block, BlockState>> STATIC_DEFINITIONS = Map.of(ITEM_FRAME_LOCATION, ITEM_FRAME_FAKE_DEFINITION, GLOW_ITEM_FRAME_LOCATION, ITEM_FRAME_FAKE_DEFINITION);
    public static final ModelResourceLocation GLOW_MAP_FRAME_LOCATION = new ModelResourceLocation(GLOW_ITEM_FRAME_LOCATION, "map=true");
    public static final ModelResourceLocation GLOW_FRAME_LOCATION = new ModelResourceLocation(GLOW_ITEM_FRAME_LOCATION, "map=false");
    public static final ModelResourceLocation MAP_FRAME_LOCATION = new ModelResourceLocation(ITEM_FRAME_LOCATION, "map=true");
    public static final ModelResourceLocation FRAME_LOCATION = new ModelResourceLocation(ITEM_FRAME_LOCATION, "map=false");

    private static Function<ResourceLocation, StateDefinition<Block, BlockState>> definitionLocationToBlockMapper() {
        HashMap<ResourceLocation, StateDefinition<Block, BlockState>> map = new HashMap<ResourceLocation, StateDefinition<Block, BlockState>>(STATIC_DEFINITIONS);
        ModelEvent.RegisterModelStateDefinitions event = ForgeEventFactoryClient.onRegisterModeStateDefinitions();
        map.putAll(event.getStates());
        for (Block block : BuiltInRegistries.BLOCK) {
            map.put(block.builtInRegistryHolder().key().location(), block.getStateDefinition());
        }
        return map::get;
    }

    public static CompletableFuture<LoadedModels> loadBlockStates(UnbakedModel p_375655_, ResourceManager p_378230_, Executor p_378682_) {
        Function<ResourceLocation, StateDefinition<Block, BlockState>> function = BlockStateModelLoader.definitionLocationToBlockMapper();
        return CompletableFuture.supplyAsync(() -> BLOCKSTATE_LISTER.listMatchingResourceStacks(p_378230_), p_378682_).thenCompose(p_374696_ -> {
            ArrayList<CompletableFuture<LoadedModels>> list = new ArrayList<CompletableFuture<LoadedModels>>(p_374696_.size());
            for (Map.Entry entry : p_374696_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation resourcelocation = BLOCKSTATE_LISTER.fileToId((ResourceLocation)entry.getKey());
                    StateDefinition statedefinition = (StateDefinition)function.apply(resourcelocation);
                    if (statedefinition == null) {
                        LOGGER.debug("Discovered unknown block state definition {}, ignoring", (Object)resourcelocation);
                        return null;
                    }
                    List list1 = (List)entry.getValue();
                    ArrayList<LoadedBlockModelDefinition> list2 = new ArrayList<LoadedBlockModelDefinition>(list1.size());
                    for (Resource resource : list1) {
                        try {
                            BufferedReader reader = resource.openAsReader();
                            try {
                                JsonObject jsonobject = GsonHelper.parse(reader);
                                BlockModelDefinition blockmodeldefinition = BlockModelDefinition.fromJsonElement((JsonElement)jsonobject);
                                list2.add(new LoadedBlockModelDefinition(resource.sourcePackId(), blockmodeldefinition));
                            }
                            finally {
                                if (reader == null) continue;
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception exception1) {
                            LOGGER.error("Failed to load blockstate definition {} from pack {}", new Object[]{resourcelocation, resource.sourcePackId(), exception1});
                        }
                    }
                    try {
                        return BlockStateModelLoader.loadBlockStateDefinitionStack(resourcelocation, statedefinition, list2, p_375655_);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to load blockstate definition {}", (Object)resourcelocation, (Object)exception);
                        return null;
                    }
                }, p_378682_));
            }
            return Util.sequence(list).thenApply(p_374692_ -> {
                HashMap<ModelResourceLocation, LoadedModel> map = new HashMap<ModelResourceLocation, LoadedModel>();
                for (LoadedModels blockstatemodelloader$loadedmodels : p_374692_) {
                    if (blockstatemodelloader$loadedmodels == null) continue;
                    map.putAll(blockstatemodelloader$loadedmodels.models());
                }
                return new LoadedModels(map);
            });
        });
    }

    private static LoadedModels loadBlockStateDefinitionStack(ResourceLocation p_367866_, StateDefinition<Block, BlockState> p_361140_, List<LoadedBlockModelDefinition> p_367255_, UnbakedModel p_377371_) {
        HashMap<ModelResourceLocation, LoadedModel> map = new HashMap<ModelResourceLocation, LoadedModel>();
        for (LoadedBlockModelDefinition blockstatemodelloader$loadedblockmodeldefinition : p_367255_) {
            blockstatemodelloader$loadedblockmodeldefinition.contents.instantiate(p_361140_, String.valueOf(p_367866_) + "/" + blockstatemodelloader$loadedblockmodeldefinition.source).forEach((p_374690_, p_374691_) -> {
                ModelResourceLocation modelresourcelocation = BlockModelShaper.stateToModelLocation(p_367866_, p_374690_);
                map.put(modelresourcelocation, new LoadedModel((BlockState)p_374690_, (UnbakedBlockStateModel)p_374691_));
            });
        }
        return new LoadedModels(map);
    }

    @OnlyIn(value=Dist.CLIENT)
    record LoadedBlockModelDefinition(String source, BlockModelDefinition contents) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public record LoadedModels(Map<ModelResourceLocation, LoadedModel> models) {
        public Stream<ResolvableModel> forResolving() {
            return this.models.values().stream().map(LoadedModel::model);
        }

        public Map<ModelResourceLocation, UnbakedBlockStateModel> plainModels() {
            return Maps.transformValues(this.models, LoadedModel::model);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record LoadedModel(BlockState state, UnbakedBlockStateModel model) {
    }
}

