/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SpecialBlockModelRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ClientItemInfoLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelGroupCollector;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.geometry.GeometryLoaderManager;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelManager
implements PreparableReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json("models");
    private static final Map<ResourceLocation, ResourceLocation> VANILLA_ATLASES = Map.of(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("banner_patterns"), Sheets.BED_SHEET, ResourceLocation.withDefaultNamespace("beds"), Sheets.CHEST_SHEET, ResourceLocation.withDefaultNamespace("chests"), Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("shield_patterns"), Sheets.SIGN_SHEET, ResourceLocation.withDefaultNamespace("signs"), Sheets.SHULKER_SHEET, ResourceLocation.withDefaultNamespace("shulker_boxes"), Sheets.ARMOR_TRIMS_SHEET, ResourceLocation.withDefaultNamespace("armor_trims"), Sheets.DECORATED_POT_SHEET, ResourceLocation.withDefaultNamespace("decorated_pot"), TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("blocks"));
    private Map<ModelResourceLocation, BakedModel> bakedBlockStateModels = Map.of();
    private Map<ModelResourceLocation, BakedModel> bakedBlockStateModelsView = Map.of();
    private Map<ResourceLocation, ItemModel> bakedItemStackModels = Map.of();
    private Map<ResourceLocation, ItemModel> bakedItemStackModelsView = Map.of();
    private Map<ResourceLocation, ClientItem.Properties> itemProperties = Map.of();
    private final AtlasSet atlases;
    private final BlockModelShaper blockModelShaper;
    private final BlockColors blockColors;
    private EntityModelSet entityModelSet = EntityModelSet.EMPTY;
    private SpecialBlockModelRenderer specialBlockModelRenderer = SpecialBlockModelRenderer.EMPTY;
    private int maxMipmapLevels;
    private BakedModel missingModel;
    private ItemModel missingItemModel;
    private Object2IntMap<BlockState> modelGroups = Object2IntMaps.emptyMap();
    private ModelBakery modelBakery;

    public ModelManager(TextureManager p_119406_, BlockColors p_119407_, int p_119408_) {
        this.blockColors = p_119407_;
        this.maxMipmapLevels = p_119408_;
        this.blockModelShaper = new BlockModelShaper(this);
        this.atlases = new AtlasSet(VANILLA_ATLASES, p_119406_);
    }

    public BakedModel getModel(ModelResourceLocation p_119423_) {
        return this.bakedBlockStateModels.getOrDefault(p_119423_, this.missingModel);
    }

    public Map<ModelResourceLocation, BakedModel> getModels() {
        return this.bakedBlockStateModelsView;
    }

    public BakedModel getMissingModel() {
        return this.missingModel;
    }

    public ItemModel getItemModel(ResourceLocation p_376816_) {
        return this.bakedItemStackModels.getOrDefault(p_376816_, this.missingItemModel);
    }

    public Map<ResourceLocation, ItemModel> getItemModels() {
        return this.bakedItemStackModelsView;
    }

    public ClientItem.Properties getItemProperties(ResourceLocation p_378319_) {
        return this.itemProperties.getOrDefault(p_378319_, ClientItem.Properties.DEFAULT);
    }

    public BlockModelShaper getBlockModelShaper() {
        return this.blockModelShaper;
    }

    @Override
    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_249079_, ResourceManager p_251134_, Executor p_250550_, Executor p_249221_) {
        GeometryLoaderManager.init();
        UnbakedModel unbakedmodel = MissingBlockModel.missingModel();
        CompletableFuture<EntityModelSet> completablefuture = CompletableFuture.supplyAsync(EntityModelSet::vanilla, p_250550_);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(SpecialBlockModelRenderer::vanilla, p_250550_);
        CompletableFuture<Map<ResourceLocation, UnbakedModel>> completablefuture2 = ModelManager.loadBlockModels(p_251134_, p_250550_);
        CompletableFuture<BlockStateModelLoader.LoadedModels> completablefuture3 = BlockStateModelLoader.loadBlockStates(unbakedmodel, p_251134_, p_250550_);
        CompletableFuture completablefuture4 = ClientItemInfoLoader.scheduleLoad((ResourceManager)p_251134_, (Executor)p_250550_);
        CompletionStage completablefuture5 = CompletableFuture.allOf(completablefuture2, completablefuture3, completablefuture4).thenApplyAsync(p_374722_ -> ModelManager.discoverModelDependencies(unbakedmodel, (Map)completablefuture2.join(), (BlockStateModelLoader.LoadedModels)completablefuture3.join(), (ClientItemInfoLoader.LoadedClientInfos)completablefuture4.join()), p_250550_);
        CompletionStage completablefuture6 = completablefuture3.thenApplyAsync(p_358038_ -> ModelManager.buildModelGroups(this.blockColors, p_358038_), p_250550_);
        Map map = this.atlases.scheduleLoad(p_251134_, this.maxMipmapLevels, p_250550_);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.concat(map.values().stream(), Stream.of(completablefuture5, completablefuture6, completablefuture3, completablefuture4, completablefuture, completablefuture1)).toArray(CompletableFuture[]::new)).thenApplyAsync(arg_0 -> ModelManager.lambda$reload$5(map, (CompletableFuture)completablefuture5, (CompletableFuture)completablefuture6, completablefuture, completablefuture3, completablefuture4, unbakedmodel, (CompletableFuture)completablefuture1, arg_0), p_250550_)).thenCompose(p_252255_ -> p_252255_.readyForUpload.thenApply(p_251581_ -> p_252255_))).thenCompose(p_249079_::wait)).thenAcceptAsync(p_358039_ -> this.apply((ReloadState)p_358039_, Profiler.get()), p_249221_);
    }

    private static CompletableFuture<Map<ResourceLocation, UnbakedModel>> loadBlockModels(ResourceManager p_251361_, Executor p_252189_) {
        return CompletableFuture.supplyAsync(() -> MODEL_LISTER.listMatchingResources(p_251361_), p_252189_).thenCompose(p_250597_ -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(p_250597_.size());
            for (Map.Entry entry : p_250597_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation resourcelocation = MODEL_LISTER.fileToId((ResourceLocation)entry.getKey());
                    try {
                        Pair pair;
                        try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                            pair = Pair.of((Object)resourcelocation, (Object)BlockModel.fromStream(reader));
                        }
                        return pair;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to load model {}", entry.getKey(), (Object)exception);
                        return null;
                    }
                }, p_252189_));
            }
            return Util.sequence(list).thenApply(p_250813_ -> p_250813_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private static ModelDiscovery discoverModelDependencies(UnbakedModel p_364387_, Map<ResourceLocation, UnbakedModel> p_360749_, BlockStateModelLoader.LoadedModels p_366446_, ClientItemInfoLoader.LoadedClientInfos p_378505_) {
        ModelDiscovery modeldiscovery = new ModelDiscovery(p_360749_, p_364387_);
        p_366446_.forResolving().forEach(arg_0 -> ((ModelDiscovery)modeldiscovery).addRoot(arg_0));
        p_378505_.contents().values().forEach(p_374734_ -> modeldiscovery.addRoot((ResolvableModel)p_374734_.model()));
        modeldiscovery.registerSpecialModels();
        modeldiscovery.discoverDependencies();
        return modeldiscovery;
    }

    private static ReloadState loadModels(ProfilerFiller p_252136_, final Map<ResourceLocation, AtlasSet.StitchResult> p_250646_, ModelBakery p_248945_, Object2IntMap<BlockState> p_361513_, EntityModelSet p_378097_, SpecialBlockModelRenderer p_377275_) {
        p_252136_.push("baking");
        HashMultimap multimap = HashMultimap.create();
        HashMultimap multimap1 = HashMultimap.create();
        TextureAtlasSprite textureatlassprite = p_250646_.get(TextureAtlas.LOCATION_BLOCKS).missing();
        ModelBakery.BakingResult modelbakery$bakingresult = p_248945_.bakeModels(new ModelBakery.TextureGetter(){
            final /* synthetic */ Multimap val$multimap;
            final /* synthetic */ Multimap val$multimap1;
            final /* synthetic */ TextureAtlasSprite val$textureatlassprite;
            {
                this.val$multimap = multimap;
                this.val$multimap1 = multimap2;
                this.val$textureatlassprite = textureAtlasSprite;
            }

            public TextureAtlasSprite get(ModelDebugName p_375833_, Material p_375858_) {
                AtlasSet.StitchResult atlasset$stitchresult = (AtlasSet.StitchResult)p_250646_.get(p_375858_.atlasLocation());
                TextureAtlasSprite textureatlassprite1 = atlasset$stitchresult.getSprite(p_375858_.texture());
                if (textureatlassprite1 != null) {
                    return textureatlassprite1;
                }
                this.val$multimap.put((Object)((String)p_375833_.get()), (Object)p_375858_);
                return atlasset$stitchresult.missing();
            }

            public TextureAtlasSprite reportMissingReference(ModelDebugName p_377684_, String p_378821_) {
                this.val$multimap1.put((Object)((String)p_377684_.get()), (Object)p_378821_);
                return this.val$textureatlassprite;
            }
        });
        multimap.asMap().forEach((p_376688_, p_252017_) -> LOGGER.warn("Missing textures in model {}:\n{}", p_376688_, (Object)p_252017_.stream().sorted(Material.COMPARATOR).map(p_325574_ -> "    " + String.valueOf(p_325574_.atlasLocation()) + ":" + String.valueOf(p_325574_.texture())).collect(Collectors.joining("\n"))));
        multimap1.asMap().forEach((p_374739_, p_374740_) -> LOGGER.warn("Missing texture references in model {}:\n{}", p_374739_, (Object)p_374740_.stream().sorted().map(p_374742_ -> "    " + p_374742_).collect(Collectors.joining("\n"))));
        p_252136_.popPush("forge_modify_baking_result");
        ForgeHooksClient.onModifyBakingResult((ModelBakery)p_248945_, (ModelBakery.BakingResult)modelbakery$bakingresult);
        p_252136_.popPush("dispatch");
        Map<BlockState, BakedModel> map = ModelManager.createBlockStateToModelDispatch(modelbakery$bakingresult.blockStateModels(), modelbakery$bakingresult.missingModel());
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf((CompletableFuture[])p_250646_.values().stream().map(AtlasSet.StitchResult::readyForUpload).toArray(CompletableFuture[]::new));
        p_252136_.pop();
        return new ReloadState(modelbakery$bakingresult, p_361513_, map, p_250646_, p_378097_, p_377275_, completablefuture, p_248945_);
    }

    private static Map<BlockState, BakedModel> createBlockStateToModelDispatch(Map<ModelResourceLocation, BakedModel> p_377857_, BakedModel p_378390_) {
        IdentityHashMap<BlockState, BakedModel> map = new IdentityHashMap<BlockState, BakedModel>();
        for (Block block : BuiltInRegistries.BLOCK) {
            block.getStateDefinition().getPossibleStates().forEach(p_374738_ -> {
                ResourceLocation resourcelocation = p_374738_.getBlock().builtInRegistryHolder().key().location();
                ModelResourceLocation modelresourcelocation = BlockModelShaper.stateToModelLocation(resourcelocation, p_374738_);
                BakedModel bakedmodel = (BakedModel)p_377857_.get(modelresourcelocation);
                if (bakedmodel == null) {
                    LOGGER.warn("Missing model for variant: '{}'", (Object)modelresourcelocation);
                    map.putIfAbsent((BlockState)p_374738_, p_378390_);
                } else {
                    map.put((BlockState)p_374738_, bakedmodel);
                }
            });
        }
        return map;
    }

    private static Object2IntMap<BlockState> buildModelGroups(BlockColors p_369941_, BlockStateModelLoader.LoadedModels p_360724_) {
        return ModelGroupCollector.build((BlockColors)p_369941_, (BlockStateModelLoader.LoadedModels)p_360724_);
    }

    private void apply(ReloadState p_248996_, ProfilerFiller p_251960_) {
        p_251960_.push("upload");
        p_248996_.atlasPreparations.values().forEach(AtlasSet.StitchResult::upload);
        ModelBakery.BakingResult modelbakery$bakingresult = p_248996_.bakedModels;
        this.bakedBlockStateModels = modelbakery$bakingresult.blockStateModels();
        this.bakedBlockStateModelsView = Collections.unmodifiableMap(this.bakedBlockStateModels);
        this.bakedItemStackModels = modelbakery$bakingresult.itemStackModels();
        this.bakedItemStackModelsView = Collections.unmodifiableMap(this.bakedItemStackModels);
        this.itemProperties = modelbakery$bakingresult.itemProperties();
        this.modelGroups = p_248996_.modelGroups;
        this.missingModel = modelbakery$bakingresult.missingModel();
        this.missingItemModel = modelbakery$bakingresult.missingItemModel();
        this.modelBakery = p_248996_.modelBakery();
        ForgeHooksClient.onModelBake((ModelManager)this, (ModelBakery)this.modelBakery);
        p_251960_.popPush("cache");
        this.blockModelShaper.replaceCache(p_248996_.modelCache);
        this.specialBlockModelRenderer = p_248996_.specialBlockModelRenderer;
        this.entityModelSet = p_248996_.entityModelSet;
        p_251960_.pop();
    }

    public boolean requiresRender(BlockState p_119416_, BlockState p_119417_) {
        int j;
        if (p_119416_ == p_119417_) {
            return false;
        }
        int i = this.modelGroups.getInt((Object)p_119416_);
        if (i != -1 && i == (j = this.modelGroups.getInt((Object)p_119417_))) {
            FluidState fluidstate1;
            FluidState fluidstate = p_119416_.getFluidState();
            return fluidstate != (fluidstate1 = p_119417_.getFluidState());
        }
        return true;
    }

    public TextureAtlas getAtlas(ResourceLocation p_119429_) {
        if (this.atlases == null) {
            throw new RuntimeException("getAtlasTexture called too early!");
        }
        return this.atlases.getAtlas(p_119429_);
    }

    @Override
    public void close() {
        this.atlases.close();
    }

    public void updateMaxMipLevel(int p_119411_) {
        this.maxMipmapLevels = p_119411_;
    }

    public ModelBakery getModelBakery() {
        return (ModelBakery)Preconditions.checkNotNull((Object)this.modelBakery, (Object)"Attempted to query model bakery before it has been initialized.");
    }

    public Supplier<SpecialBlockModelRenderer> specialBlockModelRenderer() {
        return () -> this.specialBlockModelRenderer;
    }

    public Supplier<EntityModelSet> entityModels() {
        return () -> this.entityModelSet;
    }

    private static /* synthetic */ ReloadState lambda$reload$5(Map map, CompletableFuture completablefuture5, CompletableFuture completablefuture6, CompletableFuture completablefuture, CompletableFuture completablefuture3, CompletableFuture completablefuture4, UnbakedModel unbakedmodel, CompletableFuture completablefuture1, Void p_374732_) {
        Map<ResourceLocation, AtlasSet.StitchResult> map1 = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p_248988_ -> (AtlasSet.StitchResult)((CompletableFuture)p_248988_.getValue()).join()));
        ModelDiscovery modeldiscovery = (ModelDiscovery)completablefuture5.join();
        Object2IntMap object2intmap = (Object2IntMap)completablefuture6.join();
        Set set = modeldiscovery.getUnreferencedModels();
        if (!set.isEmpty()) {
            LOGGER.debug("Unreferenced models: \n{}", (Object)set.stream().sorted().map(p_374723_ -> "\t" + String.valueOf(p_374723_) + "\n").collect(Collectors.joining()));
        }
        ModelBakery modelbakery = new ModelBakery((EntityModelSet)completablefuture.join(), ((BlockStateModelLoader.LoadedModels)completablefuture3.join()).plainModels(), ((ClientItemInfoLoader.LoadedClientInfos)completablefuture4.join()).contents(), modeldiscovery.getReferencedModels(), unbakedmodel);
        return ModelManager.loadModels(Profiler.get(), map1, modelbakery, (Object2IntMap<BlockState>)object2intmap, (EntityModelSet)completablefuture.join(), (SpecialBlockModelRenderer)completablefuture1.join());
    }

    @OnlyIn(value=Dist.CLIENT)
    record ReloadState(ModelBakery.BakingResult bakedModels, Object2IntMap<BlockState> modelGroups, Map<BlockState, BakedModel> modelCache, Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations, EntityModelSet entityModelSet, SpecialBlockModelRenderer specialBlockModelRenderer, CompletableFuture<Void> readyForUpload, ModelBakery modelBakery) {
    }
}

