/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private static final int SELF_SIZE_IN_BYTES = 37;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListTag load(DataInput $$0, NbtAccounter $$1) throws IOException {
            $$1.pushDepth();
            try {
                ListTag listTag = 1.loadList($$0, $$1);
                return listTag;
            }
            finally {
                $$1.popDepth();
            }
        }

        private static ListTag loadList(DataInput $$0, NbtAccounter $$1) throws IOException {
            $$1.accountBytes(37L);
            byte $$2 = $$0.readByte();
            int $$3 = $$0.readInt();
            if ($$2 == 0 && $$3 > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            $$1.accountBytes(4L, $$3);
            TagType<?> $$4 = TagTypes.getType($$2);
            ArrayList $$5 = Lists.newArrayListWithCapacity((int)$$3);
            for (int $$6 = 0; $$6 < $$3; ++$$6) {
                $$5.add($$4.load($$0, $$1));
            }
            return new ListTag($$5, $$2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput $$0, StreamTagVisitor $$1, NbtAccounter $$2) throws IOException {
            $$2.pushDepth();
            try {
                StreamTagVisitor.ValueResult valueResult = 1.parseList($$0, $$1, $$2);
                return valueResult;
            }
            finally {
                $$2.popDepth();
            }
        }

        /*
         * Exception decompiling
         */
        private static StreamTagVisitor.ValueResult parseList(DataInput $$0, StreamTagVisitor $$1, NbtAccounter $$2) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 8[CASE]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput $$0, NbtAccounter $$1) throws IOException {
            $$1.pushDepth();
            try {
                TagType<?> $$2 = TagTypes.getType($$0.readByte());
                int $$3 = $$0.readInt();
                $$2.skip($$0, $$3, $$1);
            }
            finally {
                $$1.popDepth();
            }
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final List<Tag> list;
    private byte type;

    ListTag(List<Tag> $$0, byte $$1) {
        this.list = $$0;
        this.type = $$1;
    }

    public ListTag() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void write(DataOutput $$0) throws IOException {
        this.type = this.list.isEmpty() ? (byte)0 : this.list.get(0).getId();
        $$0.writeByte(this.type);
        $$0.writeInt(this.list.size());
        for (Tag $$1 : this.list) {
            $$1.write($$0);
        }
    }

    @Override
    public int sizeInBytes() {
        int $$0 = 37;
        $$0 += 4 * this.list.size();
        for (Tag $$1 : this.list) {
            $$0 += $$1.sizeInBytes();
        }
        return $$0;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    private void updateTypeAfterRemove() {
        if (this.list.isEmpty()) {
            this.type = 0;
        }
    }

    @Override
    public Tag remove(int $$0) {
        Tag $$1 = this.list.remove($$0);
        this.updateTypeAfterRemove();
        return $$1;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public CompoundTag getCompound(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 10) {
            return (CompoundTag)$$1;
        }
        return new CompoundTag();
    }

    public ListTag getList(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 9) {
            return (ListTag)$$1;
        }
        return new ListTag();
    }

    public short getShort(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 2) {
            return ((ShortTag)$$1).getAsShort();
        }
        return 0;
    }

    public int getInt(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 3) {
            return ((IntTag)$$1).getAsInt();
        }
        return 0;
    }

    public int[] getIntArray(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 11) {
            return ((IntArrayTag)$$1).getAsIntArray();
        }
        return new int[0];
    }

    public long[] getLongArray(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 12) {
            return ((LongArrayTag)$$1).getAsLongArray();
        }
        return new long[0];
    }

    public double getDouble(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 6) {
            return ((DoubleTag)$$1).getAsDouble();
        }
        return 0.0;
    }

    public float getFloat(int $$0) {
        Tag $$1;
        if ($$0 >= 0 && $$0 < this.list.size() && ($$1 = this.list.get($$0)).getId() == 5) {
            return ((FloatTag)$$1).getAsFloat();
        }
        return 0.0f;
    }

    public String getString(int $$0) {
        if ($$0 < 0 || $$0 >= this.list.size()) {
            return "";
        }
        Tag $$1 = this.list.get($$0);
        if ($$1.getId() == 8) {
            return $$1.getAsString();
        }
        return $$1.toString();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Tag get(int $$0) {
        return this.list.get($$0);
    }

    @Override
    public Tag set(int $$0, Tag $$1) {
        Tag $$2 = this.get($$0);
        if (!this.setTag($$0, $$1)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", $$1.getId(), this.type));
        }
        return $$2;
    }

    @Override
    public void add(int $$0, Tag $$1) {
        if (!this.addTag($$0, $$1)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", $$1.getId(), this.type));
        }
    }

    @Override
    public boolean setTag(int $$0, Tag $$1) {
        if (this.updateType($$1)) {
            this.list.set($$0, $$1);
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int $$0, Tag $$1) {
        if (this.updateType($$1)) {
            this.list.add($$0, $$1);
            return true;
        }
        return false;
    }

    private boolean updateType(Tag $$0) {
        if ($$0.getId() == 0) {
            return false;
        }
        if (this.type == 0) {
            this.type = $$0.getId();
            return true;
        }
        return this.type == $$0.getId();
    }

    @Override
    public ListTag copy() {
        List<Tag> $$0 = TagTypes.getType(this.type).isValue() ? this.list : Iterables.transform(this.list, Tag::copy);
        ArrayList $$1 = Lists.newArrayList($$0);
        return new ListTag($$1, this.type);
    }

    @Override
    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        return $$0 instanceof ListTag && Objects.equals(this.list, ((ListTag)$$0).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void accept(TagVisitor $$0) {
        $$0.visitList(this);
    }

    @Override
    public byte getElementType() {
        return this.type;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.type = 0;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor $$0) {
        switch ($$0.visitList(TagTypes.getType(this.type), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return $$0.visitContainerEnd();
            }
        }
        block13: for (int $$1 = 0; $$1 < this.list.size(); ++$$1) {
            Tag $$2 = this.list.get($$1);
            switch ($$0.visitElement($$2.getType(), $$1)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case SKIP: {
                    continue block13;
                }
                case BREAK: {
                    return $$0.visitContainerEnd();
                }
                default: {
                    switch ($$2.accept($$0)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return $$0.visitContainerEnd();
                        }
                    }
                }
            }
        }
        return $$0.visitContainerEnd();
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

