/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class DropInvalidSignDataFix
extends NamedEntityFix {
    private static final String[] FIELDS_TO_DROP = new String[]{"Text1", "Text2", "Text3", "Text4", "FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4", "Color", "GlowingText"};

    public DropInvalidSignDataFix(Schema $$0, String $$1, String $$2) {
        super($$0, false, $$1, References.BLOCK_ENTITY, $$2);
    }

    private static <T> Dynamic<T> fix(Dynamic<T> $$0) {
        $$0 = $$0.update("front_text", DropInvalidSignDataFix::fixText);
        $$0 = $$0.update("back_text", DropInvalidSignDataFix::fixText);
        for (String $$1 : FIELDS_TO_DROP) {
            $$0 = $$0.remove($$1);
        }
        return $$0;
    }

    private static <T> Dynamic<T> fixText(Dynamic<T> $$0) {
        boolean $$12 = $$0.get("_filtered_correct").asBoolean(false);
        if ($$12) {
            return $$0.remove("_filtered_correct");
        }
        Optional $$22 = $$0.get("filtered_messages").asStreamOpt().result();
        if ($$22.isEmpty()) {
            return $$0;
        }
        Dynamic $$32 = ComponentDataFixUtils.createEmptyComponent($$0.getOps());
        List<Dynamic> $$4 = $$0.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List $$5 = Streams.mapWithIndex((Stream)((Stream)$$22.get()), ($$2, $$3) -> {
            Dynamic $$4 = $$3 < (long)$$4.size() ? (Dynamic)$$4.get((int)$$3) : $$32;
            return $$2.equals((Object)$$32) ? $$4 : $$2;
        }).toList();
        if ($$5.stream().allMatch($$1 -> $$1.equals((Object)$$32))) {
            return $$0.remove("filtered_messages");
        }
        return $$0.set("filtered_messages", $$0.createList($$5.stream()));
    }

    @Override
    protected Typed<?> fix(Typed<?> $$0) {
        return $$0.update(DSL.remainderFinder(), DropInvalidSignDataFix::fix);
    }
}

