/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class WolfVariants {
    public static final ResourceKey<WolfVariant> PALE = WolfVariants.createKey("pale");
    public static final ResourceKey<WolfVariant> SPOTTED = WolfVariants.createKey("spotted");
    public static final ResourceKey<WolfVariant> SNOWY = WolfVariants.createKey("snowy");
    public static final ResourceKey<WolfVariant> BLACK = WolfVariants.createKey("black");
    public static final ResourceKey<WolfVariant> ASHEN = WolfVariants.createKey("ashen");
    public static final ResourceKey<WolfVariant> RUSTY = WolfVariants.createKey("rusty");
    public static final ResourceKey<WolfVariant> WOODS = WolfVariants.createKey("woods");
    public static final ResourceKey<WolfVariant> CHESTNUT = WolfVariants.createKey("chestnut");
    public static final ResourceKey<WolfVariant> STRIPED = WolfVariants.createKey("striped");
    public static final ResourceKey<WolfVariant> DEFAULT = PALE;

    private static ResourceKey<WolfVariant> createKey(String $$0) {
        return ResourceKey.create(Registries.WOLF_VARIANT, ResourceLocation.withDefaultNamespace($$0));
    }

    static void register(BootstrapContext<WolfVariant> $$0, ResourceKey<WolfVariant> $$1, String $$2, ResourceKey<Biome> $$3) {
        WolfVariants.register($$0, $$1, $$2, HolderSet.direct($$0.lookup(Registries.BIOME).getOrThrow($$3)));
    }

    static void register(BootstrapContext<WolfVariant> $$0, ResourceKey<WolfVariant> $$1, String $$2, TagKey<Biome> $$3) {
        WolfVariants.register($$0, $$1, $$2, $$0.lookup(Registries.BIOME).getOrThrow($$3));
    }

    static void register(BootstrapContext<WolfVariant> $$0, ResourceKey<WolfVariant> $$1, String $$2, HolderSet<Biome> $$3) {
        ResourceLocation $$4 = ResourceLocation.withDefaultNamespace("entity/wolf/" + $$2);
        ResourceLocation $$5 = ResourceLocation.withDefaultNamespace("entity/wolf/" + $$2 + "_tame");
        ResourceLocation $$6 = ResourceLocation.withDefaultNamespace("entity/wolf/" + $$2 + "_angry");
        $$0.register($$1, new WolfVariant($$4, $$5, $$6, $$3));
    }

    public static Holder<WolfVariant> getSpawnVariant(RegistryAccess $$0, Holder<Biome> $$12) {
        HolderLookup.RegistryLookup $$2 = $$0.lookupOrThrow(Registries.WOLF_VARIANT);
        return $$2.listElements().filter($$1 -> ((WolfVariant)$$1.value()).biomes().contains($$12)).findFirst().or(() -> WolfVariants.lambda$getSpawnVariant$1((Registry)$$2)).or(((Registry)$$2)::getAny).orElseThrow();
    }

    public static void bootstrap(BootstrapContext<WolfVariant> $$0) {
        WolfVariants.register($$0, PALE, "wolf", Biomes.TAIGA);
        WolfVariants.register($$0, SPOTTED, "wolf_spotted", BiomeTags.IS_SAVANNA);
        WolfVariants.register($$0, SNOWY, "wolf_snowy", Biomes.GROVE);
        WolfVariants.register($$0, BLACK, "wolf_black", Biomes.OLD_GROWTH_PINE_TAIGA);
        WolfVariants.register($$0, ASHEN, "wolf_ashen", Biomes.SNOWY_TAIGA);
        WolfVariants.register($$0, RUSTY, "wolf_rusty", BiomeTags.IS_JUNGLE);
        WolfVariants.register($$0, WOODS, "wolf_woods", Biomes.FOREST);
        WolfVariants.register($$0, CHESTNUT, "wolf_chestnut", Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        WolfVariants.register($$0, STRIPED, "wolf_striped", BiomeTags.IS_BADLANDS);
    }

    private static /* synthetic */ Optional lambda$getSpawnVariant$1(Registry $$0) {
        return $$0.get(DEFAULT);
    }
}

