/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownPotion
extends ThrowableItemProjectile {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = $$0 -> $$0.isSensitiveToWater() || $$0.isOnFire();

    public ThrownPotion(EntityType<? extends ThrownPotion> $$0, Level $$1) {
        super((EntityType<? extends ThrowableItemProjectile>)$$0, $$1);
    }

    public ThrownPotion(Level $$0, LivingEntity $$1, ItemStack $$2) {
        super(EntityType.POTION, $$1, $$0, $$2);
    }

    public ThrownPotion(Level $$0, double $$1, double $$2, double $$3, ItemStack $$4) {
        super(EntityType.POTION, $$1, $$2, $$3, $$0, $$4);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(BlockHitResult $$0) {
        super.onHitBlock($$0);
        if (this.level().isClientSide) {
            return;
        }
        ItemStack $$1 = this.getItem();
        Direction $$2 = $$0.getDirection();
        BlockPos $$3 = $$0.getBlockPos();
        BlockPos $$4 = $$3.relative($$2);
        PotionContents $$5 = (PotionContents)$$1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if ($$5.is(Potions.WATER)) {
            this.dowseFire($$4);
            this.dowseFire($$4.relative($$2.getOpposite()));
            for (Direction $$6 : Direction.Plane.HORIZONTAL) {
                this.dowseFire($$4.relative($$6));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onHit(HitResult $$0) {
        void $$2;
        super.onHit($$0);
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$1 = (ServerLevel)level;
        ItemStack $$3 = this.getItem();
        PotionContents $$4 = (PotionContents)$$3.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if ($$4.is(Potions.WATER)) {
            this.applyWater((ServerLevel)$$2);
        } else if ($$4.hasEffects()) {
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud($$4);
            } else {
                this.applySplash((ServerLevel)$$2, $$4.getAllEffects(), $$0.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)$$0).getEntity() : null);
            }
        }
        int $$5 = $$4.potion().isPresent() && $$4.potion().get().value().hasInstantEffects() ? 2007 : 2002;
        $$2.levelEvent($$5, this.blockPosition(), $$4.getColor());
        this.discard();
    }

    private void applyWater(ServerLevel $$0) {
        AABB $$1 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List $$2 = this.level().getEntitiesOfClass(LivingEntity.class, $$1, WATER_SENSITIVE_OR_ON_FIRE);
        for (LivingEntity $$3 : $$2) {
            double $$4 = this.distanceToSqr($$3);
            if (!($$4 < 16.0)) continue;
            if ($$3.isSensitiveToWater()) {
                $$3.hurtServer($$0, this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!$$3.isOnFire() || !$$3.isAlive()) continue;
            $$3.extinguishFire();
        }
        List $$5 = this.level().getEntitiesOfClass(Axolotl.class, $$1);
        for (Axolotl $$6 : $$5) {
            $$6.rehydrate();
        }
    }

    private void applySplash(ServerLevel $$0, Iterable<MobEffectInstance> $$12, @Nullable Entity $$2) {
        AABB $$3 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List $$4 = $$0.getEntitiesOfClass(LivingEntity.class, $$3);
        if (!$$4.isEmpty()) {
            Entity $$5 = this.getEffectSource();
            for (LivingEntity $$6 : $$4) {
                double $$9;
                double $$7;
                if (!$$6.isAffectedByPotions() || !(($$7 = this.distanceToSqr($$6)) < 16.0)) continue;
                if ($$6 == $$2) {
                    double $$8 = 1.0;
                } else {
                    $$9 = 1.0 - Math.sqrt($$7) / 4.0;
                }
                for (MobEffectInstance $$10 : $$12) {
                    Holder<MobEffect> $$11 = $$10.getEffect();
                    if ($$11.value().isInstantenous()) {
                        $$11.value().applyInstantenousEffect($$0, this, this.getOwner(), $$6, $$10.getAmplifier(), $$9);
                        continue;
                    }
                    int $$122 = $$10.mapDuration($$1 -> (int)($$9 * (double)$$1 + 0.5));
                    MobEffectInstance $$13 = new MobEffectInstance($$11, $$122, $$10.getAmplifier(), $$10.isAmbient(), $$10.isVisible());
                    if ($$13.endsWithin(20)) continue;
                    $$6.addEffect($$13, $$5);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents $$0) {
        AreaEffectCloud $$1 = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)entity;
            $$1.setOwner($$2);
        }
        $$1.setRadius(3.0f);
        $$1.setRadiusOnUse(-0.5f);
        $$1.setWaitTime(10);
        $$1.setRadiusPerTick(-$$1.getRadius() / (float)$$1.getDuration());
        $$1.setPotionContents($$0);
        this.level().addFreshEntity($$1);
    }

    private boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPos $$0) {
        BlockState $$1 = this.level().getBlockState($$0);
        if ($$1.is(BlockTags.FIRE)) {
            this.level().destroyBlock($$0, false, this);
        } else if (AbstractCandleBlock.isLit($$1)) {
            AbstractCandleBlock.extinguish(null, $$1, this.level(), $$0);
        } else if (CampfireBlock.isLitCampfire($$1)) {
            this.level().levelEvent(null, 1009, $$0, 0);
            CampfireBlock.dowse(this.getOwner(), this.level(), $$0, $$1);
            this.level().setBlockAndUpdate($$0, (BlockState)$$1.setValue(CampfireBlock.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity $$0, DamageSource $$1) {
        double $$2 = $$0.position().x - this.position().x;
        double $$3 = $$0.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)$$2, (double)$$3);
    }
}

