/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ChargedProjectiles {
    public static final ChargedProjectiles EMPTY = new ChargedProjectiles(List.of());
    public static final Codec<ChargedProjectiles> CODEC = ItemStack.CODEC.listOf().xmap(ChargedProjectiles::new, $$0 -> $$0.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChargedProjectiles> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(ChargedProjectiles::new, $$0 -> $$0.items);
    private final List<ItemStack> items;

    private ChargedProjectiles(List<ItemStack> $$0) {
        this.items = $$0;
    }

    public static ChargedProjectiles of(ItemStack $$0) {
        return new ChargedProjectiles(List.of($$0.copy()));
    }

    public static ChargedProjectiles of(List<ItemStack> $$0) {
        return new ChargedProjectiles(List.copyOf(Lists.transform($$0, ItemStack::copy)));
    }

    public boolean contains(Item $$0) {
        for (ItemStack $$1 : this.items) {
            if (!$$1.is($$0)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getItems() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        if (!($$0 instanceof ChargedProjectiles)) return false;
        ChargedProjectiles $$1 = (ChargedProjectiles)$$0;
        if (!ItemStack.listMatches(this.items, $$1.items)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "ChargedProjectiles[items=" + String.valueOf(this.items) + "]";
    }
}

