/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public final class CustomData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomData EMPTY = new CustomData(new CompoundTag());
    private static final String TYPE_TAG = "id";
    public static final Codec<CustomData> CODEC = Codec.withAlternative(CompoundTag.CODEC, TagParser.AS_CODEC).xmap(CustomData::new, $$0 -> $$0.tag);
    public static final Codec<CustomData> CODEC_WITH_ID = CODEC.validate($$0 -> $$0.getUnsafe().contains(TYPE_TAG, 8) ? DataResult.success((Object)$$0) : DataResult.error(() -> "Missing id for entity in: " + String.valueOf($$0)));
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CustomData::new, $$0 -> $$0.tag);
    private final CompoundTag tag;

    private CustomData(CompoundTag $$0) {
        this.tag = $$0;
    }

    public static CustomData of(CompoundTag $$0) {
        return new CustomData($$0.copy());
    }

    public static Predicate<ItemStack> itemMatcher(DataComponentType<CustomData> $$0, CompoundTag $$1) {
        return $$2 -> {
            CustomData $$3 = (CustomData)$$2.getOrDefault($$0, EMPTY);
            return $$3.matchedBy($$1);
        };
    }

    public boolean matchedBy(CompoundTag $$0) {
        return NbtUtils.compareNbt($$0, this.tag, true);
    }

    public static void update(DataComponentType<CustomData> $$0, ItemStack $$1, Consumer<CompoundTag> $$2) {
        CustomData $$3 = ((CustomData)$$1.getOrDefault($$0, EMPTY)).update($$2);
        if ($$3.tag.isEmpty()) {
            $$1.remove($$0);
        } else {
            $$1.set($$0, $$3);
        }
    }

    public static void set(DataComponentType<CustomData> $$0, ItemStack $$1, CompoundTag $$2) {
        if (!$$2.isEmpty()) {
            $$1.set($$0, CustomData.of($$2));
        } else {
            $$1.remove($$0);
        }
    }

    public CustomData update(Consumer<CompoundTag> $$0) {
        CompoundTag $$1 = this.tag.copy();
        $$0.accept($$1);
        return new CustomData($$1);
    }

    @Nullable
    public ResourceLocation parseEntityId() {
        if (!this.tag.contains(TYPE_TAG, 8)) {
            return null;
        }
        return ResourceLocation.tryParse(this.tag.getString(TYPE_TAG));
    }

    @Nullable
    public <T> T parseEntityType(HolderLookup.Provider $$0, ResourceKey<? extends Registry<T>> $$1) {
        ResourceLocation $$22 = this.parseEntityId();
        if ($$22 == null) {
            return null;
        }
        return $$0.lookup($$1).flatMap($$2 -> $$2.get(ResourceKey.create($$1, $$22))).map(Holder::value).orElse(null);
    }

    public void loadInto(Entity $$0) {
        CompoundTag $$1 = $$0.saveWithoutId(new CompoundTag());
        UUID $$2 = $$0.getUUID();
        $$1.merge(this.tag);
        $$0.load($$1);
        $$0.setUUID($$2);
    }

    public boolean loadInto(BlockEntity $$0, HolderLookup.Provider $$1) {
        CompoundTag $$2 = $$0.saveCustomOnly($$1);
        CompoundTag $$3 = $$2.copy();
        $$2.merge(this.tag);
        if (!$$2.equals($$3)) {
            try {
                $$0.loadCustomOnly($$2, $$1);
                $$0.setChanged();
                return true;
            }
            catch (Exception $$4) {
                LOGGER.warn("Failed to apply custom data to block entity at {}", (Object)$$0.getBlockPos(), (Object)$$4);
                try {
                    $$0.loadCustomOnly($$3, $$1);
                }
                catch (Exception $$5) {
                    LOGGER.warn("Failed to rollback block entity at {} after failure", (Object)$$0.getBlockPos(), (Object)$$5);
                }
            }
        }
        return false;
    }

    public <T> DataResult<CustomData> update(DynamicOps<Tag> $$02, MapEncoder<T> $$1, T $$2) {
        return $$1.encode($$2, $$02, $$02.mapBuilder()).build((Object)this.tag).map($$0 -> new CustomData((CompoundTag)$$0));
    }

    public <T> DataResult<T> read(MapDecoder<T> $$0) {
        return this.read(NbtOps.INSTANCE, $$0);
    }

    public <T> DataResult<T> read(DynamicOps<Tag> $$0, MapDecoder<T> $$1) {
        MapLike $$2 = (MapLike)$$0.getMap((Object)this.tag).getOrThrow();
        return $$1.decode($$0, $$2);
    }

    public int size() {
        return this.tag.size();
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public CompoundTag copyTag() {
        return this.tag.copy();
    }

    public boolean contains(String $$0) {
        return this.tag.contains($$0);
    }

    public boolean equals(Object $$0) {
        if ($$0 == this) {
            return true;
        }
        if ($$0 instanceof CustomData) {
            CustomData $$1 = (CustomData)$$0;
            return this.tag.equals($$1.tag);
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    @Deprecated
    public CompoundTag getUnsafe() {
        return this.tag;
    }
}

