/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record DyedItemColor(int rgb, boolean showInTooltip) implements TooltipProvider
{
    private static final Codec<DyedItemColor> FULL_CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Codec.INT.fieldOf("rgb").forGetter(DyedItemColor::rgb), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(DyedItemColor::showInTooltip)).apply((Applicative)$$0, DyedItemColor::new));
    public static final Codec<DyedItemColor> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Codec.INT, $$0 -> new DyedItemColor((int)$$0, true));
    public static final StreamCodec<ByteBuf, DyedItemColor> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.INT, DyedItemColor::rgb, ByteBufCodecs.BOOL, DyedItemColor::showInTooltip, DyedItemColor::new);
    public static final int LEATHER_COLOR = -6265536;

    public static int getOrDefault(ItemStack $$0, int $$1) {
        DyedItemColor $$2 = (DyedItemColor)$$0.get(DataComponents.DYED_COLOR);
        return $$2 != null ? ARGB.opaque($$2.rgb()) : $$1;
    }

    public static ItemStack applyDyes(ItemStack $$0, List<DyeItem> $$1) {
        if (!$$0.is(ItemTags.DYEABLE)) {
            return ItemStack.EMPTY;
        }
        ItemStack $$2 = $$0.copyWithCount(1);
        int $$3 = 0;
        int $$4 = 0;
        int $$5 = 0;
        int $$6 = 0;
        int $$7 = 0;
        DyedItemColor $$8 = (DyedItemColor)$$2.get(DataComponents.DYED_COLOR);
        if ($$8 != null) {
            int $$9 = ARGB.red($$8.rgb());
            int $$10 = ARGB.green($$8.rgb());
            int $$11 = ARGB.blue($$8.rgb());
            $$6 += Math.max($$9, Math.max($$10, $$11));
            $$3 += $$9;
            $$4 += $$10;
            $$5 += $$11;
            ++$$7;
        }
        for (DyeItem $$12 : $$1) {
            int $$13 = $$12.getDyeColor().getTextureDiffuseColor();
            int $$14 = ARGB.red($$13);
            int $$15 = ARGB.green($$13);
            int $$16 = ARGB.blue($$13);
            $$6 += Math.max($$14, Math.max($$15, $$16));
            $$3 += $$14;
            $$4 += $$15;
            $$5 += $$16;
            ++$$7;
        }
        int $$17 = $$3 / $$7;
        int $$18 = $$4 / $$7;
        int $$19 = $$5 / $$7;
        float $$20 = (float)$$6 / (float)$$7;
        float $$21 = Math.max($$17, Math.max($$18, $$19));
        $$17 = (int)((float)$$17 * $$20 / $$21);
        $$18 = (int)((float)$$18 * $$20 / $$21);
        $$19 = (int)((float)$$19 * $$20 / $$21);
        int $$22 = ARGB.color(0, $$17, $$18, $$19);
        boolean $$23 = $$8 == null || $$8.showInTooltip();
        $$2.set(DataComponents.DYED_COLOR, new DyedItemColor($$22, $$23));
        return $$2;
    }

    @Override
    public void addToTooltip(Item.TooltipContext $$0, Consumer<Component> $$1, TooltipFlag $$2) {
        if (!this.showInTooltip) {
            return;
        }
        if ($$2.isAdvanced()) {
            $$1.accept(Component.translatable("item.color", String.format(Locale.ROOT, "#%06X", this.rgb)).withStyle(ChatFormatting.GRAY));
        } else {
            $$1.accept(Component.translatable("item.dyed").withStyle(ChatFormatting.GRAY, ChatFormatting.ITALIC));
        }
    }

    public DyedItemColor withTooltip(boolean $$0) {
        return new DyedItemColor(this.rgb, $$0);
    }
}

