/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public interface Spawner {
    public void setEntityId(EntityType<?> var1, RandomSource var2);

    public static void appendHoverText(ItemStack $$0, List<Component> $$1, String $$2) {
        Component $$3 = Spawner.getSpawnEntityDisplayName($$0, $$2);
        if ($$3 != null) {
            $$1.add($$3);
        } else {
            $$1.add(CommonComponents.EMPTY);
            $$1.add(Component.translatable("block.minecraft.spawner.desc1").withStyle(ChatFormatting.GRAY));
            $$1.add(CommonComponents.space().append(Component.translatable("block.minecraft.spawner.desc2").withStyle(ChatFormatting.BLUE)));
        }
    }

    @Nullable
    public static Component getSpawnEntityDisplayName(ItemStack $$02, String $$1) {
        CompoundTag $$2 = ((CustomData)$$02.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY)).getUnsafe();
        ResourceLocation $$3 = Spawner.getEntityKey($$2, $$1);
        if ($$3 != null) {
            return BuiltInRegistries.ENTITY_TYPE.getOptional($$3).map($$0 -> Component.translatable($$0.getDescriptionId()).withStyle(ChatFormatting.GRAY)).orElse(null);
        }
        return null;
    }

    @Nullable
    private static ResourceLocation getEntityKey(CompoundTag $$0, String $$1) {
        if ($$0.contains($$1, 10)) {
            String $$2 = $$0.getCompound($$1).getCompound("entity").getString("id");
            return ResourceLocation.tryParse($$2);
        }
        return null;
    }
}

