/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import org.slf4j.Logger;

public record SerializableChunkData(Registry<Biome> biomeRegistry, ChunkPos chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.Packed blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, UpgradeData upgradeData, @Nullable long[] carvingMask, Map<Heightmap.Types, long[]> heightmaps, ChunkAccess.PackedTicks packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<SectionData> sectionData, List<CompoundTag> entities, List<CompoundTag> blockEntities, CompoundTag structureData) {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    @Nullable
    public static SerializableChunkData parse(LevelHeightAccessor $$02, RegistryAccess $$1, CompoundTag $$22) {
        long[] $$14;
        BelowZeroRetrogen $$12;
        BlendingData.Packed $$10;
        if (!$$22.contains("Status", 8)) {
            return null;
        }
        ChunkPos $$3 = new ChunkPos($$22.getInt(X_POS_TAG), $$22.getInt(Z_POS_TAG));
        long $$4 = $$22.getLong("LastUpdate");
        long $$5 = $$22.getLong("InhabitedTime");
        ChunkStatus $$6 = ChunkStatus.byName($$22.getString("Status"));
        UpgradeData $$7 = $$22.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData($$22.getCompound(TAG_UPGRADE_DATA), $$02) : UpgradeData.EMPTY;
        boolean $$8 = $$22.getBoolean(IS_LIGHT_ON_TAG);
        if ($$22.contains("blending_data", 10)) {
            BlendingData.Packed $$9 = BlendingData.Packed.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$22.getCompound("blending_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
        } else {
            $$10 = null;
        }
        if ($$22.contains("below_zero_retrogen", 10)) {
            BelowZeroRetrogen $$11 = BelowZeroRetrogen.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$22.getCompound("below_zero_retrogen")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
        } else {
            $$12 = null;
        }
        if ($$22.contains("carving_mask", 12)) {
            long[] $$13 = $$22.getLongArray("carving_mask");
        } else {
            $$14 = null;
        }
        CompoundTag $$15 = $$22.getCompound(HEIGHTMAPS_TAG);
        EnumMap<Heightmap.Types, long[]> $$16 = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Heightmap.Types $$17 : $$6.heightmapsAfter()) {
            String $$18 = $$17.getSerializationKey();
            if (!$$15.contains($$18, 12)) continue;
            $$16.put($$17, $$15.getLongArray($$18));
        }
        List<SavedTick<Block>> $$19 = SavedTick.loadTickList($$22.getList(BLOCK_TICKS_TAG, 10), $$0 -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse($$0)), $$3);
        List<SavedTick<Fluid>> $$20 = SavedTick.loadTickList($$22.getList(FLUID_TICKS_TAG, 10), $$0 -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse($$0)), $$3);
        ChunkAccess.PackedTicks $$21 = new ChunkAccess.PackedTicks($$19, $$20);
        ListTag $$222 = $$22.getList("PostProcessing", 9);
        ShortList[] $$23 = new ShortList[$$222.size()];
        for (int $$24 = 0; $$24 < $$222.size(); ++$$24) {
            ListTag $$25 = $$222.getList($$24);
            ShortArrayList $$26 = new ShortArrayList($$25.size());
            for (int $$27 = 0; $$27 < $$25.size(); ++$$27) {
                $$26.add($$25.getShort($$27));
            }
            $$23[$$24] = $$26;
        }
        List $$28 = Lists.transform((List)$$22.getList("entities", 10), $$0 -> (CompoundTag)$$0);
        List $$29 = Lists.transform((List)$$22.getList("block_entities", 10), $$0 -> (CompoundTag)$$0);
        CompoundTag $$30 = $$22.getCompound("structures");
        ListTag $$31 = $$22.getList(SECTIONS_TAG, 10);
        ArrayList<SectionData> $$32 = new ArrayList<SectionData>($$31.size());
        HolderLookup.RegistryLookup $$33 = $$1.lookupOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$34 = SerializableChunkData.makeBiomeCodec((Registry<Biome>)$$33);
        for (int $$35 = 0; $$35 < $$31.size(); ++$$35) {
            LevelChunkSection $$43;
            CompoundTag $$36 = $$31.getCompound($$35);
            byte $$37 = $$36.getByte("Y");
            if ($$37 >= $$02.getMinSectionY() && $$37 <= $$02.getMaxSectionY()) {
                PalettedContainer<Holder<Biome>> $$41;
                PalettedContainer<BlockState> $$39;
                if ($$36.contains("block_states", 10)) {
                    PalettedContainer $$38 = (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$36.getCompound("block_states")).promotePartial($$2 -> SerializableChunkData.logErrors($$3, $$37, $$2)).getOrThrow(ChunkReadException::new);
                } else {
                    $$39 = new PalettedContainer<BlockState>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                }
                if ($$36.contains("biomes", 10)) {
                    PalettedContainerRO $$40 = (PalettedContainerRO)$$34.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$36.getCompound("biomes")).promotePartial($$2 -> SerializableChunkData.logErrors($$3, $$37, $$2)).getOrThrow(ChunkReadException::new);
                } else {
                    $$41 = new PalettedContainer<Holder<Biome>>($$33.asHolderIdMap(), $$33.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                }
                LevelChunkSection $$42 = new LevelChunkSection($$39, $$41);
            } else {
                $$43 = null;
            }
            DataLayer $$44 = $$36.contains(BLOCK_LIGHT_TAG, 7) ? new DataLayer($$36.getByteArray(BLOCK_LIGHT_TAG)) : null;
            DataLayer $$45 = $$36.contains(SKY_LIGHT_TAG, 7) ? new DataLayer($$36.getByteArray(SKY_LIGHT_TAG)) : null;
            $$32.add(new SectionData($$37, $$43, $$44, $$45));
        }
        return new SerializableChunkData((Registry<Biome>)$$33, $$3, $$02.getMinSectionY(), $$4, $$5, $$6, $$10, $$12, $$7, $$14, $$16, $$21, $$23, $$8, $$32, $$28, $$29, $$30);
    }

    public ProtoChunk read(ServerLevel $$0, PoiManager $$1, RegionStorageInfo $$2, ChunkPos $$3) {
        ProtoChunk $$22;
        if (!Objects.equals($$3, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{$$3, $$3, this.chunkPos});
            $$0.getServer().reportMisplacedChunk(this.chunkPos, $$3, $$2);
        }
        int $$4 = $$0.getSectionsCount();
        LevelChunkSection[] $$5 = new LevelChunkSection[$$4];
        boolean $$6 = $$0.dimensionType().hasSkyLight();
        ServerChunkCache $$7 = $$0.getChunkSource();
        LevelLightEngine $$8 = ((ChunkSource)$$7).getLightEngine();
        HolderLookup.RegistryLookup $$9 = $$0.registryAccess().lookupOrThrow(Registries.BIOME);
        boolean $$10 = false;
        for (SectionData $$11 : this.sectionData) {
            boolean $$14;
            SectionPos $$12 = SectionPos.of($$3, $$11.y);
            if ($$11.chunkSection != null) {
                $$5[$$0.getSectionIndexFromSectionY((int)$$11.y)] = $$11.chunkSection;
                $$1.checkConsistencyWithBlocks($$12, $$11.chunkSection);
            }
            boolean $$13 = $$11.blockLight != null;
            boolean bl = $$14 = $$6 && $$11.skyLight != null;
            if (!$$13 && !$$14) continue;
            if (!$$10) {
                $$8.retainData($$3, true);
                $$10 = true;
            }
            if ($$13) {
                $$8.queueSectionData(LightLayer.BLOCK, $$12, $$11.blockLight);
            }
            if (!$$14) continue;
            $$8.queueSectionData(LightLayer.SKY, $$12, $$11.skyLight);
        }
        ChunkType $$15 = this.chunkStatus.getChunkType();
        if ($$15 == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> $$16 = new LevelChunkTicks<Block>(this.packedTicks.blocks());
            LevelChunkTicks<Fluid> $$17 = new LevelChunkTicks<Fluid>(this.packedTicks.fluids());
            LevelChunk $$18 = new LevelChunk($$0.getLevel(), $$3, this.upgradeData, $$16, $$17, this.inhabitedTime, $$5, SerializableChunkData.postLoadChunk($$0, this.entities, this.blockEntities), BlendingData.unpack(this.blendingData));
        } else {
            ProtoChunk $$21;
            ProtoChunkTicks<Block> $$19 = ProtoChunkTicks.load(this.packedTicks.blocks());
            ProtoChunkTicks<Fluid> $$20 = ProtoChunkTicks.load(this.packedTicks.fluids());
            $$22 = $$21 = new ProtoChunk($$3, this.upgradeData, $$5, $$19, $$20, $$0, (Registry<Biome>)$$9, BlendingData.unpack(this.blendingData));
            $$22.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                $$21.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            $$21.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                $$21.setLightEngine($$8);
            }
        }
        $$22.setLightCorrect(this.lightCorrect);
        EnumSet<Heightmap.Types> $$23 = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types $$24 : ((ChunkAccess)$$22).getPersistedStatus().heightmapsAfter()) {
            long[] $$25 = this.heightmaps.get($$24);
            if ($$25 != null) {
                $$22.setHeightmap($$24, $$25);
                continue;
            }
            $$23.add($$24);
        }
        Heightmap.primeHeightmaps($$22, $$23);
        $$22.setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel($$0), this.structureData, $$0.getSeed()));
        $$22.setAllReferences(SerializableChunkData.unpackStructureReferences($$0.registryAccess(), $$3, this.structureData));
        for (int $$26 = 0; $$26 < this.postProcessingSections.length; ++$$26) {
            ((ChunkAccess)$$22).addPackedPostProcess(this.postProcessingSections[$$26], $$26);
        }
        if ($$15 == ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)((Object)$$22), false);
        }
        ProtoChunk $$27 = $$22;
        for (CompoundTag $$28 : this.entities) {
            $$27.addEntity($$28);
        }
        for (CompoundTag $$29 : this.blockEntities) {
            $$27.setBlockEntityNbt($$29);
        }
        if (this.carvingMask != null) {
            $$27.setCarvingMask(new CarvingMask(this.carvingMask, $$22.getMinY()));
        }
        return $$27;
    }

    private static void logErrors(ChunkPos $$0, int $$1, String $$2) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{$$0.x, $$1, $$0.z, $$2});
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> $$0) {
        return PalettedContainer.codecRO($$0.asHolderIdMap(), $$0.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, $$0.getOrThrow(Biomes.PLAINS));
    }

    public static SerializableChunkData copyOf(ServerLevel $$02, ChunkAccess $$1) {
        if (!$$1.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf($$1));
        }
        ChunkPos $$2 = $$1.getPos();
        ArrayList<SectionData> $$3 = new ArrayList<SectionData>();
        LevelChunkSection[] $$4 = $$1.getSections();
        ThreadedLevelLightEngine $$5 = $$02.getChunkSource().getLightEngine();
        for (int $$6 = $$5.getMinLightSection(); $$6 < $$5.getMaxLightSection(); ++$$6) {
            DataLayer $$12;
            int $$7 = $$1.getSectionIndexFromSectionY($$6);
            boolean $$8 = $$7 >= 0 && $$7 < $$4.length;
            DataLayer $$9 = $$5.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of($$2, $$6));
            DataLayer $$10 = $$5.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of($$2, $$6));
            DataLayer dataLayer = $$9 != null && !$$9.isEmpty() ? $$9.copy() : null;
            DataLayer dataLayer2 = $$12 = $$10 != null && !$$10.isEmpty() ? $$10.copy() : null;
            if (!$$8 && dataLayer == null && $$12 == null) continue;
            LevelChunkSection $$13 = $$8 ? $$4[$$7].copy() : null;
            $$3.add(new SectionData($$6, $$13, dataLayer, $$12));
        }
        ArrayList<CompoundTag> $$14 = new ArrayList<CompoundTag>($$1.getBlockEntitiesPos().size());
        for (BlockPos $$15 : $$1.getBlockEntitiesPos()) {
            CompoundTag $$16 = $$1.getBlockEntityNbtForSaving($$15, $$02.registryAccess());
            if ($$16 == null) continue;
            $$14.add($$16);
        }
        ArrayList<CompoundTag> $$17 = new ArrayList<CompoundTag>();
        long[] $$18 = null;
        if ($$1.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk $$19 = (ProtoChunk)$$1;
            $$17.addAll($$19.getEntities());
            CarvingMask $$20 = $$19.getCarvingMask();
            if ($$20 != null) {
                $$18 = $$20.toArray();
            }
        }
        EnumMap<Heightmap.Types, long[]> $$21 = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Map.Entry entry : $$1.getHeightmaps()) {
            if (!$$1.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            long[] $$23 = ((Heightmap)entry.getValue()).getRawData();
            $$21.put((Heightmap.Types)entry.getKey(), (long[])$$23.clone());
        }
        ChunkAccess.PackedTicks $$24 = $$1.getTicksForSerialization($$02.getGameTime());
        ShortList[] shortListArray = (ShortList[])Arrays.stream($$1.getPostProcessing()).map($$0 -> $$0 != null ? new ShortArrayList($$0) : null).toArray(ShortList[]::new);
        CompoundTag $$26 = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel($$02), $$2, $$1.getAllStarts(), $$1.getAllReferences());
        return new SerializableChunkData((Registry<Biome>)$$02.registryAccess().lookupOrThrow(Registries.BIOME), $$2, $$1.getMinSectionY(), $$02.getGameTime(), $$1.getInhabitedTime(), $$1.getPersistedStatus(), Optionull.map($$1.getBlendingData(), BlendingData::pack), $$1.getBelowZeroRetrogen(), $$1.getUpgradeData().copy(), $$18, $$21, $$24, shortListArray, $$1.isLightCorrect(), $$3, $$17, $$14, $$26);
    }

    public CompoundTag write() {
        CompoundTag $$0 = NbtUtils.addCurrentDataVersion(new CompoundTag());
        $$0.putInt(X_POS_TAG, this.chunkPos.x);
        $$0.putInt("yPos", this.minSectionY);
        $$0.putInt(Z_POS_TAG, this.chunkPos.z);
        $$0.putLong("LastUpdate", this.lastUpdateTime);
        $$0.putLong("InhabitedTime", this.inhabitedTime);
        $$0.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(this.chunkStatus).toString());
        if (this.blendingData != null) {
            BlendingData.Packed.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.blendingData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$1 -> $$0.put("blending_data", (Tag)$$1));
        }
        if (this.belowZeroRetrogen != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.belowZeroRetrogen).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$1 -> $$0.put("below_zero_retrogen", (Tag)$$1));
        }
        if (!this.upgradeData.isEmpty()) {
            $$0.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        ListTag $$12 = new ListTag();
        Codec<PalettedContainerRO<Holder<Biome>>> $$22 = SerializableChunkData.makeBiomeCodec(this.biomeRegistry);
        for (SectionData $$3 : this.sectionData) {
            CompoundTag $$4 = new CompoundTag();
            LevelChunkSection $$5 = $$3.chunkSection;
            if ($$5 != null) {
                $$4.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, $$5.getStates()).getOrThrow());
                $$4.put("biomes", (Tag)$$22.encodeStart((DynamicOps)NbtOps.INSTANCE, $$5.getBiomes()).getOrThrow());
            }
            if ($$3.blockLight != null) {
                $$4.putByteArray(BLOCK_LIGHT_TAG, $$3.blockLight.getData());
            }
            if ($$3.skyLight != null) {
                $$4.putByteArray(SKY_LIGHT_TAG, $$3.skyLight.getData());
            }
            if ($$4.isEmpty()) continue;
            $$4.putByte("Y", (byte)$$3.y);
            $$12.add($$4);
        }
        $$0.put(SECTIONS_TAG, $$12);
        if (this.lightCorrect) {
            $$0.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag $$6 = new ListTag();
        $$6.addAll(this.blockEntities);
        $$0.put("block_entities", $$6);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            ListTag $$7 = new ListTag();
            $$7.addAll(this.entities);
            $$0.put("entities", $$7);
            if (this.carvingMask != null) {
                $$0.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks($$0, this.packedTicks);
        $$0.put("PostProcessing", SerializableChunkData.packOffsets(this.postProcessingSections));
        CompoundTag $$8 = new CompoundTag();
        this.heightmaps.forEach(($$1, $$2) -> $$8.put($$1.getSerializationKey(), new LongArrayTag((long[])$$2)));
        $$0.put(HEIGHTMAPS_TAG, $$8);
        $$0.put("structures", this.structureData);
        return $$0;
    }

    private static void saveTicks(CompoundTag $$02, ChunkAccess.PackedTicks $$1) {
        ListTag $$2 = new ListTag();
        for (SavedTick<Block> $$3 : $$1.blocks()) {
            $$2.add($$3.save($$0 -> BuiltInRegistries.BLOCK.getKey((Block)$$0).toString()));
        }
        $$02.put(BLOCK_TICKS_TAG, $$2);
        ListTag $$4 = new ListTag();
        for (SavedTick<Fluid> $$5 : $$1.fluids()) {
            $$4.add($$5.save($$0 -> BuiltInRegistries.FLUID.getKey((Fluid)$$0).toString()));
        }
        $$02.put(FLUID_TICKS_TAG, $$4);
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag $$0) {
        if ($$0 != null) {
            return ChunkStatus.byName($$0.getString("Status")).getChunkType();
        }
        return ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel $$0, List<CompoundTag> $$1, List<CompoundTag> $$2) {
        if ($$1.isEmpty() && $$2.isEmpty()) {
            return null;
        }
        return $$3 -> {
            if (!$$1.isEmpty()) {
                $$0.addLegacyChunkEntities(EntityType.loadEntitiesRecursive($$1, $$0, EntitySpawnReason.LOAD));
            }
            for (CompoundTag $$4 : $$2) {
                boolean $$5 = $$4.getBoolean("keepPacked");
                if ($$5) {
                    $$3.setBlockEntityNbt($$4);
                    continue;
                }
                BlockPos $$6 = BlockEntity.getPosFromTag($$4);
                BlockEntity $$7 = BlockEntity.loadStatic($$6, $$3.getBlockState($$6), $$4, $$0.registryAccess());
                if ($$7 == null) continue;
                $$3.setBlockEntity($$7);
            }
        };
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext $$0, ChunkPos $$1, Map<Structure, StructureStart> $$2, Map<Structure, LongSet> $$3) {
        CompoundTag $$4 = new CompoundTag();
        CompoundTag $$5 = new CompoundTag();
        HolderLookup.RegistryLookup $$6 = $$0.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> $$7 : $$2.entrySet()) {
            ResourceLocation $$8 = $$6.getKey($$7.getKey());
            $$5.put($$8.toString(), $$7.getValue().createTag($$0, $$1));
        }
        $$4.put("starts", $$5);
        CompoundTag $$9 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> $$10 : $$3.entrySet()) {
            if ($$10.getValue().isEmpty()) continue;
            ResourceLocation $$11 = $$6.getKey($$10.getKey());
            $$9.put($$11.toString(), new LongArrayTag($$10.getValue()));
        }
        $$4.put("References", $$9);
        return $$4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext $$0, CompoundTag $$1, long $$2) {
        HashMap $$3 = Maps.newHashMap();
        HolderLookup.RegistryLookup $$4 = $$0.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = $$1.getCompound("starts");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = (Structure)$$4.getValue($$7);
            if ($$8 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)$$7);
                continue;
            }
            StructureStart $$9 = StructureStart.loadStaticStart($$0, $$5.getCompound($$6), $$2);
            if ($$9 == null) continue;
            $$3.put($$8, $$9);
        }
        return $$3;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess $$0, ChunkPos $$1, CompoundTag $$22) {
        HashMap $$3 = Maps.newHashMap();
        HolderLookup.RegistryLookup $$4 = $$0.lookupOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = $$22.getCompound("References");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = (Structure)$$4.getValue($$7);
            if ($$8 == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)$$7, (Object)$$1);
                continue;
            }
            long[] $$9 = $$5.getLongArray($$6);
            if ($$9.length == 0) continue;
            $$3.put($$8, new LongOpenHashSet(Arrays.stream($$9).filter($$2 -> {
                ChunkPos $$3 = new ChunkPos($$2);
                if ($$3.getChessboardDistance($$1) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{$$7, $$3, $$1});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return $$3;
    }

    private static ListTag packOffsets(ShortList[] $$0) {
        ListTag $$1 = new ListTag();
        for (ShortList $$2 : $$0) {
            ListTag $$3 = new ListTag();
            if ($$2 != null) {
                for (int $$4 = 0; $$4 < $$2.size(); ++$$4) {
                    $$3.add(ShortTag.valueOf($$2.getShort($$4)));
                }
            }
            $$1.add($$3);
        }
        return $$1;
    }

    public record SectionData(int y, @Nullable LevelChunkSection chunkSection, @Nullable DataLayer blockLight, @Nullable DataLayer skyLight) {
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String $$0) {
            super($$0);
        }
    }
}

