/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class LootPool {
    public static final Codec<LootPool> CODEC = RecordCodecBuilder.create(p_341975_ -> p_341975_.group((App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(p_297007_ -> p_297007_.entries), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(p_297008_ -> p_297008_.conditions), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(p_297009_ -> p_297009_.functions), (App)NumberProviders.CODEC.fieldOf("rolls").forGetter(p_297004_ -> p_297004_.rolls), (App)NumberProviders.CODEC.fieldOf("bonus_rolls").orElse((Object)ConstantValue.exactly(0.0f)).forGetter(p_297006_ -> p_297006_.bonusRolls), (App)Codec.STRING.optionalFieldOf("name").forGetter(p -> p.name.filter(n -> !n.startsWith("custom#"))), (App)ICondition.OPTIONAL_FEILD_CODEC.forGetter(p -> p.forge_condition)).apply((Applicative)p_341975_, LootPool::new));
    public static final Codec<LootPool> CONDITIONAL_CODEC = ConditionCodec.checkingDecode(CODEC, () -> LootPool.lootPool().build());
    private final List<LootPoolEntryContainer> entries;
    private final List<LootItemCondition> conditions;
    private final Predicate<LootContext> compositeCondition;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    private NumberProvider rolls;
    private NumberProvider bonusRolls;
    private Optional<String> name;
    private Optional<ICondition> forge_condition;
    private boolean isFrozen = false;

    LootPool(List<LootPoolEntryContainer> p_298341_, List<LootItemCondition> p_297697_, List<LootItemFunction> p_299722_, NumberProvider p_165131_, NumberProvider p_165132_) {
        this(p_298341_, p_297697_, p_299722_, p_165131_, p_165132_, Optional.empty(), Optional.empty());
    }

    LootPool(List<LootPoolEntryContainer> p_298341_, List<LootItemCondition> p_297697_, List<LootItemFunction> p_299722_, NumberProvider p_165131_, NumberProvider p_165132_, Optional<String> name, Optional<ICondition> forge_condition) {
        this.entries = p_298341_;
        this.conditions = p_297697_;
        this.compositeCondition = Util.allOf(p_297697_);
        this.functions = p_299722_;
        this.compositeFunction = LootItemFunctions.compose(p_299722_);
        this.rolls = p_165131_;
        this.bonusRolls = p_165132_;
        this.name = name;
        this.forge_condition = forge_condition;
    }

    private void addRandomItem(Consumer<ItemStack> p_79059_, LootContext p_79060_) {
        RandomSource randomsource = p_79060_.getRandom();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        for (LootPoolEntryContainer lootpoolentrycontainer : this.entries) {
            lootpoolentrycontainer.expand(p_79060_, p_79048_ -> {
                int k = p_79048_.getWeight(p_79060_.getLuck());
                if (k > 0) {
                    list.add(p_79048_);
                    mutableint.add(k);
                }
            });
        }
        int i = list.size();
        if (mutableint.intValue() != 0 && i != 0) {
            if (i == 1) {
                ((LootPoolEntry)list.get(0)).createItemStack(p_79059_, p_79060_);
            } else {
                int j = randomsource.nextInt(mutableint.intValue());
                for (LootPoolEntry lootpoolentry : list) {
                    if ((j -= lootpoolentry.getWeight(p_79060_.getLuck())) >= 0) continue;
                    lootpoolentry.createItemStack(p_79059_, p_79060_);
                    return;
                }
            }
        }
    }

    public void addRandomItems(Consumer<ItemStack> p_79054_, LootContext p_79055_) {
        if (this.compositeCondition.test(p_79055_)) {
            Consumer<ItemStack> consumer = LootItemFunction.decorate(this.compositeFunction, p_79054_, p_79055_);
            int i = this.rolls.getInt(p_79055_) + Mth.floor(this.bonusRolls.getFloat(p_79055_) * p_79055_.getLuck());
            for (int j = 0; j < i; ++j) {
                this.addRandomItem(consumer, p_79055_);
            }
        }
    }

    public void validate(ValidationContext p_79052_) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            this.conditions.get(i).validate(p_79052_.forChild(".condition[" + i + "]"));
        }
        for (int j = 0; j < this.functions.size(); ++j) {
            this.functions.get(j).validate(p_79052_.forChild(".functions[" + j + "]"));
        }
        for (int k = 0; k < this.entries.size(); ++k) {
            this.entries.get(k).validate(p_79052_.forChild(".entries[" + k + "]"));
        }
        this.rolls.validate(p_79052_.forChild(".rolls"));
        this.bonusRolls.validate(p_79052_.forChild(".bonusRolls"));
    }

    public static Builder lootPool() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootPool after being frozen!");
        }
    }

    @Nullable
    public String getName() {
        return this.name.orElse(null);
    }

    void setName(String name) {
        if (this.name.isPresent()) {
            throw new UnsupportedOperationException("Cannot change the name of a pool when it has a name set!");
        }
        this.name = Optional.of(name);
    }

    public NumberProvider getRolls() {
        return this.rolls;
    }

    public NumberProvider getBonusRolls() {
        return this.bonusRolls;
    }

    public void setRolls(NumberProvider v) {
        this.checkFrozen();
        this.rolls = v;
    }

    public void setBonusRolls(NumberProvider v) {
        this.checkFrozen();
        this.bonusRolls = v;
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> conditions = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private NumberProvider rolls = ConstantValue.exactly(1.0f);
        private NumberProvider bonusRolls = ConstantValue.exactly(0.0f);
        @Nullable
        private String name;
        @Nullable
        private ICondition forge_condition;

        public Builder setRolls(NumberProvider p_165134_) {
            this.rolls = p_165134_;
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public Builder setBonusRolls(NumberProvider p_165136_) {
            this.bonusRolls = p_165136_;
            return this;
        }

        public Builder add(LootPoolEntryContainer.Builder<?> p_79077_) {
            this.entries.add((Object)p_79077_.build());
            return this;
        }

        @Override
        public Builder when(LootItemCondition.Builder p_79081_) {
            this.conditions.add((Object)p_79081_.build());
            return this;
        }

        @Override
        public Builder apply(LootItemFunction.Builder p_79079_) {
            this.functions.add((Object)p_79079_.build());
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder when(ICondition value) {
            this.forge_condition = value;
            return this;
        }

        public LootPool build() {
            return new LootPool((List<LootPoolEntryContainer>)this.entries.build(), (List<LootItemCondition>)this.conditions.build(), (List<LootItemFunction>)this.functions.build(), this.rolls, this.bonusRolls, Optional.ofNullable(this.name), Optional.ofNullable(this.forge_condition));
        }
    }
}

