/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ToggleTooltips
extends LootItemConditionalFunction {
    private static final Map<DataComponentType<?>, ComponentToggle<?>> TOGGLES = Stream.of(new ComponentToggle<ArmorTrim>(DataComponents.TRIM, ArmorTrim::withTooltip), new ComponentToggle<DyedItemColor>(DataComponents.DYED_COLOR, DyedItemColor::withTooltip), new ComponentToggle<ItemEnchantments>(DataComponents.ENCHANTMENTS, ItemEnchantments::withTooltip), new ComponentToggle<ItemEnchantments>(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments::withTooltip), new ComponentToggle<Unbreakable>(DataComponents.UNBREAKABLE, Unbreakable::withTooltip), new ComponentToggle<AdventureModePredicate>(DataComponents.CAN_BREAK, AdventureModePredicate::withTooltip), new ComponentToggle<AdventureModePredicate>(DataComponents.CAN_PLACE_ON, AdventureModePredicate::withTooltip), new ComponentToggle<ItemAttributeModifiers>(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers::withTooltip), new ComponentToggle<JukeboxPlayable>(DataComponents.JUKEBOX_PLAYABLE, JukeboxPlayable::withTooltip)).collect(Collectors.toMap(ComponentToggle::type, $$0 -> $$0));
    private static final Codec<ComponentToggle<?>> TOGGLE_CODEC = BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().comapFlatMap($$0 -> {
        ComponentToggle<?> $$1 = TOGGLES.get($$0);
        return $$1 != null ? DataResult.success($$1) : DataResult.error(() -> "Can't toggle tooltip visiblity for " + String.valueOf(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((DataComponentType<?>)$$0)));
    }, ComponentToggle::type);
    public static final MapCodec<ToggleTooltips> CODEC = RecordCodecBuilder.mapCodec($$02 -> ToggleTooltips.commonFields($$02).and((App)Codec.unboundedMap(TOGGLE_CODEC, (Codec)Codec.BOOL).fieldOf("toggles").forGetter($$0 -> $$0.values)).apply((Applicative)$$02, ToggleTooltips::new));
    private final Map<ComponentToggle<?>, Boolean> values;

    private ToggleTooltips(List<LootItemCondition> $$0, Map<ComponentToggle<?>, Boolean> $$1) {
        super($$0);
        this.values = $$1;
    }

    @Override
    protected ItemStack run(ItemStack $$0, LootContext $$12) {
        this.values.forEach(($$1, $$2) -> $$1.applyIfPresent($$0, (boolean)$$2));
        return $$0;
    }

    public LootItemFunctionType<ToggleTooltips> getType() {
        return LootItemFunctions.TOGGLE_TOOLTIPS;
    }

    record ComponentToggle<T>(DataComponentType<T> type, TooltipWither<T> setter) {
        public void applyIfPresent(ItemStack $$0, boolean $$1) {
            Object $$2 = $$0.get(this.type);
            if ($$2 != null) {
                $$0.set(this.type, this.setter.withTooltip($$2, $$1));
            }
        }
    }

    @FunctionalInterface
    static interface TooltipWither<T> {
        public T withTooltip(T var1, boolean var2);
    }
}

