/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicFluidContainerModel
implements IUnbakedGeometry<DynamicFluidContainerModel> {
    private static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final Transformation COVER_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    private DynamicFluidContainerModel(Fluid fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return new RenderTypeGroup(RenderType.translucent(), unlit ? ForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public DynamicFluidContainerModel withFluid(Fluid newFluid) {
        return new DynamicFluidContainerModel(newFluid, this.flipGas, this.coverIsMask, this.applyFluidLuminosity);
    }

    @Override
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, TextureSlots textures, ModelState modelState) {
        List<BakedQuad> quads;
        List<BlockElement> unbaked;
        SimpleModelState transformedState;
        TextureAtlasSprite templateSprite;
        Material fluidMaskLocation = textures.getMaterial("fluid");
        Material stillMaterial = null;
        if (this.fluid != Fluids.EMPTY) {
            ResourceLocation stillTexture = IClientFluidTypeExtensions.of(this.fluid).getStillTexture();
            stillMaterial = new Material(TextureAtlas.LOCATION_BLOCKS, stillTexture);
        }
        SpriteGetter sprites = baker.sprites();
        TextureAtlasSprite baseSprite = sprites.maybeMissing(textures, "base");
        TextureAtlasSprite fluidSprite = stillMaterial == null ? null : sprites.get(stillMaterial);
        TextureAtlasSprite coverSprite = sprites.maybeMissing(textures, "cover");
        TextureAtlasSprite particleSprite = sprites.maybeMissing(textures, "particle");
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != Fluids.EMPTY && this.fluid.getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.getRotation().compose(new Transformation(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder(context).withGui3d(false).withUseBlockLight(false).build();
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder(itemContext, particleSprite, context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes(false);
        if (baseSprite != null) {
            List<BlockElement> unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements(0, baseSprite.contents());
            List<BakedQuad> quads2 = UnbakedGeometryHelper.bakeElements(unbaked2, $ -> baseSprite, modelState);
            modelBuilder.addQuads(normalRenderTypes, quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = sprites.get(fluidMaskLocation)) != null) {
            transformedState = new SimpleModelState(modelState.getRotation().compose(FLUID_TRANSFORM), modelState.isUvLocked());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(1, templateSprite.contents());
            quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> fluidSprite, transformedState);
            boolean emissive = this.applyFluidLuminosity && this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes(emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, quads);
        }
        if (coverSprite != null) {
            TextureAtlasSprite sprite;
            TextureAtlasSprite textureAtlasSprite = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                transformedState = new SimpleModelState(modelState.getRotation().compose(COVER_TRANSFORM), modelState.isUvLocked());
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(2, coverSprite.contents());
                quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> sprite, transformedState);
                modelBuilder.addQuads(normalRenderTypes, quads);
            }
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    public static final class Loader
    implements IGeometryLoader<DynamicFluidContainerModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public DynamicFluidContainerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            if (!jsonObject.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            ResourceLocation fluidName = ResourceLocation.parse((String)jsonObject.get("fluid").getAsString());
            Fluid fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
            boolean flip = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean coverIsMask = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            return new DynamicFluidContainerModel(fluid, flip, coverIsMask, applyFluidLuminosity);
        }
    }
}

