/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.lighting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.lighting.FlatQuadLighter;
import net.minecraftforge.client.model.lighting.QuadLighter;
import net.minecraftforge.client.model.lighting.SmoothQuadLighter;
import net.minecraftforge.common.ForgeConfig;

public class ForgeModelBlockRenderer
extends ModelBlockRenderer {
    private static final Direction[] SIDES = Direction.values();
    private final ThreadLocal<QuadLighter> flatLighter = ThreadLocal.withInitial(() -> new FlatQuadLighter(colors));
    private final ThreadLocal<QuadLighter> smoothLighter = ThreadLocal.withInitial(() -> new SmoothQuadLighter(colors));

    public ForgeModelBlockRenderer(BlockColors colors) {
        super(colors);
    }

    public void tesselateWithoutAO(BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer vertexConsumer, boolean checkSides, RandomSource rand, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        if (((Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            ForgeModelBlockRenderer.render(vertexConsumer, this.flatLighter.get(), level, model, state, pos, poseStack, checkSides, rand, seed, packedOverlay, modelData, renderType);
        } else {
            super.tesselateWithoutAO(level, model, state, pos, poseStack, vertexConsumer, checkSides, rand, seed, packedOverlay, modelData, renderType);
        }
    }

    public void tesselateWithAO(BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer vertexConsumer, boolean checkSides, RandomSource rand, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        if (((Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            ForgeModelBlockRenderer.render(vertexConsumer, this.smoothLighter.get(), level, model, state, pos, poseStack, checkSides, rand, seed, packedOverlay, modelData, renderType);
        } else {
            super.tesselateWithAO(level, model, state, pos, poseStack, vertexConsumer, checkSides, rand, seed, packedOverlay, modelData, renderType);
        }
    }

    public static boolean render(VertexConsumer vertexConsumer, QuadLighter lighter, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, boolean checkSides, RandomSource rand, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        ForgeModelBlockRenderer renderer = (ForgeModelBlockRenderer)Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        PoseStack.Pose pose = poseStack.last();
        boolean empty = true;
        boolean smoothLighter = lighter instanceof SmoothQuadLighter;
        QuadLighter flatLighter = null;
        rand.setSeed(seed);
        List quads = model.getQuads(state, null, rand, modelData, renderType);
        if (!quads.isEmpty()) {
            empty = false;
            lighter.setup(level, pos, state);
            for (BakedQuad quad : quads) {
                if (smoothLighter && !quad.hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = renderer.flatLighter.get();
                        flatLighter.setup(level, pos, state);
                    }
                    flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                    continue;
                }
                lighter.process(vertexConsumer, pose, quad, packedOverlay);
            }
        }
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (Direction side : SIDES) {
            mutable.setWithOffset((Vec3i)pos, side);
            if (checkSides && !Block.shouldRenderFace((BlockGetter)level, (BlockPos)pos, (BlockState)state, (BlockState)level.getBlockState((BlockPos)mutable), (Direction)side)) continue;
            rand.setSeed(seed);
            quads = model.getQuads(state, side, rand, modelData, renderType);
            if (quads.isEmpty()) continue;
            if (empty) {
                empty = false;
                lighter.setup(level, pos, state);
            }
            for (BakedQuad quad : quads) {
                if (smoothLighter && !quad.hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = renderer.flatLighter.get();
                        flatLighter.setup(level, pos, state);
                    }
                    flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                    continue;
                }
                lighter.process(vertexConsumer, pose, quad, packedOverlay);
            }
        }
        lighter.reset();
        if (flatLighter != null) {
            flatLighter.reset();
        }
        return !empty;
    }
}

