/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ForgeBiomeTagsProvider
extends BiomeTagsProvider {
    public ForgeBiomeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider lookupProvider) {
        this.tag(Tags.Biomes.NO_DEFAULT_MONSTERS).add(Biomes.MUSHROOM_FIELDS).add(Biomes.DEEP_DARK);
        this.tag(Tags.Biomes.HIDDEN_FROM_LOCATOR_SELECTION);
        this.tag(Tags.Biomes.IS_VOID).add(Biomes.THE_VOID);
        this.tag(Tags.Biomes.IS_END).addTag(BiomeTags.IS_END);
        this.tag(Tags.Biomes.IS_NETHER).addTag(BiomeTags.IS_NETHER);
        this.tag(Tags.Biomes.IS_OVERWORLD).addTag(BiomeTags.IS_OVERWORLD);
        this.tag(Tags.Biomes.IS_HOT_OVERWORLD).add(Biomes.SWAMP).add(Biomes.MANGROVE_SWAMP).add(Biomes.JUNGLE).add(Biomes.BAMBOO_JUNGLE).add(Biomes.SPARSE_JUNGLE).add(Biomes.DESERT).add(Biomes.BADLANDS).add(Biomes.WOODED_BADLANDS).add(Biomes.ERODED_BADLANDS).add(Biomes.SAVANNA).add(Biomes.SAVANNA_PLATEAU).add(Biomes.WINDSWEPT_SAVANNA).add(Biomes.STONY_PEAKS).add(Biomes.WARM_OCEAN).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"));
        this.tag(Tags.Biomes.IS_HOT_NETHER).add(Biomes.NETHER_WASTES).add(Biomes.CRIMSON_FOREST).add(Biomes.WARPED_FOREST).add(Biomes.SOUL_SAND_VALLEY).add(Biomes.BASALT_DELTAS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"));
        this.tag(Tags.Biomes.IS_HOT_END);
        this.tag(Tags.Biomes.IS_HOT).addTag(Tags.Biomes.IS_HOT_OVERWORLD).addTag(Tags.Biomes.IS_HOT_NETHER).addOptionalTag(Tags.Biomes.IS_HOT_END.location());
        this.tag(Tags.Biomes.IS_COLD_OVERWORLD).add(Biomes.TAIGA).add(Biomes.OLD_GROWTH_PINE_TAIGA).add(Biomes.OLD_GROWTH_SPRUCE_TAIGA).add(Biomes.WINDSWEPT_HILLS).add(Biomes.WINDSWEPT_GRAVELLY_HILLS).add(Biomes.WINDSWEPT_FOREST).add(Biomes.SNOWY_PLAINS).add(Biomes.ICE_SPIKES).add(Biomes.GROVE).add(Biomes.SNOWY_SLOPES).add(Biomes.JAGGED_PEAKS).add(Biomes.FROZEN_PEAKS).add(Biomes.STONY_SHORE).add(Biomes.SNOWY_BEACH).add(Biomes.SNOWY_TAIGA).add(Biomes.FROZEN_RIVER).add(Biomes.COLD_OCEAN).add(Biomes.FROZEN_OCEAN).add(Biomes.DEEP_COLD_OCEAN).add(Biomes.DEEP_FROZEN_OCEAN).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag(Tags.Biomes.IS_COLD_NETHER);
        this.tag(Tags.Biomes.IS_COLD_END).add(Biomes.THE_END).add(Biomes.SMALL_END_ISLANDS).add(Biomes.END_MIDLANDS).add(Biomes.END_HIGHLANDS).add(Biomes.END_BARRENS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"));
        this.tag(Tags.Biomes.IS_COLD).addTag(Tags.Biomes.IS_COLD_OVERWORLD).addOptionalTag(Tags.Biomes.IS_COLD_NETHER.location()).addTag(Tags.Biomes.IS_COLD_END);
        this.tag(Tags.Biomes.IS_DEAD).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dead"));
        this.tag(Tags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD).add(Biomes.WOODED_BADLANDS).add(Biomes.SAVANNA).add(Biomes.SAVANNA_PLATEAU).add(Biomes.SPARSE_JUNGLE).add(Biomes.WINDSWEPT_SAVANNA).add(Biomes.WINDSWEPT_FOREST).add(Biomes.WINDSWEPT_HILLS).add(Biomes.WINDSWEPT_GRAVELLY_HILLS).add(Biomes.SNOWY_SLOPES).add(Biomes.JAGGED_PEAKS).add(Biomes.FROZEN_PEAKS);
        this.tag(Tags.Biomes.IS_SPARSE_NETHER);
        this.tag(Tags.Biomes.IS_SPARSE_END);
        this.tag(Tags.Biomes.IS_SPARSE_VEGETATION).addTag(Tags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD).addOptionalTag(Tags.Biomes.IS_SPARSE_NETHER.location()).addOptionalTag(Tags.Biomes.IS_SPARSE_END.location());
        this.tag(Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD).add(Biomes.DARK_FOREST).add(Biomes.OLD_GROWTH_BIRCH_FOREST).add(Biomes.OLD_GROWTH_SPRUCE_TAIGA).add(Biomes.JUNGLE).add(Biomes.BAMBOO_JUNGLE).add(Biomes.MANGROVE_SWAMP).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"));
        this.tag(Tags.Biomes.IS_DENSE_NETHER);
        this.tag(Tags.Biomes.IS_DENSE_END);
        this.tag(Tags.Biomes.IS_DENSE_VEGETATION).addTag(Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD).addOptionalTag(Tags.Biomes.IS_DENSE_NETHER.location()).addOptionalTag(Tags.Biomes.IS_DENSE_END.location());
        this.tag(Tags.Biomes.IS_WET_OVERWORLD).add(Biomes.SWAMP).add(Biomes.MANGROVE_SWAMP).add(Biomes.JUNGLE).add(Biomes.BAMBOO_JUNGLE).add(Biomes.SPARSE_JUNGLE).add(Biomes.BEACH).add(Biomes.LUSH_CAVES).add(Biomes.DRIPSTONE_CAVES).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"));
        this.tag(Tags.Biomes.IS_WET_NETHER);
        this.tag(Tags.Biomes.IS_WET_END);
        this.tag(Tags.Biomes.IS_WET).addTag(Tags.Biomes.IS_WET_OVERWORLD).addOptionalTag(Tags.Biomes.IS_WET_NETHER.location()).addOptionalTag(Tags.Biomes.IS_WET_END.location());
        this.tag(Tags.Biomes.IS_DRY_OVERWORLD).add(Biomes.DESERT).add(Biomes.BADLANDS).add(Biomes.WOODED_BADLANDS).add(Biomes.ERODED_BADLANDS).add(Biomes.SAVANNA).add(Biomes.SAVANNA_PLATEAU).add(Biomes.WINDSWEPT_SAVANNA).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"));
        this.tag(Tags.Biomes.IS_DRY_NETHER).add(Biomes.NETHER_WASTES).add(Biomes.CRIMSON_FOREST).add(Biomes.WARPED_FOREST).add(Biomes.SOUL_SAND_VALLEY).add(Biomes.BASALT_DELTAS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag(Tags.Biomes.IS_DRY_END).add(Biomes.THE_END).add(Biomes.SMALL_END_ISLANDS).add(Biomes.END_MIDLANDS).add(Biomes.END_HIGHLANDS).add(Biomes.END_BARRENS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag(Tags.Biomes.IS_DRY).addTag(Tags.Biomes.IS_DRY_OVERWORLD).addTag(Tags.Biomes.IS_DRY_NETHER).addTag(Tags.Biomes.IS_DRY_END).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry"));
        this.tag(Tags.Biomes.IS_CONIFEROUS_TREE).addTag(Tags.Biomes.IS_TAIGA).add(Biomes.GROVE).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"));
        this.tag(Tags.Biomes.IS_SAVANNA_TREE).addTag(Tags.Biomes.IS_SAVANNA);
        this.tag(Tags.Biomes.IS_JUNGLE_TREE).addTag(Tags.Biomes.IS_JUNGLE);
        this.tag(Tags.Biomes.IS_DECIDUOUS_TREE).add(Biomes.FOREST).add(Biomes.FLOWER_FOREST).add(Biomes.BIRCH_FOREST).add(Biomes.DARK_FOREST).add(Biomes.OLD_GROWTH_BIRCH_FOREST).add(Biomes.WINDSWEPT_FOREST);
        this.tag(Tags.Biomes.IS_MOUNTAIN_SLOPE).add(Biomes.SNOWY_SLOPES).add(Biomes.MEADOW).add(Biomes.GROVE).add(Biomes.CHERRY_GROVE);
        this.tag(Tags.Biomes.IS_MOUNTAIN_PEAK).add(Biomes.JAGGED_PEAKS).add(Biomes.FROZEN_PEAKS).add(Biomes.STONY_PEAKS).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag(Tags.Biomes.IS_MOUNTAIN).addTag(BiomeTags.IS_MOUNTAIN).addTag(Tags.Biomes.IS_MOUNTAIN_PEAK).addTag(Tags.Biomes.IS_MOUNTAIN_SLOPE);
        this.tag(Tags.Biomes.IS_FOREST).addTag(BiomeTags.IS_FOREST);
        this.tag(Tags.Biomes.IS_BIRCH_FOREST).add(Biomes.BIRCH_FOREST).add(Biomes.OLD_GROWTH_BIRCH_FOREST);
        this.tag(Tags.Biomes.IS_FLOWER_FOREST).add(Biomes.FLOWER_FOREST);
        this.tag(Tags.Biomes.IS_FLORAL).addTag(Tags.Biomes.IS_FLOWER_FOREST).add(Biomes.SUNFLOWER_PLAINS).add(Biomes.CHERRY_GROVE).add(Biomes.MEADOW);
        this.tag(Tags.Biomes.IS_BEACH).addTag(BiomeTags.IS_BEACH);
        this.tag(Tags.Biomes.IS_STONY_SHORES).add(Biomes.STONY_SHORE);
        this.tag(Tags.Biomes.IS_DESERT).add(Biomes.DESERT);
        this.tag(Tags.Biomes.IS_BADLANDS).addTag(BiomeTags.IS_BADLANDS);
        this.tag(Tags.Biomes.IS_PLAINS).add(Biomes.PLAINS).add(Biomes.SUNFLOWER_PLAINS);
        this.tag(Tags.Biomes.IS_SNOWY_PLAINS).add(Biomes.SNOWY_PLAINS);
        this.tag(Tags.Biomes.IS_TAIGA).addTag(BiomeTags.IS_TAIGA);
        this.tag(Tags.Biomes.IS_HILL).addTag(BiomeTags.IS_HILL);
        this.tag(Tags.Biomes.IS_WINDSWEPT).add(Biomes.WINDSWEPT_HILLS).add(Biomes.WINDSWEPT_GRAVELLY_HILLS).add(Biomes.WINDSWEPT_FOREST).add(Biomes.WINDSWEPT_SAVANNA);
        this.tag(Tags.Biomes.IS_SAVANNA).addTag(BiomeTags.IS_SAVANNA);
        this.tag(Tags.Biomes.IS_JUNGLE).addTag(BiomeTags.IS_JUNGLE);
        this.tag(Tags.Biomes.IS_SNOWY).add(new ResourceKey[]{Biomes.SNOWY_BEACH, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.JAGGED_PEAKS, Biomes.FROZEN_PEAKS});
        this.tag(Tags.Biomes.IS_ICY).add(Biomes.ICE_SPIKES).add(Biomes.FROZEN_PEAKS);
        this.tag(Tags.Biomes.IS_SWAMP).add(Biomes.SWAMP).add(Biomes.MANGROVE_SWAMP);
        this.tag(Tags.Biomes.IS_OLD_GROWTH).add(Biomes.OLD_GROWTH_BIRCH_FOREST).add(Biomes.OLD_GROWTH_PINE_TAIGA).add(Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        this.tag(Tags.Biomes.IS_LUSH).add(Biomes.LUSH_CAVES);
        this.tag(Tags.Biomes.IS_MAGICAL);
        this.tag(Tags.Biomes.IS_MODIFIED);
        this.tag(Tags.Biomes.IS_SANDY).add(Biomes.DESERT).add(Biomes.BADLANDS).add(Biomes.WOODED_BADLANDS).add(Biomes.ERODED_BADLANDS).add(Biomes.BEACH);
        this.tag(Tags.Biomes.IS_MUSHROOM).add(Biomes.MUSHROOM_FIELDS);
        this.tag(Tags.Biomes.IS_PLATEAU).add(Biomes.WOODED_BADLANDS).add(Biomes.SAVANNA_PLATEAU).add(Biomes.CHERRY_GROVE).add(Biomes.MEADOW);
        this.tag(Tags.Biomes.IS_SPOOKY).add(Biomes.DARK_FOREST).add(Biomes.DEEP_DARK);
        this.tag(Tags.Biomes.IS_WASTELAND);
        this.tag(Tags.Biomes.IS_RARE).add(Biomes.SUNFLOWER_PLAINS).add(Biomes.FLOWER_FOREST).add(Biomes.OLD_GROWTH_BIRCH_FOREST).add(Biomes.OLD_GROWTH_SPRUCE_TAIGA).add(Biomes.BAMBOO_JUNGLE).add(Biomes.SPARSE_JUNGLE).add(Biomes.ERODED_BADLANDS).add(Biomes.SAVANNA_PLATEAU).add(Biomes.WINDSWEPT_SAVANNA).add(Biomes.ICE_SPIKES).add(Biomes.WINDSWEPT_GRAVELLY_HILLS).add(Biomes.MUSHROOM_FIELDS).add(Biomes.DEEP_DARK);
        this.tag(Tags.Biomes.IS_RIVER).addTag(BiomeTags.IS_RIVER);
        this.tag(Tags.Biomes.IS_SHALLOW_OCEAN).add(Biomes.OCEAN).add(Biomes.LUKEWARM_OCEAN).add(Biomes.WARM_OCEAN).add(Biomes.COLD_OCEAN).add(Biomes.FROZEN_OCEAN);
        this.tag(Tags.Biomes.IS_DEEP_OCEAN).addTag(BiomeTags.IS_DEEP_OCEAN);
        this.tag(Tags.Biomes.IS_OCEAN).addTag(BiomeTags.IS_OCEAN).addTag(Tags.Biomes.IS_SHALLOW_OCEAN).addTag(Tags.Biomes.IS_DEEP_OCEAN);
        this.tag(Tags.Biomes.IS_AQUATIC_ICY).add(Biomes.FROZEN_RIVER).add(Biomes.DEEP_FROZEN_OCEAN).add(Biomes.FROZEN_OCEAN);
        this.tag(Tags.Biomes.IS_AQUATIC).addTag(Tags.Biomes.IS_OCEAN).addTag(Tags.Biomes.IS_RIVER);
        this.tag(Tags.Biomes.IS_CAVE).add(Biomes.LUSH_CAVES).add(Biomes.DRIPSTONE_CAVES).add(Biomes.DEEP_DARK).addOptionalTag(ForgeBiomeTagsProvider.forgeTagKey("is_cave"));
        this.tag(Tags.Biomes.IS_UNDERGROUND).addTag(Tags.Biomes.IS_CAVE);
        this.tag(Tags.Biomes.IS_NETHER_FOREST).add(Biomes.CRIMSON_FOREST).add(Biomes.WARPED_FOREST);
        this.tag(Tags.Biomes.IS_OUTER_END_ISLAND).add(Biomes.END_HIGHLANDS).add(Biomes.END_MIDLANDS).add(Biomes.END_BARRENS);
        this.tag((ResourceKey<Biome>)Biomes.PLAINS, ForgeBiomeTagsProvider.forgeTagKey("is_plains"));
        this.tag((ResourceKey<Biome>)Biomes.DESERT, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sandy"), ForgeBiomeTagsProvider.forgeTagKey("is_desert"));
        this.tag((ResourceKey<Biome>)Biomes.TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"));
        this.tag((ResourceKey<Biome>)Biomes.SWAMP, ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_swamp"));
        this.tag((ResourceKey<Biome>)Biomes.NETHER_WASTES, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.THE_END, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.FROZEN_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.FROZEN_RIVER, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_PLAINS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_wasteland"), ForgeBiomeTagsProvider.forgeTagKey("is_plains"));
        this.tag((ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS, ForgeBiomeTagsProvider.forgeTagKey("is_mushroom"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.JUNGLE, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SPARSE_JUNGLE, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.BEACH, ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sandy"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_BEACH, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.DARK_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_spooky"), ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"));
        this.tag((ResourceKey<Biome>)Biomes.OLD_GROWTH_PINE_TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"));
        this.tag((ResourceKey<Biome>)Biomes.WINDSWEPT_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SAVANNA, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SAVANNA_PLATEAU, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"), Tags.Biomes.IS_PLATEAU);
        this.tag((ResourceKey<Biome>)Biomes.BADLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_sandy"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.WOODED_BADLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_sandy"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"), Tags.Biomes.IS_PLATEAU);
        this.tag((ResourceKey<Biome>)Biomes.MEADOW, ForgeBiomeTagsProvider.forgeTagKey("is_plains"), Tags.Biomes.IS_PLATEAU, ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag((ResourceKey<Biome>)Biomes.GROVE, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_coniferous"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag((ResourceKey<Biome>)Biomes.SNOWY_SLOPES, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag((ResourceKey<Biome>)Biomes.JAGGED_PEAKS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag((ResourceKey<Biome>)Biomes.FROZEN_PEAKS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag((ResourceKey<Biome>)Biomes.STONY_PEAKS, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_peak"));
        this.tag((ResourceKey<Biome>)Biomes.SMALL_END_ISLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.END_MIDLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.END_HIGHLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.END_BARRENS, ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag((ResourceKey<Biome>)Biomes.WARM_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.COLD_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.DEEP_COLD_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.DEEP_FROZEN_OCEAN, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.THE_VOID, ForgeBiomeTagsProvider.forgeTagKey("is_void"));
        this.tag((ResourceKey<Biome>)Biomes.SUNFLOWER_PLAINS, ForgeBiomeTagsProvider.forgeTagKey("is_plains"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.WINDSWEPT_GRAVELLY_HILLS, ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.FLOWER_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.ICE_SPIKES, ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_snowy"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.OLD_GROWTH_BIRCH_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.OLD_GROWTH_SPRUCE_TAIGA, ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.WINDSWEPT_SAVANNA, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.ERODED_BADLANDS, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.BAMBOO_JUNGLE, ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"));
        this.tag((ResourceKey<Biome>)Biomes.LUSH_CAVES, ForgeBiomeTagsProvider.forgeTagKey("is_cave"), ForgeBiomeTagsProvider.forgeTagKey("is_lush"), ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.DRIPSTONE_CAVES, ForgeBiomeTagsProvider.forgeTagKey("is_cave"), ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld"));
        this.tag((ResourceKey<Biome>)Biomes.SOUL_SAND_VALLEY, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.CRIMSON_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.WARPED_FOREST, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.BASALT_DELTAS, ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether"), ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether"));
        this.tag((ResourceKey<Biome>)Biomes.MANGROVE_SWAMP, ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld"), ForgeBiomeTagsProvider.forgeTagKey("is_swamp"));
        this.tag((ResourceKey<Biome>)Biomes.DEEP_DARK, ForgeBiomeTagsProvider.forgeTagKey("is_cave"), ForgeBiomeTagsProvider.forgeTagKey("is_rare"), ForgeBiomeTagsProvider.forgeTagKey("is_spooky"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_hot")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/overworld")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_hot/nether")).addOptionalTag(Tags.Biomes.IS_HOT_END.location());
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_cold")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/overworld")).addOptionalTag(Tags.Biomes.IS_COLD_NETHER.location()).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_cold/end"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_sparse")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_sparse/overworld")).addOptionalTag(Tags.Biomes.IS_SPARSE_NETHER.location()).addOptionalTag(Tags.Biomes.IS_SPARSE_END.location());
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_dense")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dense/overworld")).addOptionalTag(Tags.Biomes.IS_DENSE_NETHER.location()).addOptionalTag(Tags.Biomes.IS_DENSE_END.location());
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_wet")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_wet/overworld")).addOptionalTag(Tags.Biomes.IS_WET_NETHER.location()).addOptionalTag(Tags.Biomes.IS_WET_END.location());
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_dry")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/overworld")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/nether")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_dry/end"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_dead"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_water")).addTag(BiomeTags.IS_OCEAN).addTag(BiomeTags.IS_RIVER);
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_mountain")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_peak")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_slope"));
        this.tag(ForgeBiomeTagsProvider.forgeTagKey("is_underground")).addTag(ForgeBiomeTagsProvider.forgeTagKey("is_cave"));
    }

    @SafeVarargs
    private void tag(ResourceKey<Biome> biome, TagKey<Biome> ... tags) {
        for (TagKey<Biome> key : tags) {
            this.tag(key).add(biome);
        }
    }

    private TagsProvider.TagAppender<Biome> tagWithOptionalLegacy(TagKey<Biome> tag) {
        return this.tag(tag).addOptionalTag(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)tag.location().getPath()));
    }

    private static ResourceLocation forgeRl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path);
    }

    private static TagKey<Biome> forgeTagKey(String path) {
        return BiomeTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public String getName() {
        return "Forge Biome Tags";
    }
}

