/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.command.EnumArgument;
import net.minecraftforge.server.command.ModIdArgument;

public class ConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"config").then(ShowFile.register()));
    }

    public static class ShowFile {
        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"showfile").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"mod", (ArgumentType)ModIdArgument.modIdArgument()).then(Commands.argument((String)"type", EnumArgument.enumArgument(ModConfig.Type.class)).executes(ShowFile::showFile)));
        }

        private static int showFile(CommandContext<CommandSourceStack> context) {
            ModConfig.Type type;
            String modId = (String)context.getArgument("mod", String.class);
            String configFileName = ConfigTracker.INSTANCE.getConfigFileName(modId, type = (ModConfig.Type)context.getArgument("type", ModConfig.Type.class));
            if (configFileName != null) {
                File f = new File(configFileName);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.config.getwithtype", (Object[])new Object[]{modId, type, Component.literal((String)f.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getAbsolutePath())))}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.config.noconfig", (Object[])new Object[]{modId, type}), true);
            }
            return 0;
        }
    }
}

