// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package generictracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpf_tpAsyncIdToFdKey struct {
	PidTgid uint64
	AsyncId uint64
}

type bpf_tpCallProtocolArgsT struct {
	PidConn    bpf_tpPidConnectionInfoT
	SmallBuf   [24]uint8
	U_buf      uint64
	BytesLen   int32
	Ssl        uint8
	Direction  uint8
	OrigDport  uint16
	PacketType uint8
	Pad        [7]uint8
}

type bpf_tpConnectionInfoPartT struct {
	Addr [16]uint8
	Port uint16
	Pad  uint16
}

type bpf_tpConnectionInfoT struct {
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type bpf_tpCpSupportDataT struct {
	T_key      bpf_tpTraceKeyT
	RealClient uint8
	Pad        [7]uint8
}

type bpf_tpEgressKeyT struct {
	S_port uint16
	D_port uint16
}

type bpf_tpFdInfoT struct {
	Pid  bpf_tpPidKeyT
	Fd   int32
	Type uint32
}

type bpf_tpFdKey struct {
	PidTgid uint64
	Fd      int32
	Pad     [4]uint8
}

type bpf_tpGrpcFramesCtxT struct {
	PrevInfo        bpf_tpHttp2GrpcRequestT
	HasPrevInfo     uint8
	FoundDataFrame  uint8
	Iterations      uint8
	TerminateSearch uint8
	Pos             int32
	SavedBufPos     int32
	SavedStreamId   uint32
	Args            bpf_tpCallProtocolArgsT
	Stream          bpf_tpHttp2ConnStreamT
	Pad             [4]uint8
}

type bpf_tpHttp2ConnInfoDataT struct {
	Id    uint64
	Flags uint8
	Pad   [7]uint8
}

type bpf_tpHttp2ConnStreamT struct {
	PidConn  bpf_tpPidConnectionInfoT
	StreamId uint32
}

type bpf_tpHttp2GrpcRequestT struct {
	Flags           uint8
	Ssl             uint8
	Type            uint8
	Pad0            [1]uint8
	ConnInfo        bpf_tpConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Data            [256]uint8
	RetData         [64]uint8
	Len             int32
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	NewConnId uint64
	Tp        struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type bpf_tpHttpConnectionMetadataT struct {
	Pid struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Type uint8
	Pad  [3]uint8
}

type bpf_tpHttpInfoT struct {
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        bpf_tpConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len     uint32
	RespLen uint32
	TaskTid uint32
	Status  uint16
	Buf     [256]uint8
	Pad     [6]uint8
}

type bpf_tpMsgBufferT struct {
	Buf [256]uint8
	Pos uint16
}

type bpf_tpNodeClientRequestKey struct {
	PidTgid         uint64
	ClientRequestId uint64
}

type bpf_tpPartialConnectionInfoT struct {
	S_addr [16]uint8
	S_port uint16
	D_port uint16
	TcpSeq uint32
}

type bpf_tpPidConnectionInfoT struct {
	Conn bpf_tpConnectionInfoT
	Pid  uint32
}

type bpf_tpPidKeyT struct {
	Tid uint32
	Pid uint32
	Ns  uint32
}

type bpf_tpRecvArgsT struct {
	SockPtr  uint64
	IovecCtx [40]uint8
}

type bpf_tpSendArgsT struct {
	P_conn    bpf_tpPidConnectionInfoT
	Size      uint64
	SockPtr   uint64
	OrigDport uint16
	Pad       [6]uint8
}

type bpf_tpSkMsgBufferT struct {
	Buf      [256]uint8
	Size     uint16
	Inactive uint8
	Pad      [1]uint8
}

type bpf_tpSockArgsT struct {
	Addr       uint64
	AcceptTime uint64
	Fd         int32
	Pad        uint32
}

type bpf_tpSslArgsT struct {
	Ssl    uint64
	Buf    uint64
	LenPtr uint64
	Flags  uint64
}

type bpf_tpSslPidConnectionInfoT struct {
	P_conn    bpf_tpPidConnectionInfoT
	OrigDport uint16
	Pad       [6]uint8
}

type bpf_tpTcpReqT struct {
	Flags           uint8
	Ssl             uint8
	Direction       uint8
	Pad             [1]uint8
	ConnInfo        bpf_tpConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	Len             uint32
	ReqLen          uint32
	RespLen         uint32
	Buf             [256]uint8
	Rbuf            [128]uint8
	Pid             struct {
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Tp struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type bpf_tpTpInfoPidT struct {
	Tp struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type bpf_tpTraceKeyT struct {
	ExtraId uint64
	P_key   bpf_tpPidKeyT
	Pad     [4]uint8
}

type bpf_tpTraceMapKeyT struct {
	Conn bpf_tpConnectionInfoT
	Type uint32
}

// loadBpf_tp returns the embedded CollectionSpec for bpf_tp.
func loadBpf_tp() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_Bpf_tpBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf_tp: %w", err)
	}

	return spec, err
}

// loadBpf_tpObjects loads bpf_tp and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpf_tpObjects
//	*bpf_tpPrograms
//	*bpf_tpMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpf_tpObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf_tp()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpf_tpSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_tpSpecs struct {
	bpf_tpProgramSpecs
	bpf_tpMapSpecs
	bpf_tpVariableSpecs
}

// bpf_tpProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_tpProgramSpecs struct {
	BeylaAsyncReset                        *ebpf.ProgramSpec `ebpf:"beyla_async_reset"`
	BeylaKprobeSockRecvmsg                 *ebpf.ProgramSpec `ebpf:"beyla_kprobe_sock_recvmsg"`
	BeylaKprobeSysConnect                  *ebpf.ProgramSpec `ebpf:"beyla_kprobe_sys_connect"`
	BeylaKprobeSysExit                     *ebpf.ProgramSpec `ebpf:"beyla_kprobe_sys_exit"`
	BeylaKprobeTcpCleanupRbuf              *ebpf.ProgramSpec `ebpf:"beyla_kprobe_tcp_cleanup_rbuf"`
	BeylaKprobeTcpClose                    *ebpf.ProgramSpec `ebpf:"beyla_kprobe_tcp_close"`
	BeylaKprobeTcpConnect                  *ebpf.ProgramSpec `ebpf:"beyla_kprobe_tcp_connect"`
	BeylaKprobeTcpRateCheckAppLimited      *ebpf.ProgramSpec `ebpf:"beyla_kprobe_tcp_rate_check_app_limited"`
	BeylaKprobeTcpRcvEstablished           *ebpf.ProgramSpec `ebpf:"beyla_kprobe_tcp_rcv_established"`
	BeylaKprobeTcpRecvmsg                  *ebpf.ProgramSpec `ebpf:"beyla_kprobe_tcp_recvmsg"`
	BeylaKprobeTcpSendmsg                  *ebpf.ProgramSpec `ebpf:"beyla_kprobe_tcp_sendmsg"`
	BeylaKprobeUnixStreamRecvmsg           *ebpf.ProgramSpec `ebpf:"beyla_kprobe_unix_stream_recvmsg"`
	BeylaKprobeUnixStreamSendmsg           *ebpf.ProgramSpec `ebpf:"beyla_kprobe_unix_stream_sendmsg"`
	BeylaKretprobeSockAlloc                *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_sock_alloc"`
	BeylaKretprobeSockRecvmsg              *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_sock_recvmsg"`
	BeylaKretprobeSysAccept4               *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_sys_accept4"`
	BeylaKretprobeSysClone                 *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_sys_clone"`
	BeylaKretprobeSysConnect               *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_sys_connect"`
	BeylaKretprobeTcpRecvmsg               *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_tcp_recvmsg"`
	BeylaKretprobeTcpSendmsg               *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_tcp_sendmsg"`
	BeylaKretprobeUnixStreamRecvmsg        *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_unix_stream_recvmsg"`
	BeylaKretprobeUnixStreamSendmsg        *ebpf.ProgramSpec `ebpf:"beyla_kretprobe_unix_stream_sendmsg"`
	BeylaMakeCallback                      *ebpf.ProgramSpec `ebpf:"beyla_make_callback"`
	BeylaNgxEventConnectPeerRet            *ebpf.ProgramSpec `ebpf:"beyla_ngx_event_connect_peer_ret"`
	BeylaNgxHttpUpstreamInit               *ebpf.ProgramSpec `ebpf:"beyla_ngx_http_upstream_init"`
	BeylaOnConnection                      *ebpf.ProgramSpec `ebpf:"beyla_on_connection"`
	BeylaProtocolHttp                      *ebpf.ProgramSpec `ebpf:"beyla_protocol_http"`
	BeylaProtocolHttp2                     *ebpf.ProgramSpec `ebpf:"beyla_protocol_http2"`
	BeylaProtocolHttp2GrpcFrames           *ebpf.ProgramSpec `ebpf:"beyla_protocol_http2_grpc_frames"`
	BeylaProtocolHttp2GrpcHandleEndFrame   *ebpf.ProgramSpec `ebpf:"beyla_protocol_http2_grpc_handle_end_frame"`
	BeylaProtocolHttp2GrpcHandleStartFrame *ebpf.ProgramSpec `ebpf:"beyla_protocol_http2_grpc_handle_start_frame"`
	BeylaProtocolTcp                       *ebpf.ProgramSpec `ebpf:"beyla_protocol_tcp"`
	BeylaSocketHttpFilter                  *ebpf.ProgramSpec `ebpf:"beyla_socket__http_filter"`
	BeylaUprobeSslRead                     *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ssl_read"`
	BeylaUprobeSslReadEx                   *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ssl_read_ex"`
	BeylaUprobeSslShutdown                 *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ssl_shutdown"`
	BeylaUprobeSslWrite                    *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ssl_write"`
	BeylaUprobeSslWriteEx                  *ebpf.ProgramSpec `ebpf:"beyla_uprobe_ssl_write_ex"`
	BeylaUretprobeSslRead                  *ebpf.ProgramSpec `ebpf:"beyla_uretprobe_ssl_read"`
	BeylaUretprobeSslReadEx                *ebpf.ProgramSpec `ebpf:"beyla_uretprobe_ssl_read_ex"`
	BeylaUretprobeSslWrite                 *ebpf.ProgramSpec `ebpf:"beyla_uretprobe_ssl_write"`
	BeylaUretprobeSslWriteEx               *ebpf.ProgramSpec `ebpf:"beyla_uretprobe_ssl_write_ex"`
}

// bpf_tpMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_tpMapSpecs struct {
	ActiveAcceptArgs        *ebpf.MapSpec `ebpf:"active_accept_args"`
	ActiveConnectArgs       *ebpf.MapSpec `ebpf:"active_connect_args"`
	ActiveNodejsIds         *ebpf.MapSpec `ebpf:"active_nodejs_ids"`
	ActiveRecvArgs          *ebpf.MapSpec `ebpf:"active_recv_args"`
	ActiveSendArgs          *ebpf.MapSpec `ebpf:"active_send_args"`
	ActiveSendSockArgs      *ebpf.MapSpec `ebpf:"active_send_sock_args"`
	ActiveSslConnections    *ebpf.MapSpec `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs       *ebpf.MapSpec `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs      *ebpf.MapSpec `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks         *ebpf.MapSpec `ebpf:"active_unix_socks"`
	AsyncIdToFd             *ebpf.MapSpec `ebpf:"async_id_to_fd"`
	CloneMap                *ebpf.MapSpec `ebpf:"clone_map"`
	ConnectionMetaMem       *ebpf.MapSpec `ebpf:"connection_meta_mem"`
	CpSupportConnectInfo    *ebpf.MapSpec `ebpf:"cp_support_connect_info"`
	Events                  *ebpf.MapSpec `ebpf:"events"`
	FdMap                   *ebpf.MapSpec `ebpf:"fd_map"`
	FdToConnection          *ebpf.MapSpec `ebpf:"fd_to_connection"`
	GrpcFramesCtxMem        *ebpf.MapSpec `ebpf:"grpc_frames_ctx_mem"`
	Http2InfoMem            *ebpf.MapSpec `ebpf:"http2_info_mem"`
	HttpInfoMem             *ebpf.MapSpec `ebpf:"http_info_mem"`
	IncomingTraceMap        *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	IovecMem                *ebpf.MapSpec `ebpf:"iovec_mem"`
	JumpTable               *ebpf.MapSpec `ebpf:"jump_table"`
	MsgBuffers              *ebpf.MapSpec `ebpf:"msg_buffers"`
	NginxUpstream           *ebpf.MapSpec `ebpf:"nginx_upstream"`
	NodeClientRequests      *ebpf.MapSpec `ebpf:"node_client_requests"`
	NodeFds                 *ebpf.MapSpec `ebpf:"node_fds"`
	OngoingHttp             *ebpf.MapSpec `ebpf:"ongoing_http"`
	OngoingHttp2Connections *ebpf.MapSpec `ebpf:"ongoing_http2_connections"`
	OngoingHttp2Grpc        *ebpf.MapSpec `ebpf:"ongoing_http2_grpc"`
	OngoingTcpReq           *ebpf.MapSpec `ebpf:"ongoing_tcp_req"`
	OutgoingTraceMap        *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	PidCache                *ebpf.MapSpec `ebpf:"pid_cache"`
	PidTidToConn            *ebpf.MapSpec `ebpf:"pid_tid_to_conn"`
	ProtocolArgsMem         *ebpf.MapSpec `ebpf:"protocol_args_mem"`
	ServerTraces            *ebpf.MapSpec `ebpf:"server_traces"`
	ServerTracesAux         *ebpf.MapSpec `ebpf:"server_traces_aux"`
	SkBufferMem             *ebpf.MapSpec `ebpf:"sk_buffer_mem"`
	SkBuffers               *ebpf.MapSpec `ebpf:"sk_buffers"`
	SslToConn               *ebpf.MapSpec `ebpf:"ssl_to_conn"`
	SslToPidTid             *ebpf.MapSpec `ebpf:"ssl_to_pid_tid"`
	TcpConnectionMap        *ebpf.MapSpec `ebpf:"tcp_connection_map"`
	TcpReqMem               *ebpf.MapSpec `ebpf:"tcp_req_mem"`
	TpCharBufMem            *ebpf.MapSpec `ebpf:"tp_char_buf_mem"`
	TpInfoMem               *ebpf.MapSpec `ebpf:"tp_info_mem"`
	TraceMap                *ebpf.MapSpec `ebpf:"trace_map"`
	UpstreamInitArgs        *ebpf.MapSpec `ebpf:"upstream_init_args"`
	ValidPids               *ebpf.MapSpec `ebpf:"valid_pids"`
}

// bpf_tpVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_tpVariableSpecs struct {
	EXTEND_SIZE              *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS              *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                       *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX                *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE           *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	CaptureHeaderBuffer      *ebpf.VariableSpec `ebpf:"capture_header_buffer"`
	DisableBlackBoxCp        *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	FilterPids               *ebpf.VariableSpec `ebpf:"filter_pids"`
	HighRequestVolume        *ebpf.VariableSpec `ebpf:"high_request_volume"`
	Ip4ip6Prefix             *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	NgxConnectionS_fd        *ebpf.VariableSpec `ebpf:"ngx_connection_s_fd"`
	NgxConnectionS_sockaddr  *ebpf.VariableSpec `ebpf:"ngx_connection_s_sockaddr"`
	NgxHttpRequestS_conn     *ebpf.VariableSpec `ebpf:"ngx_http_request_s_conn"`
	NgxHttpRequestS_upstream *ebpf.VariableSpec `ebpf:"ngx_http_request_s_upstream"`
	NgxHttpRevS_conn         *ebpf.VariableSpec `ebpf:"ngx_http_rev_s_conn"`
	NgxHttpUpstreamS_conn    *ebpf.VariableSpec `ebpf:"ngx_http_upstream_s_conn"`
	Unused                   *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2              *ebpf.VariableSpec `ebpf:"unused_http2"`
	WakeupDataBytes          *ebpf.VariableSpec `ebpf:"wakeup_data_bytes"`
}

// bpf_tpObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpf_tpObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_tpObjects struct {
	bpf_tpPrograms
	bpf_tpMaps
	bpf_tpVariables
}

func (o *bpf_tpObjects) Close() error {
	return _Bpf_tpClose(
		&o.bpf_tpPrograms,
		&o.bpf_tpMaps,
	)
}

// bpf_tpMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpf_tpObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_tpMaps struct {
	ActiveAcceptArgs        *ebpf.Map `ebpf:"active_accept_args"`
	ActiveConnectArgs       *ebpf.Map `ebpf:"active_connect_args"`
	ActiveNodejsIds         *ebpf.Map `ebpf:"active_nodejs_ids"`
	ActiveRecvArgs          *ebpf.Map `ebpf:"active_recv_args"`
	ActiveSendArgs          *ebpf.Map `ebpf:"active_send_args"`
	ActiveSendSockArgs      *ebpf.Map `ebpf:"active_send_sock_args"`
	ActiveSslConnections    *ebpf.Map `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs       *ebpf.Map `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs      *ebpf.Map `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks         *ebpf.Map `ebpf:"active_unix_socks"`
	AsyncIdToFd             *ebpf.Map `ebpf:"async_id_to_fd"`
	CloneMap                *ebpf.Map `ebpf:"clone_map"`
	ConnectionMetaMem       *ebpf.Map `ebpf:"connection_meta_mem"`
	CpSupportConnectInfo    *ebpf.Map `ebpf:"cp_support_connect_info"`
	Events                  *ebpf.Map `ebpf:"events"`
	FdMap                   *ebpf.Map `ebpf:"fd_map"`
	FdToConnection          *ebpf.Map `ebpf:"fd_to_connection"`
	GrpcFramesCtxMem        *ebpf.Map `ebpf:"grpc_frames_ctx_mem"`
	Http2InfoMem            *ebpf.Map `ebpf:"http2_info_mem"`
	HttpInfoMem             *ebpf.Map `ebpf:"http_info_mem"`
	IncomingTraceMap        *ebpf.Map `ebpf:"incoming_trace_map"`
	IovecMem                *ebpf.Map `ebpf:"iovec_mem"`
	JumpTable               *ebpf.Map `ebpf:"jump_table"`
	MsgBuffers              *ebpf.Map `ebpf:"msg_buffers"`
	NginxUpstream           *ebpf.Map `ebpf:"nginx_upstream"`
	NodeClientRequests      *ebpf.Map `ebpf:"node_client_requests"`
	NodeFds                 *ebpf.Map `ebpf:"node_fds"`
	OngoingHttp             *ebpf.Map `ebpf:"ongoing_http"`
	OngoingHttp2Connections *ebpf.Map `ebpf:"ongoing_http2_connections"`
	OngoingHttp2Grpc        *ebpf.Map `ebpf:"ongoing_http2_grpc"`
	OngoingTcpReq           *ebpf.Map `ebpf:"ongoing_tcp_req"`
	OutgoingTraceMap        *ebpf.Map `ebpf:"outgoing_trace_map"`
	PidCache                *ebpf.Map `ebpf:"pid_cache"`
	PidTidToConn            *ebpf.Map `ebpf:"pid_tid_to_conn"`
	ProtocolArgsMem         *ebpf.Map `ebpf:"protocol_args_mem"`
	ServerTraces            *ebpf.Map `ebpf:"server_traces"`
	ServerTracesAux         *ebpf.Map `ebpf:"server_traces_aux"`
	SkBufferMem             *ebpf.Map `ebpf:"sk_buffer_mem"`
	SkBuffers               *ebpf.Map `ebpf:"sk_buffers"`
	SslToConn               *ebpf.Map `ebpf:"ssl_to_conn"`
	SslToPidTid             *ebpf.Map `ebpf:"ssl_to_pid_tid"`
	TcpConnectionMap        *ebpf.Map `ebpf:"tcp_connection_map"`
	TcpReqMem               *ebpf.Map `ebpf:"tcp_req_mem"`
	TpCharBufMem            *ebpf.Map `ebpf:"tp_char_buf_mem"`
	TpInfoMem               *ebpf.Map `ebpf:"tp_info_mem"`
	TraceMap                *ebpf.Map `ebpf:"trace_map"`
	UpstreamInitArgs        *ebpf.Map `ebpf:"upstream_init_args"`
	ValidPids               *ebpf.Map `ebpf:"valid_pids"`
}

func (m *bpf_tpMaps) Close() error {
	return _Bpf_tpClose(
		m.ActiveAcceptArgs,
		m.ActiveConnectArgs,
		m.ActiveNodejsIds,
		m.ActiveRecvArgs,
		m.ActiveSendArgs,
		m.ActiveSendSockArgs,
		m.ActiveSslConnections,
		m.ActiveSslReadArgs,
		m.ActiveSslWriteArgs,
		m.ActiveUnixSocks,
		m.AsyncIdToFd,
		m.CloneMap,
		m.ConnectionMetaMem,
		m.CpSupportConnectInfo,
		m.Events,
		m.FdMap,
		m.FdToConnection,
		m.GrpcFramesCtxMem,
		m.Http2InfoMem,
		m.HttpInfoMem,
		m.IncomingTraceMap,
		m.IovecMem,
		m.JumpTable,
		m.MsgBuffers,
		m.NginxUpstream,
		m.NodeClientRequests,
		m.NodeFds,
		m.OngoingHttp,
		m.OngoingHttp2Connections,
		m.OngoingHttp2Grpc,
		m.OngoingTcpReq,
		m.OutgoingTraceMap,
		m.PidCache,
		m.PidTidToConn,
		m.ProtocolArgsMem,
		m.ServerTraces,
		m.ServerTracesAux,
		m.SkBufferMem,
		m.SkBuffers,
		m.SslToConn,
		m.SslToPidTid,
		m.TcpConnectionMap,
		m.TcpReqMem,
		m.TpCharBufMem,
		m.TpInfoMem,
		m.TraceMap,
		m.UpstreamInitArgs,
		m.ValidPids,
	)
}

// bpf_tpVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpf_tpObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_tpVariables struct {
	EXTEND_SIZE              *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS              *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                       *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX                *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE           *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	CaptureHeaderBuffer      *ebpf.Variable `ebpf:"capture_header_buffer"`
	DisableBlackBoxCp        *ebpf.Variable `ebpf:"disable_black_box_cp"`
	FilterPids               *ebpf.Variable `ebpf:"filter_pids"`
	HighRequestVolume        *ebpf.Variable `ebpf:"high_request_volume"`
	Ip4ip6Prefix             *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	NgxConnectionS_fd        *ebpf.Variable `ebpf:"ngx_connection_s_fd"`
	NgxConnectionS_sockaddr  *ebpf.Variable `ebpf:"ngx_connection_s_sockaddr"`
	NgxHttpRequestS_conn     *ebpf.Variable `ebpf:"ngx_http_request_s_conn"`
	NgxHttpRequestS_upstream *ebpf.Variable `ebpf:"ngx_http_request_s_upstream"`
	NgxHttpRevS_conn         *ebpf.Variable `ebpf:"ngx_http_rev_s_conn"`
	NgxHttpUpstreamS_conn    *ebpf.Variable `ebpf:"ngx_http_upstream_s_conn"`
	Unused                   *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2              *ebpf.Variable `ebpf:"unused_http2"`
	WakeupDataBytes          *ebpf.Variable `ebpf:"wakeup_data_bytes"`
}

// bpf_tpPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpf_tpObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_tpPrograms struct {
	BeylaAsyncReset                        *ebpf.Program `ebpf:"beyla_async_reset"`
	BeylaKprobeSockRecvmsg                 *ebpf.Program `ebpf:"beyla_kprobe_sock_recvmsg"`
	BeylaKprobeSysConnect                  *ebpf.Program `ebpf:"beyla_kprobe_sys_connect"`
	BeylaKprobeSysExit                     *ebpf.Program `ebpf:"beyla_kprobe_sys_exit"`
	BeylaKprobeTcpCleanupRbuf              *ebpf.Program `ebpf:"beyla_kprobe_tcp_cleanup_rbuf"`
	BeylaKprobeTcpClose                    *ebpf.Program `ebpf:"beyla_kprobe_tcp_close"`
	BeylaKprobeTcpConnect                  *ebpf.Program `ebpf:"beyla_kprobe_tcp_connect"`
	BeylaKprobeTcpRateCheckAppLimited      *ebpf.Program `ebpf:"beyla_kprobe_tcp_rate_check_app_limited"`
	BeylaKprobeTcpRcvEstablished           *ebpf.Program `ebpf:"beyla_kprobe_tcp_rcv_established"`
	BeylaKprobeTcpRecvmsg                  *ebpf.Program `ebpf:"beyla_kprobe_tcp_recvmsg"`
	BeylaKprobeTcpSendmsg                  *ebpf.Program `ebpf:"beyla_kprobe_tcp_sendmsg"`
	BeylaKprobeUnixStreamRecvmsg           *ebpf.Program `ebpf:"beyla_kprobe_unix_stream_recvmsg"`
	BeylaKprobeUnixStreamSendmsg           *ebpf.Program `ebpf:"beyla_kprobe_unix_stream_sendmsg"`
	BeylaKretprobeSockAlloc                *ebpf.Program `ebpf:"beyla_kretprobe_sock_alloc"`
	BeylaKretprobeSockRecvmsg              *ebpf.Program `ebpf:"beyla_kretprobe_sock_recvmsg"`
	BeylaKretprobeSysAccept4               *ebpf.Program `ebpf:"beyla_kretprobe_sys_accept4"`
	BeylaKretprobeSysClone                 *ebpf.Program `ebpf:"beyla_kretprobe_sys_clone"`
	BeylaKretprobeSysConnect               *ebpf.Program `ebpf:"beyla_kretprobe_sys_connect"`
	BeylaKretprobeTcpRecvmsg               *ebpf.Program `ebpf:"beyla_kretprobe_tcp_recvmsg"`
	BeylaKretprobeTcpSendmsg               *ebpf.Program `ebpf:"beyla_kretprobe_tcp_sendmsg"`
	BeylaKretprobeUnixStreamRecvmsg        *ebpf.Program `ebpf:"beyla_kretprobe_unix_stream_recvmsg"`
	BeylaKretprobeUnixStreamSendmsg        *ebpf.Program `ebpf:"beyla_kretprobe_unix_stream_sendmsg"`
	BeylaMakeCallback                      *ebpf.Program `ebpf:"beyla_make_callback"`
	BeylaNgxEventConnectPeerRet            *ebpf.Program `ebpf:"beyla_ngx_event_connect_peer_ret"`
	BeylaNgxHttpUpstreamInit               *ebpf.Program `ebpf:"beyla_ngx_http_upstream_init"`
	BeylaOnConnection                      *ebpf.Program `ebpf:"beyla_on_connection"`
	BeylaProtocolHttp                      *ebpf.Program `ebpf:"beyla_protocol_http"`
	BeylaProtocolHttp2                     *ebpf.Program `ebpf:"beyla_protocol_http2"`
	BeylaProtocolHttp2GrpcFrames           *ebpf.Program `ebpf:"beyla_protocol_http2_grpc_frames"`
	BeylaProtocolHttp2GrpcHandleEndFrame   *ebpf.Program `ebpf:"beyla_protocol_http2_grpc_handle_end_frame"`
	BeylaProtocolHttp2GrpcHandleStartFrame *ebpf.Program `ebpf:"beyla_protocol_http2_grpc_handle_start_frame"`
	BeylaProtocolTcp                       *ebpf.Program `ebpf:"beyla_protocol_tcp"`
	BeylaSocketHttpFilter                  *ebpf.Program `ebpf:"beyla_socket__http_filter"`
	BeylaUprobeSslRead                     *ebpf.Program `ebpf:"beyla_uprobe_ssl_read"`
	BeylaUprobeSslReadEx                   *ebpf.Program `ebpf:"beyla_uprobe_ssl_read_ex"`
	BeylaUprobeSslShutdown                 *ebpf.Program `ebpf:"beyla_uprobe_ssl_shutdown"`
	BeylaUprobeSslWrite                    *ebpf.Program `ebpf:"beyla_uprobe_ssl_write"`
	BeylaUprobeSslWriteEx                  *ebpf.Program `ebpf:"beyla_uprobe_ssl_write_ex"`
	BeylaUretprobeSslRead                  *ebpf.Program `ebpf:"beyla_uretprobe_ssl_read"`
	BeylaUretprobeSslReadEx                *ebpf.Program `ebpf:"beyla_uretprobe_ssl_read_ex"`
	BeylaUretprobeSslWrite                 *ebpf.Program `ebpf:"beyla_uretprobe_ssl_write"`
	BeylaUretprobeSslWriteEx               *ebpf.Program `ebpf:"beyla_uretprobe_ssl_write_ex"`
}

func (p *bpf_tpPrograms) Close() error {
	return _Bpf_tpClose(
		p.BeylaAsyncReset,
		p.BeylaKprobeSockRecvmsg,
		p.BeylaKprobeSysConnect,
		p.BeylaKprobeSysExit,
		p.BeylaKprobeTcpCleanupRbuf,
		p.BeylaKprobeTcpClose,
		p.BeylaKprobeTcpConnect,
		p.BeylaKprobeTcpRateCheckAppLimited,
		p.BeylaKprobeTcpRcvEstablished,
		p.BeylaKprobeTcpRecvmsg,
		p.BeylaKprobeTcpSendmsg,
		p.BeylaKprobeUnixStreamRecvmsg,
		p.BeylaKprobeUnixStreamSendmsg,
		p.BeylaKretprobeSockAlloc,
		p.BeylaKretprobeSockRecvmsg,
		p.BeylaKretprobeSysAccept4,
		p.BeylaKretprobeSysClone,
		p.BeylaKretprobeSysConnect,
		p.BeylaKretprobeTcpRecvmsg,
		p.BeylaKretprobeTcpSendmsg,
		p.BeylaKretprobeUnixStreamRecvmsg,
		p.BeylaKretprobeUnixStreamSendmsg,
		p.BeylaMakeCallback,
		p.BeylaNgxEventConnectPeerRet,
		p.BeylaNgxHttpUpstreamInit,
		p.BeylaOnConnection,
		p.BeylaProtocolHttp,
		p.BeylaProtocolHttp2,
		p.BeylaProtocolHttp2GrpcFrames,
		p.BeylaProtocolHttp2GrpcHandleEndFrame,
		p.BeylaProtocolHttp2GrpcHandleStartFrame,
		p.BeylaProtocolTcp,
		p.BeylaSocketHttpFilter,
		p.BeylaUprobeSslRead,
		p.BeylaUprobeSslReadEx,
		p.BeylaUprobeSslShutdown,
		p.BeylaUprobeSslWrite,
		p.BeylaUprobeSslWriteEx,
		p.BeylaUretprobeSslRead,
		p.BeylaUretprobeSslReadEx,
		p.BeylaUretprobeSslWrite,
		p.BeylaUretprobeSslWriteEx,
	)
}

func _Bpf_tpClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_tp_x86_bpfel.o
var _Bpf_tpBytes []byte
