// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"go.opentelemetry.io/collector/confmap"
)

// ResourceAttributeConfig provides common config for a particular resource attribute.
type ResourceAttributeConfig struct {
	Enabled bool `mapstructure:"enabled"`

	enabledSetByUser bool
}

func (rac *ResourceAttributeConfig) Unmarshal(parser *confmap.Conf) error {
	if parser == nil {
		return nil
	}
	err := parser.Unmarshal(rac)
	if err != nil {
		return err
	}
	rac.enabledSetByUser = parser.IsSet("enabled")
	return nil
}

// ResourceAttributesConfig provides config for resourcedetectionprocessor/lambda resource attributes.
type ResourceAttributesConfig struct {
	AwsLogGroupNames  ResourceAttributeConfig `mapstructure:"aws.log.group.names"`
	AwsLogStreamNames ResourceAttributeConfig `mapstructure:"aws.log.stream.names"`
	CloudPlatform     ResourceAttributeConfig `mapstructure:"cloud.platform"`
	CloudProvider     ResourceAttributeConfig `mapstructure:"cloud.provider"`
	CloudRegion       ResourceAttributeConfig `mapstructure:"cloud.region"`
	FaasInstance      ResourceAttributeConfig `mapstructure:"faas.instance"`
	FaasMaxMemory     ResourceAttributeConfig `mapstructure:"faas.max_memory"`
	FaasName          ResourceAttributeConfig `mapstructure:"faas.name"`
	FaasVersion       ResourceAttributeConfig `mapstructure:"faas.version"`
}

func DefaultResourceAttributesConfig() ResourceAttributesConfig {
	return ResourceAttributesConfig{
		AwsLogGroupNames: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsLogStreamNames: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudPlatform: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudProvider: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudRegion: ResourceAttributeConfig{
			Enabled: true,
		},
		FaasInstance: ResourceAttributeConfig{
			Enabled: true,
		},
		FaasMaxMemory: ResourceAttributeConfig{
			Enabled: true,
		},
		FaasName: ResourceAttributeConfig{
			Enabled: true,
		},
		FaasVersion: ResourceAttributeConfig{
			Enabled: true,
		},
	}
}
