/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.utils.stats.BucketStats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/utils/queue/QueueStatistics;", "", "queueSize", "", "clock", "Ljava/time/Clock;", "(ILjava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "firstPacketAdded", "Ljava/time/Instant;", "queueLengthStats", "Lorg/jitsi/utils/stats/BucketStats;", "queueWaitStats", "stats", "Lorg/jitsi/utils/OrderedJsonObject;", "getStats", "()Lorg/jitsi/utils/OrderedJsonObject;", "totalPacketsAdded", "Ljava/util/concurrent/atomic/LongAdder;", "totalPacketsDropped", "totalPacketsRemoved", "added", "", "dropped", "removed", "waitTime", "Ljava/time/Duration;", "Companion", "jitsi-utils"})
@SourceDebugExtension(value={"SMAP\nQueueStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueueStatistics.kt\norg/jitsi/utils/queue/QueueStatistics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class QueueStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final LongAdder totalPacketsAdded;
    @NotNull
    private final LongAdder totalPacketsRemoved;
    @NotNull
    private final LongAdder totalPacketsDropped;
    @Nullable
    private Instant firstPacketAdded;
    @NotNull
    private final BucketStats queueLengthStats;
    @Nullable
    private final BucketStats queueWaitStats;
    @JvmField
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DEBUG;
    @JvmField
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TRACK_TIMES;
    @NotNull
    private static final ConcurrentHashMap<String, QueueStatistics> queueStatsById;
    @NotNull
    private static final List<Long> waitBucketSizes;

    public QueueStatistics(int queueSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.totalPacketsAdded = new LongAdder();
        this.totalPacketsRemoved = new LongAdder();
        this.totalPacketsDropped = new LongAdder();
        this.queueLengthStats = new BucketStats(QueueStatistics.Companion.getQueueLengthBucketSizes(queueSize), "_queue_size_at_remove", "");
        this.queueWaitStats = TRACK_TIMES ? new BucketStats(waitBucketSizes, "_queue_wait_time_ms", " ms") : null;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final OrderedJsonObject getStats() {
        OrderedJsonObject stats;
        block1: {
            stats = new OrderedJsonObject();
            Instant now = this.clock.instant();
            ((Map)stats).put("added_packets", this.totalPacketsAdded.sum());
            ((Map)stats).put("removed_packets", this.totalPacketsRemoved.sum());
            ((Map)stats).put("dropped_packets", this.totalPacketsDropped.sum());
            if (this.firstPacketAdded != null) {
                Duration duration = Duration.between(this.firstPacketAdded, now);
                double duration_s = (double)duration.toNanos() / 1.0E9;
                Double d = duration_s;
                ((Map)stats).put("duration_s", d);
                double packetsRemoved = this.totalPacketsRemoved.sum();
                ((Map)stats).put("average_remove_rate_pps", packetsRemoved / duration_s);
            }
            ((Map)stats).put("queue_size_at_remove", BucketStats.toJson$default(this.queueLengthStats, null, 1, null));
            BucketStats bucketStats = this.queueWaitStats;
            if (bucketStats == null) break block1;
            BucketStats it = bucketStats;
            boolean bl = false;
            ((Map)stats).put("queue_wait_time", BucketStats.toJson$default(it, null, 1, null));
        }
        return stats;
    }

    public final void added() {
        if (this.firstPacketAdded == null) {
            this.firstPacketAdded = this.clock.instant();
        }
        this.totalPacketsAdded.increment();
    }

    public final void removed(int queueSize, @Nullable Duration waitTime) {
        block1: {
            this.totalPacketsRemoved.increment();
            this.queueLengthStats.addValue(queueSize);
            if (waitTime == null) break block1;
            BucketStats bucketStats = this.queueWaitStats;
            if (bucketStats != null) {
                bucketStats.addValue(waitTime.toMillis());
            }
        }
    }

    public final void dropped() {
        this.totalPacketsDropped.increment();
    }

    static {
        queueStatsById = new ConcurrentHashMap();
        Object[] objectArray = new Long[]{0L, 2L, 5L, 20L, 50L, 200L, 500L, 1000L, Long.MAX_VALUE};
        waitBucketSizes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J!\u0010\u0012\u001a\u00020\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/utils/queue/QueueStatistics$Companion;", "", "()V", "DEBUG", "", "TRACK_TIMES", "queueStatsById", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jitsi/utils/queue/QueueStatistics;", "waitBucketSizes", "", "", "getQueueLengthBucketSizes", "capacity", "", "getStatistics", "Lorg/jitsi/utils/OrderedJsonObject;", "globalStatsFor", "queue", "Lorg/jitsi/utils/queue/PacketQueue;", "clock", "Ljava/time/Clock;", "globalStatsFor$jitsi_utils", "jitsi-utils"})
    @SourceDebugExtension(value={"SMAP\nQueueStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueueStatistics.kt\norg/jitsi/utils/queue/QueueStatistics$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1855#2,2:235\n*S KotlinDebug\n*F\n+ 1 QueueStatistics.kt\norg/jitsi/utils/queue/QueueStatistics$Companion\n*L\n131#1:235,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QueueStatistics globalStatsFor$jitsi_utils(@NotNull PacketQueue<?> queue, @NotNull Clock clock) {
            Intrinsics.checkNotNullParameter(queue, (String)"queue");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            QueueStatistics queueStatistics = queueStatsById.computeIfAbsent(queue.id(), arg_0 -> Companion.globalStatsFor$lambda$0((Function1)new Function1<String, QueueStatistics>(queue, clock){
                final /* synthetic */ PacketQueue<?> $queue;
                final /* synthetic */ Clock $clock;
                {
                    this.$queue = $queue;
                    this.$clock = $clock;
                    super(1);
                }

                @NotNull
                public final QueueStatistics invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new QueueStatistics(this.$queue.capacity(), this.$clock);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)queueStatistics, (String)"computeIfAbsent(...)");
            return queueStatistics;
        }

        @NotNull
        public final OrderedJsonObject getStatistics() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$getStatistics_u24lambda_u242 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            Set set = queueStatsById.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                $this$getStatistics_u24lambda_u242.put(k, ((QueueStatistics)it.getValue()).getStats());
            }
            return orderedJsonObject;
        }

        private final List<Long> getQueueLengthBucketSizes(int capacity) {
            int boundedCapacity = RangesKt.coerceAtMost((int)capacity, (int)16384);
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(0L);
            for (long i = 1L; i < (long)boundedCapacity; i *= (long)4) {
                list.add(i);
            }
            if (capacity == boundedCapacity) {
                long threeQuarters;
                long half = capacity / 2;
                if (half > ((Number)CollectionsKt.last((List)list)).longValue()) {
                    list.add(half);
                }
                if ((threeQuarters = (long)(capacity * 3 / 4)) > ((Number)CollectionsKt.last((List)list)).longValue()) {
                    list.add(threeQuarters);
                }
            } else {
                list.add(Long.valueOf(boundedCapacity));
            }
            list.add(Long.MAX_VALUE);
            return list;
        }

        private static final QueueStatistics globalStatsFor$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (QueueStatistics)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

