/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"logger", "Lorg/jitsi/utils/logging2/LoggerImpl;", "parseJidFromClientProxyJid", "Lorg/jxmpp/jid/Jid;", "clientProxy", "Lorg/jxmpp/jid/DomainBareJid;", "jid", "sendIqAndGetResponse", "Lorg/jivesoftware/smack/packet/IQ;", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "iq", "tryToSendStanza", "", "Lorg/jivesoftware/smack/XMPPConnection;", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "jicofo-common"})
public final class UtilKt {
    @NotNull
    private static final LoggerImpl logger = new LoggerImpl("org.jitsi.jicofo.xmpp.Util");

    @NotNull
    public static final Jid parseJidFromClientProxyJid(@Nullable DomainBareJid clientProxy2, @NotNull Jid jid) {
        Resourcepart resourcepart;
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        if (clientProxy2 == null) {
            return jid;
        }
        if (Intrinsics.areEqual((Object)clientProxy2, (Object)jid.asDomainBareJid()) && (resourcepart = jid.getResourceOrNull()) != null) {
            Jid jid2;
            Resourcepart resource2 = resourcepart;
            boolean bl = false;
            try {
                jid2 = JidCreate.from((String)resource2.toString());
                Intrinsics.checkNotNull((Object)jid2);
            }
            catch (XmppStringprepException e) {
                jid2 = jid;
            }
            return jid2;
        }
        return jid;
    }

    public static final void tryToSendStanza(@NotNull XMPPConnection $this$tryToSendStanza, @NotNull Stanza stanza) {
        Intrinsics.checkNotNullParameter((Object)$this$tryToSendStanza, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stanza, (String)"stanza");
        try {
            $this$tryToSendStanza.sendStanza(stanza);
        }
        catch (SmackException.NotConnectedException e) {
            CharSequence charSequence = stanza.toXML();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"toXML(...)");
            logger.error((Object)("No connection - unable to send packet: " + XmlStringBuilderUtil.Companion.toStringOpt(charSequence)), (Throwable)e);
        }
        catch (InterruptedException e) {
            CharSequence charSequence = stanza.toXML();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"toXML(...)");
            logger.error((Object)("Failed to send packet: " + XmlStringBuilderUtil.Companion.toStringOpt(charSequence)), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IQ sendIqAndGetResponse(@NotNull AbstractXMPPConnection $this$sendIqAndGetResponse, @NotNull IQ iq) throws SmackException.NotConnectedException {
        IQ iQ;
        Intrinsics.checkNotNullParameter((Object)$this$sendIqAndGetResponse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        StanzaCollector it = $this$sendIqAndGetResponse.createStanzaCollectorAndSend(iq);
        boolean bl = false;
        try {
            iQ = (IQ)it.nextResult();
        }
        finally {
            it.cancel();
        }
        return iQ;
    }
}

