/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.AddOrRemove;
import org.jitsi.jicofo.conference.ConferenceMetrics;
import org.jitsi.jicofo.conference.ConferenceUtilKt;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.conference.SourceSignaling;
import org.jitsi.jicofo.conference.SourcesToAddOrRemove;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.ValidationFailedException;
import org.jitsi.jicofo.util.Cancelable;
import org.jitsi.jicofo.util.RateLimit;
import org.jitsi.jicofo.xmpp.Features;
import org.jitsi.jicofo.xmpp.jingle.JingleIqRequestHandler;
import org.jitsi.jicofo.xmpp.jingle.JingleRequestHandler;
import org.jitsi.jicofo.xmpp.jingle.JingleSession;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.colibri2.InitialLastN;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeSessionPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.IceStatePacketExtension;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001[BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u00107\u001a\u00020\u001cJ\u000e\u00108\u001a\u0002092\u0006\u0010/\u001a\u00020:J\b\u0010;\u001a\u00020\u001fH\u0016J\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001cJ\u0006\u0010A\u001a\u00020\u001cJ\u0006\u0010B\u001a\u00020\u001cJ\u0006\u0010C\u001a\u00020\u001cJ\u0006\u0010D\u001a\u00020\u001cJ\u0006\u0010E\u001a\u00020\u001cJ\u0006\u0010F\u001a\u00020\u001cJ\u0006\u0010G\u001a\u00020\u001cJ\u0006\u0010H\u001a\u00020\u001cJ\u0006\u0010I\u001a\u00020\u001cJ\u0006\u0010J\u001a\u00020\u001cJ\u000e\u0010K\u001a\u0002092\u0006\u0010L\u001a\u00020\u0019J\u000e\u0010M\u001a\u0002092\u0006\u0010/\u001a\u00020:J\u000e\u0010N\u001a\u00020:2\u0006\u0010/\u001a\u00020:J\b\u0010O\u001a\u000209H\u0002J\u0006\u0010P\u001a\u000209J\u0010\u0010Q\u001a\u0002092\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010R\u001a\u00020\u001cJ\u0006\u0010S\u001a\u00020\u001cJ \u0010T\u001a\u0002092\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010\u00152\u0006\u0010X\u001a\u00020\u001cJ\b\u0010Y\u001a\u00020\u0015H\u0016J\u0006\u0010Z\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0013\u00103\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0017R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006\\"}, d2={"Lorg/jitsi/jicofo/conference/Participant;", "", "chatMember", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "jingleIqRequestHandler", "Lorg/jitsi/jicofo/xmpp/jingle/JingleIqRequestHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "supportedFeatures", "", "Lorg/jitsi/jicofo/xmpp/Features;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/jicofo/xmpp/jingle/JingleIqRequestHandler;Lorg/jitsi/utils/logging2/Logger;Ljava/util/Set;Ljava/time/Clock;)V", "getChatMember", "()Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;", "createdInstant", "Ljava/time/Instant;", "endpointId", "", "getEndpointId", "()Ljava/lang/String;", "inviteRunnable", "Lorg/jitsi/jicofo/util/Cancelable;", "inviteRunnableSyncRoot", "isUserParticipant", "", "()Z", "<set-?>", "Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "jingleSession", "getJingleSession", "()Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "logger", "mucJid", "Lorg/jxmpp/jid/EntityFullJid;", "getMucJid", "()Lorg/jxmpp/jid/EntityFullJid;", "restartRequestsRateLimit", "Lorg/jitsi/jicofo/util/RateLimit;", "signalQueuedSourcesTask", "Ljava/util/concurrent/ScheduledFuture;", "signalQueuedSourcesTaskSyncRoot", "sourceSignaling", "Lorg/jitsi/jicofo/conference/SourceSignaling;", "sources", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "getSources", "()Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "statId", "getStatId", "getSupportedFeatures", "()Ljava/util/Set;", "acceptRestartRequest", "addRemoteSources", "", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "createNewJingleSession", "durationSeconds", "", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "full", "hasAudioMuteSupport", "hasAudioSupport", "hasModeratorRights", "hasOpusRedSupport", "hasRembSupport", "hasRtxSupport", "hasSctpSupport", "hasSsrcRewritingSupport", "hasTccSupport", "hasVideoSupport", "inviteRunnableCompleted", "channelAllocator", "removeRemoteSources", "resetSignaledSources", "scheduleSignalingOfQueuedSources", "sendQueuedRemoteSources", "setInviteRunnable", "shouldSuppressForceMute", "supportsJsonEncodedSources", "terminateJingleSession", "reason", "Lorg/jitsi/xmpp/extensions/jingle/Reason;", "message", "sendIq", "toString", "useSsrcRewriting", "JingleRequestHandlerImpl", "jicofo"})
@SourceDebugExtension(value={"SMAP\nParticipant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Participant.kt\norg/jitsi/jicofo/conference/Participant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,528:1\n1#2:529\n*E\n"})
public class Participant {
    @NotNull
    private final ChatRoomMember chatMember;
    @NotNull
    private final JitsiMeetConferenceImpl conference;
    @NotNull
    private final JingleIqRequestHandler jingleIqRequestHandler;
    @NotNull
    private final Set<Features> supportedFeatures;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Instant createdInstant;
    @NotNull
    private final String endpointId;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SourceSignaling sourceSignaling;
    @NotNull
    private final Object inviteRunnableSyncRoot;
    @Nullable
    private Cancelable inviteRunnable;
    @NotNull
    private final RateLimit restartRequestsRateLimit;
    @Nullable
    private JingleSession jingleSession;
    @Nullable
    private ScheduledFuture<?> signalQueuedSourcesTask;
    @NotNull
    private final Object signalQueuedSourcesTaskSyncRoot;
    private final boolean isUserParticipant;
    @NotNull
    private final EntityFullJid mucJid;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler, @Nullable Logger parentLogger, @NotNull Set<? extends Features> supportedFeatures, @NotNull Clock clock) {
        void $this$logger_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)chatMember, (String)"chatMember");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)jingleIqRequestHandler, (String)"jingleIqRequestHandler");
        Intrinsics.checkNotNullParameter(supportedFeatures, (String)"supportedFeatures");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatMember = chatMember;
        this.conference = conference;
        this.jingleIqRequestHandler = jingleIqRequestHandler;
        this.supportedFeatures = supportedFeatures;
        this.clock = clock;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        this.createdInstant = instant;
        this.endpointId = this.chatMember.getName();
        Logger logger = parentLogger;
        Logger logger2 = logger != null ? logger.createChildLogger("javaClass") : null;
        Logger logger3 = logger2 = logger2 == null ? (Logger)new LoggerImpl("javaClass") : logger2;
        Participant participant = this;
        boolean bl = false;
        $this$logger_u24lambda_u240.addContext("participant", this.endpointId);
        participant.logger = logger2;
        this.sourceSignaling = new SourceSignaling(this.hasAudioSupport(), this.hasVideoSupport(), ConferenceConfig.config.stripSimulcast());
        this.inviteRunnableSyncRoot = new Object();
        this.restartRequestsRateLimit = new RateLimit(ConferenceConfig.config.getRestartRequestMinInterval(), ConferenceConfig.config.getRestartRequestMaxRequests(), ConferenceConfig.config.getRestartRequestInterval(), this.clock);
        this.signalQueuedSourcesTaskSyncRoot = new Object();
        this.isUserParticipant = !this.chatMember.isJibri() && !this.chatMember.isTranscriber() && this.chatMember.getRole() != MemberRole.VISITOR;
        this.mucJid = this.chatMember.getOccupantJid();
    }

    public /* synthetic */ Participant(ChatRoomMember chatRoomMember, JitsiMeetConferenceImpl jitsiMeetConferenceImpl, JingleIqRequestHandler jingleIqRequestHandler, Logger logger, Set set, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            logger = null;
        }
        if ((n & 0x10) != 0) {
            set = Features.Companion.getDefaultFeatures();
        }
        if ((n & 0x20) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(chatRoomMember, jitsiMeetConferenceImpl, jingleIqRequestHandler, logger, set, clock);
    }

    @NotNull
    public final ChatRoomMember getChatMember() {
        return this.chatMember;
    }

    @NotNull
    public final Set<Features> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public final double durationSeconds() {
        return (double)Duration.between(this.createdInstant, this.clock.instant()).toMillis() / 1000.0;
    }

    @NotNull
    public final String getEndpointId() {
        return this.endpointId;
    }

    public final void terminateJingleSession(@NotNull Reason reason, @Nullable String message, boolean sendIq) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        JingleSession jingleSession = this.jingleSession;
        if (jingleSession != null) {
            jingleSession.terminate(reason, message, sendIq);
        }
        this.jingleSession = null;
    }

    @Nullable
    public final JingleSession getJingleSession() {
        return this.jingleSession;
    }

    public final boolean isUserParticipant() {
        return this.isUserParticipant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInviteRunnable(@Nullable Cancelable inviteRunnable) {
        Object object = this.inviteRunnableSyncRoot;
        synchronized (object) {
            boolean bl = false;
            Cancelable cancelable = this.inviteRunnable;
            if (cancelable != null) {
                Cancelable it = cancelable;
                boolean bl2 = false;
                this.logger.warn((Object)("Canceling " + it));
                it.cancel();
            }
            this.inviteRunnable = inviteRunnable;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void inviteRunnableCompleted(@NotNull Cancelable channelAllocator) {
        Intrinsics.checkNotNullParameter((Object)channelAllocator, (String)"channelAllocator");
        Object object = this.inviteRunnableSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (this.inviteRunnable == channelAllocator) {
                this.inviteRunnable = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean hasSsrcRewritingSupport() {
        return this.supportedFeatures.contains(Features.SSRC_REWRITING_V1);
    }

    public final boolean useSsrcRewriting() {
        return ConferenceConfig.config.getUseSsrcRewriting() && this.hasSsrcRewritingSupport();
    }

    public final boolean supportsJsonEncodedSources() {
        return this.supportedFeatures.contains(Features.JSON_SOURCES);
    }

    public final boolean hasRembSupport() {
        return this.supportedFeatures.contains(Features.REMB);
    }

    public final boolean hasTccSupport() {
        return this.supportedFeatures.contains(Features.TCC);
    }

    public final boolean hasRtxSupport() {
        return this.supportedFeatures.contains(Features.RTX);
    }

    public final boolean hasOpusRedSupport() {
        return this.supportedFeatures.contains(Features.OPUS_RED);
    }

    public final boolean hasAudioSupport() {
        return this.supportedFeatures.contains(Features.AUDIO);
    }

    public final boolean hasVideoSupport() {
        return this.supportedFeatures.contains(Features.VIDEO);
    }

    public final boolean hasAudioMuteSupport() {
        return this.supportedFeatures.contains(Features.AUDIO_MUTE);
    }

    public final boolean hasSctpSupport() {
        return this.supportedFeatures.contains(Features.SCTP);
    }

    public final boolean acceptRestartRequest() {
        return this.restartRequestsRateLimit.accept();
    }

    @Nullable
    public final String getStatId() {
        return this.chatMember.getStatsId();
    }

    @NotNull
    public final EntityFullJid getMucJid() {
        return this.mucJid;
    }

    @NotNull
    public final EndpointSourceSet getSources() {
        EndpointSourceSet endpointSourceSet = this.conference.getSourcesForParticipant(this);
        Intrinsics.checkNotNullExpressionValue((Object)endpointSourceSet, (String)"getSourcesForParticipant(...)");
        return endpointSourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRemoteSources(@NotNull ConferenceSourceMap sources) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        if (this.useSsrcRewriting()) {
            return;
        }
        Object object = this.sourceSignaling;
        synchronized (object) {
            boolean $i$a$-synchronized-Participant$addRemoteSources$32 = false;
            this.sourceSignaling.addSources(sources);
            Unit $i$a$-synchronized-Participant$addRemoteSources$32 = Unit.INSTANCE;
        }
        JingleSession jingleSession = this.jingleSession;
        boolean bl = jingleSession != null ? jingleSession.isActive() : false;
        if (bl) {
            object = this.signalQueuedSourcesTaskSyncRoot;
            synchronized (object) {
                boolean bl2 = false;
                this.scheduleSignalingOfQueuedSources();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ConferenceSourceMap resetSignaledSources(@NotNull ConferenceSourceMap sources) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        SourceSignaling sourceSignaling = this.sourceSignaling;
        synchronized (sourceSignaling) {
            boolean bl = false;
            ConferenceSourceMap conferenceSourceMap = this.sourceSignaling.reset(sources);
            return conferenceSourceMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleSignalingOfQueuedSources() {
        int delayMs = ConferenceConfig.config.getSourceSignalingDelayMs(this.conference.getParticipantCount());
        Object object = this.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (this.signalQueuedSourcesTask == null) {
                this.logger.debug((Object)("Scheduling a task to signal queued remote sources after " + delayMs + " ms."));
                Instant timeOfSchedule = Instant.now();
                this.signalQueuedSourcesTask = TaskPools.Companion.getScheduledPool().schedule(() -> Participant.scheduleSignalingOfQueuedSources$lambda$9$lambda$8(timeOfSchedule, delayMs, this), (long)delayMs, TimeUnit.MILLISECONDS);
                ScheduledFuture<?> scheduledFuture = this.signalQueuedSourcesTask;
                boolean bl2 = scheduledFuture != null ? scheduledFuture.isDone() : false;
                if (bl2) {
                    this.signalQueuedSourcesTask = null;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRemoteSources(@NotNull ConferenceSourceMap sources) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        if (this.useSsrcRewriting()) {
            return;
        }
        Object object = this.sourceSignaling;
        synchronized (object) {
            boolean $i$a$-synchronized-Participant$removeRemoteSources$32 = false;
            this.sourceSignaling.removeSources(sources);
            Unit $i$a$-synchronized-Participant$removeRemoteSources$32 = Unit.INSTANCE;
        }
        JingleSession jingleSession = this.jingleSession;
        boolean bl = jingleSession != null ? jingleSession.isActive() : false;
        if (bl) {
            object = this.signalQueuedSourcesTaskSyncRoot;
            synchronized (object) {
                boolean bl2 = false;
                this.scheduleSignalingOfQueuedSources();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendQueuedRemoteSources() {
        JingleSession jingleSession;
        JingleSession jingleSession2 = jingleSession = this.jingleSession;
        if (!(jingleSession2 != null ? jingleSession2.isActive() : false)) {
            this.logger.warn((Object)"Can not signal remote sources, Jingle session not established.");
            return;
        }
        List<SourcesToAddOrRemove> modifiedSources = null;
        SourceSignaling object2 = this.sourceSignaling;
        synchronized (object2) {
            boolean $i$a$-synchronized-Participant$sendQueuedRemoteSources$232 = false;
            modifiedSources = this.sourceSignaling.update();
            Unit $i$a$-synchronized-Participant$sendQueuedRemoteSources$232 = Unit.INSTANCE;
        }
        for (SourcesToAddOrRemove sourcesToAddOrRemove : modifiedSources) {
            AddOrRemove action = sourcesToAddOrRemove.component1();
            ConferenceSourceMap sources = sourcesToAddOrRemove.component2();
            String string = action.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.logger.info((Object)("Sending a queued source-" + string + ", sources=" + sources));
            if (action == AddOrRemove.Add) {
                jingleSession.addSource(sources);
                continue;
            }
            if (action != AddOrRemove.Remove) continue;
            jingleSession.removeSource(sources);
        }
    }

    public final boolean shouldSuppressForceMute() {
        return this.chatMember.isJigasi() && !this.hasAudioMuteSupport() || this.chatMember.isJibri() || this.chatMember.getRole() == MemberRole.VISITOR;
    }

    public final boolean hasModeratorRights() {
        return MemberRoleKt.hasModeratorRights((MemberRole)this.chatMember.getRole());
    }

    @NotNull
    public String toString() {
        return "Participant[" + this.mucJid + "]";
    }

    @NotNull
    public final OrderedJsonObject getDebugState(boolean full) {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2414 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$getDebugState_u24lambda_u2414).put("id", this.endpointId);
        if (full) {
            ((Map)$this$getDebugState_u24lambda_u2414).put("source_signaling", this.sourceSignaling.getDebugState());
        }
        String string = this.getStatId();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            ((Map)$this$getDebugState_u24lambda_u2414).put("stats_id", it);
        }
        ((Map)$this$getDebugState_u24lambda_u2414).put("invite_runnable", this.inviteRunnable != null ? "Running" : "Not running");
        Map map = (Map)$this$getDebugState_u24lambda_u2414;
        String string2 = "jingle_session";
        Object object = this.jingleSession;
        if (object == null || (object = object.debugState()) == null) {
            object = "null";
        }
        Object object2 = object;
        map.put(string2, object2);
        return orderedJsonObject;
    }

    @NotNull
    public JingleSession createNewJingleSession() {
        JingleSession jingleSession;
        JingleSession jingleSession2 = this.jingleSession;
        if (jingleSession2 != null) {
            JingleSession it = jingleSession2;
            boolean bl = false;
            this.logger.info((Object)"Terminating existing jingle session");
            it.terminate(Reason.UNDEFINED, null, false);
        }
        String string = JingleIQ.generateSID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateSID(...)");
        JingleSession it = jingleSession = new JingleSession(string, (Jid)this.mucJid, this.jingleIqRequestHandler, this.chatMember.getChatRoom().getXmppProvider().getXmppConnection(), (JingleRequestHandler)new JingleRequestHandlerImpl(), ConferenceConfig.config.getUseJsonEncodedSources() && this.supportsJsonEncodedSources());
        boolean bl = false;
        this.jingleSession = it;
        return jingleSession;
    }

    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler, @Nullable Logger parentLogger, @NotNull Set<? extends Features> supportedFeatures) {
        Intrinsics.checkNotNullParameter((Object)chatMember, (String)"chatMember");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)jingleIqRequestHandler, (String)"jingleIqRequestHandler");
        Intrinsics.checkNotNullParameter(supportedFeatures, (String)"supportedFeatures");
        this(chatMember, conference, jingleIqRequestHandler, parentLogger, supportedFeatures, null, 32, null);
    }

    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler, @Nullable Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)chatMember, (String)"chatMember");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)jingleIqRequestHandler, (String)"jingleIqRequestHandler");
        this(chatMember, conference, jingleIqRequestHandler, parentLogger, null, null, 48, null);
    }

    @JvmOverloads
    public Participant(@NotNull ChatRoomMember chatMember, @NotNull JitsiMeetConferenceImpl conference, @NotNull JingleIqRequestHandler jingleIqRequestHandler) {
        Intrinsics.checkNotNullParameter((Object)chatMember, (String)"chatMember");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)jingleIqRequestHandler, (String)"jingleIqRequestHandler");
        this(chatMember, conference, jingleIqRequestHandler, null, null, null, 56, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleSignalingOfQueuedSources$lambda$9$lambda$8(Instant $timeOfSchedule, int $delayMs, Participant this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        long actualDelayMs = Duration.between($timeOfSchedule, Instant.now()).toMillis();
        if (actualDelayMs > (long)($delayMs + 3000)) {
            this$0.logger.warn((Object)("Scheduling of sources was delayed by " + actualDelayMs + " ms (expected " + $delayMs + ")"));
        }
        Object object = this$0.signalQueuedSourcesTaskSyncRoot;
        synchronized (object) {
            boolean bl = false;
            this$0.sendQueuedRemoteSources();
            this$0.signalQueuedSourcesTask = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/jicofo/conference/Participant$JingleRequestHandlerImpl;", "Lorg/jitsi/jicofo/xmpp/jingle/JingleRequestHandler;", "(Lorg/jitsi/jicofo/conference/Participant;)V", "checkJingleSession", "Lorg/jivesoftware/smack/packet/StanzaError;", "jingleSession", "Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "onAddSource", "contents", "", "Lorg/jitsi/xmpp/extensions/jingle/ContentPacketExtension;", "onRemoveSource", "onSessionAccept", "onSessionInfo", "iq", "Lorg/jitsi/xmpp/extensions/jingle/JingleIQ;", "onSessionOrTransportAccept", "action", "Lorg/jitsi/xmpp/extensions/jingle/JingleAction;", "onSessionTerminate", "onTransportAccept", "onTransportInfo", "onTransportReject", "", "jicofo"})
    @SourceDebugExtension(value={"SMAP\nParticipant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Participant.kt\norg/jitsi/jicofo/conference/Participant$JingleRequestHandlerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,528:1\n1#2:529\n*E\n"})
    private final class JingleRequestHandlerImpl
    implements JingleRequestHandler {
        private final StanzaError checkJingleSession(JingleSession jingleSession) {
            return !Intrinsics.areEqual((Object)Participant.this.getJingleSession(), (Object)jingleSession) ? StanzaError.from((StanzaError.Condition)StanzaError.Condition.item_not_found, (String)"jingle session no longer active").build() : null;
        }

        @Nullable
        public StanzaError onAddSource(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter(contents, (String)"contents");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            if (Participant.this.getChatMember().getRole() == MemberRole.VISITOR) {
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.forbidden, (String)"add-source not allowed for visitors").build();
            }
            EndpointSourceSet sourcesAdvertised = EndpointSourceSet.Companion.fromJingle(contents);
            Participant.this.logger.debug(() -> JingleRequestHandlerImpl.onAddSource$lambda$1(sourcesAdvertised));
            if (sourcesAdvertised.isEmpty()) {
                Participant.this.logger.warn((Object)"Received source-add with empty sources, ignoring");
                return null;
            }
            try {
                Participant.this.conference.addSource(Participant.this, sourcesAdvertised);
            }
            catch (JitsiMeetConferenceImpl.SenderCountExceededException e) {
                Participant.this.logger.warn((Object)("Rejecting source-add: " + e.getMessage()));
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.resource_constraint, (String)e.getMessage()).build();
            }
            catch (ValidationFailedException e) {
                Participant.this.logger.warn((Object)("Rejecting source-add: " + e.getMessage()));
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)e.getMessage()).build();
            }
            return null;
        }

        @Nullable
        public StanzaError onRemoveSource(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter(contents, (String)"contents");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            EndpointSourceSet sources = EndpointSourceSet.Companion.fromJingle(contents);
            if (sources.isEmpty()) {
                Participant.this.logger.info((Object)"Ignoring source-remove with no sources specified.");
                return null;
            }
            try {
                Participant.this.conference.removeSources(Participant.this, sources);
            }
            catch (ValidationFailedException e) {
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)e.getMessage()).build();
            }
            return null;
        }

        @Nullable
        public StanzaError onSessionAccept(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter(contents, (String)"contents");
            return this.onSessionOrTransportAccept(jingleSession, contents, JingleAction.SESSION_ACCEPT);
        }

        private final StanzaError onSessionOrTransportAccept(JingleSession jingleSession, List<? extends ContentPacketExtension> contents, JingleAction action) {
            Object v0;
            EndpointSourceSet sourcesAdvertised;
            block5: {
                if (Participant.this.getJingleSession() != null && !Intrinsics.areEqual((Object)Participant.this.getJingleSession(), (Object)jingleSession)) {
                    Participant.this.logger.error((Object)("Rejecting " + action + " for a session that has been replaced."));
                    return StanzaError.from((StanzaError.Condition)StanzaError.Condition.gone, (String)"session has been replaced").build();
                }
                Participant.this.logger.info((Object)("Received " + action));
                sourcesAdvertised = EndpointSourceSet.Companion.fromJingle(contents);
                if (!sourcesAdvertised.isEmpty() && Participant.this.getChatMember().getRole() == MemberRole.VISITOR) {
                    return StanzaError.from((StanzaError.Condition)StanzaError.Condition.forbidden, (String)"sources not allowed for visitors").build();
                }
                Iterable iterable = contents;
                for (Object t : iterable) {
                    ContentPacketExtension it = (ContentPacketExtension)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"video")) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            ContentPacketExtension contentPacketExtension = v0;
            InitialLastN initialLastN = contentPacketExtension != null ? (InitialLastN)contentPacketExtension.getChildExtension(InitialLastN.class) : null;
            try {
                Participant.this.conference.acceptSession(Participant.this, sourcesAdvertised, ConferenceUtilKt.getTransport(contents), initialLastN);
            }
            catch (ValidationFailedException e) {
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)e.getMessage()).build();
            }
            return null;
        }

        @Nullable
        public StanzaError onSessionInfo(@NotNull JingleSession jingleSession, @NotNull JingleIQ iq) {
            String iceState;
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            IceStatePacketExtension iceStatePacketExtension = (IceStatePacketExtension)iq.getExtension(IceStatePacketExtension.class);
            String string = iceState = iceStatePacketExtension != null ? iceStatePacketExtension.getText() : null;
            if (!StringsKt.equals((String)iceState, (String)"failed", (boolean)true)) {
                Participant.this.logger.info((Object)("Ignored unknown ice-state: " + iceState));
                return null;
            }
            CounterMetric.inc$default((CounterMetric)ConferenceMetrics.participantsIceFailed, null, (int)1, null);
            BridgeSessionPacketExtension bridgeSessionPacketExtension = (BridgeSessionPacketExtension)iq.getExtension(BridgeSessionPacketExtension.class);
            String bridgeSessionId = bridgeSessionPacketExtension != null ? bridgeSessionPacketExtension.getId() : null;
            Participant.this.conference.iceFailed(Participant.this, bridgeSessionId);
            return null;
        }

        @Nullable
        public StanzaError onSessionTerminate(@NotNull JingleSession jingleSession, @NotNull JingleIQ iq) {
            String bridgeSessionId;
            BridgeSessionPacketExtension bridgeSessionPacketExtension;
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return it;
            }
            BridgeSessionPacketExtension bridgeSessionPacketExtension2 = bridgeSessionPacketExtension = (BridgeSessionPacketExtension)iq.getExtension(BridgeSessionPacketExtension.class);
            Boolean bl = bridgeSessionPacketExtension2 != null ? bridgeSessionPacketExtension2.isRestart() : null;
            boolean restartRequested = bl == null ? false : bl;
            BridgeSessionPacketExtension bridgeSessionPacketExtension3 = bridgeSessionPacketExtension;
            String string = bridgeSessionId = bridgeSessionPacketExtension3 != null ? bridgeSessionPacketExtension3.getId() : null;
            if (restartRequested) {
                CounterMetric.inc$default((CounterMetric)ConferenceMetrics.participantsRequestedRestart, null, (int)1, null);
            }
            boolean reinvite = restartRequested && Participant.this.acceptRestartRequest();
            Participant.this.logger.info((Object)("Received session-terminate, bsId=" + bridgeSessionId + ", restartRequested=" + restartRequested));
            try {
                BridgeSessionPacketExtension bridgeSessionPacketExtension4 = bridgeSessionPacketExtension;
                Participant.this.conference.terminateSession(Participant.this, bridgeSessionPacketExtension4 != null ? bridgeSessionPacketExtension4.getId() : null, reinvite);
            }
            catch (JitsiMeetConferenceImpl.InvalidBridgeSessionIdException e) {
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.item_not_found, (String)e.getMessage()).build();
            }
            if (restartRequested && !reinvite) {
                Participant.this.logger.warn((Object)"Rate limiting restart request.");
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.resource_constraint, (String)"rate-limited").build();
            }
            return null;
        }

        @Nullable
        public StanzaError onTransportInfo(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter(contents, (String)"contents");
            Participant.this.logger.info((Object)"Received transport-info");
            if (Participant.this.getChatMember().isJigasi()) {
                if (Participant.this.getJingleSession() != null && !Intrinsics.areEqual((Object)Participant.this.getJingleSession(), (Object)jingleSession)) {
                    Participant.this.logger.warn((Object)"Accepting transport-info for a different (new?) jingle session");
                }
            } else {
                StanzaError stanzaError = this.checkJingleSession(jingleSession);
                if (stanzaError != null) {
                    StanzaError stanzaError2 = stanzaError;
                    Participant participant = Participant.this;
                    StanzaError it = stanzaError2;
                    boolean bl = false;
                    participant.logger.warn((Object)"Received an early or stale transport-info from non-jigasi.");
                }
            }
            IceUdpTransportPacketExtension iceUdpTransportPacketExtension = ConferenceUtilKt.getTransport(contents);
            if (iceUdpTransportPacketExtension == null) {
                return StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)"missing transport").build();
            }
            IceUdpTransportPacketExtension transport = iceUdpTransportPacketExtension;
            Participant.this.conference.updateTransport(Participant.this, transport);
            return null;
        }

        @Nullable
        public StanzaError onTransportAccept(@NotNull JingleSession jingleSession, @NotNull List<? extends ContentPacketExtension> contents) {
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter(contents, (String)"contents");
            return this.onSessionOrTransportAccept(jingleSession, contents, JingleAction.TRANSPORT_ACCEPT);
        }

        public void onTransportReject(@NotNull JingleSession jingleSession, @NotNull JingleIQ iq) {
            Intrinsics.checkNotNullParameter((Object)jingleSession, (String)"jingleSession");
            Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
            StanzaError stanzaError = this.checkJingleSession(jingleSession);
            if (stanzaError != null) {
                StanzaError it = stanzaError;
                boolean bl = false;
                return;
            }
            Participant.this.logger.warn((Object)("Received transport-reject: " + XmlStringBuilderUtil.Companion.toStringOpt((IQ)iq)));
        }

        private static final String onAddSource$lambda$1(EndpointSourceSet $sourcesAdvertised) {
            Intrinsics.checkNotNullParameter((Object)$sourcesAdvertised, (String)"$sourcesAdvertised");
            return "Received source-add: " + $sourcesAdvertised;
        }
    }
}

