/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.jigasi.JigasiDetector;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.xmpp.AbstractIqHandler;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.JigasiIqHandlerKt;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.rayo.DialIq;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002#$B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J8\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler;", "Lorg/jitsi/jicofo/xmpp/AbstractIqHandler;", "Lorg/jitsi/xmpp/extensions/rayo/DialIq;", "connections", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "jigasiDetector", "Lorg/jitsi/jicofo/jigasi/JigasiDetector;", "(Ljava/util/Set;Lorg/jitsi/jicofo/ConferenceStore;Lorg/jitsi/jicofo/jigasi/JigasiDetector;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "stanzaIdSource", "Lorg/jivesoftware/smack/packet/id/StandardStanzaIdSource;", "kotlin.jvm.PlatformType", "stats", "Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Stats;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "getStatsJson", "()Lorg/jitsi/utils/OrderedJsonObject;", "handleRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/IqRequest;", "inviteJigasi", "", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConference;", "retryCount", "", "exclude", "", "Lorg/jxmpp/jid/Jid;", "Companion", "Stats", "jicofo"})
@SourceDebugExtension(value={"SMAP\nJigasiIqHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JigasiIqHandler.kt\norg/jitsi/jicofo/xmpp/JigasiIqHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1#2:260\n*E\n"})
public final class JigasiIqHandler
extends AbstractIqHandler<DialIq> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final JigasiDetector jigasiDetector;
    @NotNull
    private final Logger logger;
    private final StandardStanzaIdSource stanzaIdSource;
    @NotNull
    private final Stats stats;
    @NotNull
    private static final StandardStanzaIdSource.Factory stanzaIdSourceFactory = new StandardStanzaIdSource.Factory();

    public JigasiIqHandler(@NotNull Set<? extends AbstractXMPPConnection> connections, @NotNull ConferenceStore conferenceStore, @NotNull JigasiDetector jigasiDetector2) {
        Intrinsics.checkNotNullParameter(connections, (String)"connections");
        Intrinsics.checkNotNullParameter((Object)conferenceStore, (String)"conferenceStore");
        Intrinsics.checkNotNullParameter((Object)((Object)jigasiDetector2), (String)"jigasiDetector");
        super(connections, "dial", "urn:xmpp:rayo:1", SetsKt.setOf((Object)IQ.Type.set), null, 16, null);
        this.conferenceStore = conferenceStore;
        this.jigasiDetector = jigasiDetector2;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)((Object)this), null, null, (int)3, null);
        this.stanzaIdSource = stanzaIdSourceFactory.constructStanzaIdSource();
        this.stats = new Stats();
    }

    @NotNull
    public final OrderedJsonObject getStatsJson() {
        return this.stats.toJson();
    }

    @NotNull
    public IqProcessingResult handleRequest(@NotNull IqRequest<DialIq> request) {
        JitsiMeetConference conference;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        EntityBareJid entityBareJid = ((DialIq)request.getIq()).getFrom().asEntityBareJidIfPossible();
        if (entityBareJid == null) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.bad_request);
            boolean bl = false;
            this.logger.warn((Object)("Rejected request with invalid conferenceJid: " + ((DialIq)request.getIq()).getFrom()));
            CounterMetric.inc$default((CounterMetric)Stats.Companion.getRejectedRequests(), null, (int)1, null);
            return (IqProcessingResult)rejectedWithError;
        }
        EntityBareJid conferenceJid = entityBareJid;
        JitsiMeetConference jitsiMeetConference = this.conferenceStore.getConference(conferenceJid);
        if (jitsiMeetConference == null) {
            Object v1;
            block6: {
                Iterable iterable = this.conferenceStore.getAllConferences();
                for (Object t : iterable) {
                    JitsiMeetConference c = (JitsiMeetConference)t;
                    boolean bl = false;
                    if (!c.getVisitorRoomsJids().contains(conferenceJid)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            if ((jitsiMeetConference = (JitsiMeetConference)v1) == null) {
                IqProcessingResult.RejectedWithError bl;
                IqProcessingResult.RejectedWithError it = bl = new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.item_not_found);
                boolean bl2 = false;
                this.logger.warn((Object)("Rejected request for non-existent conference: " + conferenceJid));
                CounterMetric.inc$default((CounterMetric)Stats.Companion.getRejectedRequests(), null, (int)1, null);
                return (IqProcessingResult)bl;
            }
        }
        if (!(conference = jitsiMeetConference).acceptJigasiRequest(((DialIq)request.getIq()).getFrom())) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.forbidden);
            boolean bl = false;
            this.logger.warn((Object)("Rejected request from unauthorized user: " + ((DialIq)request.getIq()).getFrom()));
            CounterMetric.inc$default((CounterMetric)Stats.Companion.getRejectedRequests(), null, (int)1, null);
            return (IqProcessingResult)rejectedWithError;
        }
        String roomNameHeader = ((DialIq)request.getIq()).getHeader("JvbRoomName");
        if (roomNameHeader != null && !Intrinsics.areEqual((Object)JidCreate.entityBareFrom((String)roomNameHeader), (Object)conference.getRoomName())) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.forbidden);
            boolean bl = false;
            this.logger.warn((Object)("Rejecting request with non-matching JvbRoomName: from=" + ((DialIq)request.getIq()).getFrom() + " , roomName=" + conference.getRoomName() + ", JvbRoomName=" + roomNameHeader));
            CounterMetric.inc$default((CounterMetric)Stats.Companion.getRejectedRequests(), null, (int)1, null);
            return (IqProcessingResult)rejectedWithError;
        }
        this.logger.info((Object)("Accepted jigasi request from " + ((DialIq)request.getIq()).getFrom() + ": " + XmlStringBuilderUtil.Companion.toStringOpt(request.getIq())));
        CounterMetric.inc$default((CounterMetric)Stats.Companion.getAcceptedRequests(), null, (int)1, null);
        TaskPools.Companion.getIoPool().execute(() -> JigasiIqHandler.handleRequest$lambda$5(this, request, conference));
        return (IqProcessingResult)new IqProcessingResult.AcceptedWithNoResponse();
    }

    /*
     * WARNING - void declaration
     */
    private final void inviteJigasi(IqRequest<DialIq> request, JitsiMeetConference conference, int retryCount, List<? extends Jid> exclude) {
        void $this$inviteJigasi_u24lambda_u248;
        DialIq dialIq;
        DialIq dialIq2;
        KFunction kFunction;
        if (Intrinsics.areEqual((Object)((DialIq)request.getIq()).getDestination(), (Object)"jitsi_meet_transcribe")) {
            if (JigasiIqHandlerKt.access$hasTranscriber(conference)) {
                this.logger.warn((Object)("Request failed, transcriber already available: " + XmlStringBuilderUtil.Companion.toStringOpt(request.getIq())));
                IQ.createErrorResponse((IQ)request.getIq(), (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.conflict).build());
                return;
            }
            kFunction = (KFunction)new Function2<List<? extends Jid>, Collection<? extends String>, Jid>((Object)this.jigasiDetector){

                @Nullable
                public final Jid invoke(@NotNull List<? extends Jid> p0, @NotNull Collection<String> p1) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    return ((JigasiDetector)((Object)this.receiver)).selectTranscriber(p0, p1);
                }
            };
        } else {
            kFunction = (KFunction)new Function2<List<? extends Jid>, Collection<? extends String>, Jid>((Object)this.jigasiDetector){

                @Nullable
                public final Jid invoke(@NotNull List<? extends Jid> p0, @NotNull Collection<String> p1) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    return ((JigasiDetector)((Object)this.receiver)).selectSipJigasi(p0, p1);
                }
            };
        }
        KFunction selector2 = kFunction;
        Function2 function2 = (Function2)selector2;
        Set<String> set = conference.getBridgeRegions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getBridgeRegions(...)");
        Jid jid = (Jid)function2.invoke(exclude, set);
        if (jid == null) {
            JigasiIqHandler $this$inviteJigasi_u24lambda_u246 = this;
            boolean bl = false;
            $this$inviteJigasi_u24lambda_u246.logger.warn((Object)("Request failed, no instances available: " + XmlStringBuilderUtil.Companion.toStringOpt(request.getIq())));
            XMPPConnection xMPPConnection = (XMPPConnection)request.getConnection();
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)request.getIq(), (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.service_unavailable).build());
            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
            UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
            $this$inviteJigasi_u24lambda_u246.stats.noInstanceAvailable();
            return;
        }
        Jid jigasiJid = jid;
        this.logger.info((Object)("Selected " + jigasiJid + " (request from " + ((DialIq)request.getIq()).getFrom() + ")"));
        DialIq $this$inviteJigasi_u24lambda_u247 = dialIq2 = new DialIq((DialIq)request.getIq());
        boolean bl = false;
        $this$inviteJigasi_u24lambda_u247.setFrom(null);
        $this$inviteJigasi_u24lambda_u247.setTo(jigasiJid);
        $this$inviteJigasi_u24lambda_u247.setStanzaId(this.stanzaIdSource.getNewStanzaId());
        DialIq requestToJigasi = dialIq2;
        try {
            $this$inviteJigasi_u24lambda_u247 = UtilKt.sendIqAndGetResponse((AbstractXMPPConnection)this.jigasiDetector.getXmppConnection(), (IQ)((IQ)requestToJigasi));
        }
        catch (SmackException.NotConnectedException e) {
            this.logger.error((Object)("Request failed,  XMPP not connected: " + XmlStringBuilderUtil.Companion.toStringOpt(request.getIq())));
            this.stats.xmppNotConnected();
            return;
        }
        DialIq responseFromJigasi = $this$inviteJigasi_u24lambda_u247;
        if (responseFromJigasi == null || responseFromJigasi.getError() != null) {
            if (responseFromJigasi == null) {
                this.logger.warn((Object)("Jigasi instance timed out: " + jigasiJid));
                CounterMetric.inc$default((CounterMetric)Stats.Companion.getSingleInstanceTimeouts(), null, (int)1, null);
            } else {
                this.logger.warn((Object)("Jigasi instance returned error (" + jigasiJid + "): " + XmlStringBuilderUtil.Companion.toStringOpt((IQ)responseFromJigasi)));
                CounterMetric.inc$default((CounterMetric)Stats.Companion.getSingleInstanceErrors(), null, (int)1, null);
            }
            if (retryCount > 0) {
                this.logger.info((Object)("Will retry up to " + retryCount + " more times."));
                CounterMetric.inc$default((CounterMetric)Stats.Companion.getRetries(), null, (int)1, null);
                this.inviteJigasi(request, conference, retryCount - 1, CollectionsKt.plus((Collection)exclude, (Object)jigasiJid));
            } else {
                StanzaError.Condition condition = responseFromJigasi == null ? StanzaError.Condition.remote_server_timeout : StanzaError.Condition.undefined_condition;
                this.logger.warn((Object)"Request failed, all instances failed.");
                this.stats.allInstancesFailed();
                XMPPConnection xMPPConnection = (XMPPConnection)request.getConnection();
                ErrorIQ errorIQ = IQ.createErrorResponse((IQ)request.getIq(), (StanzaError)StanzaError.getBuilder((StanzaError.Condition)condition).build());
                Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
            }
            return;
        }
        this.logger.info((Object)("Response from jigasi: " + XmlStringBuilderUtil.Companion.toStringOpt((IQ)responseFromJigasi)));
        DialIq e = dialIq = responseFromJigasi;
        XMPPConnection xMPPConnection = (XMPPConnection)request.getConnection();
        boolean bl2 = false;
        $this$inviteJigasi_u24lambda_u248.setFrom(null);
        $this$inviteJigasi_u24lambda_u248.setTo(((DialIq)request.getIq()).getFrom());
        $this$inviteJigasi_u24lambda_u248.setStanzaId(((DialIq)request.getIq()).getStanzaId());
        UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)dialIq));
    }

    static /* synthetic */ void inviteJigasi$default(JigasiIqHandler jigasiIqHandler, IqRequest iqRequest, JitsiMeetConference jitsiMeetConference, int n, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        jigasiIqHandler.inviteJigasi((IqRequest<DialIq>)iqRequest, jitsiMeetConference, n, list);
    }

    private static final void handleRequest$lambda$5(JigasiIqHandler this$0, IqRequest $request, JitsiMeetConference $conference) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$conference, (String)"$conference");
        try {
            JigasiIqHandler.inviteJigasi$default(this$0, $request, $conference, 0, null, 12, null);
        }
        catch (Exception e) {
            this$0.logger.warn((Object)"Failed to invite jigasi", (Throwable)e);
            XMPPConnection xMPPConnection = (XMPPConnection)$request.getConnection();
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)$request.getIq(), (StanzaError.Condition)StanzaError.Condition.internal_server_error);
            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
            UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Companion;", "", "()V", "stanzaIdSourceFactory", "Lorg/jivesoftware/smack/packet/id/StandardStanzaIdSource$Factory;", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Stats;", "", "()V", "requestsFailedAllInstancesFailed", "Ljava/util/concurrent/atomic/AtomicInteger;", "requestsFailedNoInstanceAvailable", "requestsFailedXmppNotConnected", "allInstancesFailed", "", "noInstanceAvailable", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "xmppNotConnected", "Companion", "jicofo"})
    public static final class Stats {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AtomicInteger requestsFailedNoInstanceAvailable = new AtomicInteger();
        @NotNull
        private final AtomicInteger requestsFailedXmppNotConnected = new AtomicInteger();
        @NotNull
        private final AtomicInteger requestsFailedAllInstancesFailed = new AtomicInteger();
        @NotNull
        private static final String PREFIX = "jigasi_iq_handler";
        @NotNull
        private static final CounterMetric rejectedRequests = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"jigasi_iq_handler_rejected_requests", (String)"User requests which were rejected (e.g. not authorized, bad request).", (long)0L, null, (int)12, null);
        @NotNull
        private static final CounterMetric acceptedRequests = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"jigasi_iq_handler_accepted_requests", (String)"User requests which were accepted.", (long)0L, null, (int)12, null);
        @NotNull
        private static final CounterMetric retries = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"jigasi_iq_handler_retries", (String)"Requests retried with a different jigasi instance.", (long)0L, null, (int)12, null);
        @NotNull
        private static final CounterMetric singleInstanceErrors = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"jigasi_iq_handler_instance_errors", (String)"Errors received from jigasi instances.", (long)0L, null, (int)12, null);
        @NotNull
        private static final CounterMetric singleInstanceTimeouts = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"jigasi_iq_handler_instance_timeouts", (String)"Timeouts for requests sent to jigasi instances.", (long)0L, null, (int)12, null);

        public final int noInstanceAvailable() {
            return this.requestsFailedNoInstanceAvailable.incrementAndGet();
        }

        public final int xmppNotConnected() {
            return this.requestsFailedXmppNotConnected.incrementAndGet();
        }

        public final int allInstancesFailed() {
            return this.requestsFailedAllInstancesFailed.incrementAndGet();
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = Companion.statsJson();
            boolean bl = false;
            ((Map)$this$toJson_u24lambda_u240).put("requests_failed_no_instance", this.requestsFailedNoInstanceAvailable.get());
            ((Map)$this$toJson_u24lambda_u240).put("requests_failed_xmpp_not_connected", this.requestsFailedXmppNotConnected.get());
            return orderedJsonObject;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/jicofo/xmpp/JigasiIqHandler$Stats$Companion;", "", "()V", "PREFIX", "", "acceptedRequests", "Lorg/jitsi/metrics/CounterMetric;", "getAcceptedRequests", "()Lorg/jitsi/metrics/CounterMetric;", "rejectedRequests", "getRejectedRequests", "retries", "getRetries", "singleInstanceErrors", "getSingleInstanceErrors", "singleInstanceTimeouts", "getSingleInstanceTimeouts", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jicofo"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CounterMetric getRejectedRequests() {
                return rejectedRequests;
            }

            @NotNull
            public final CounterMetric getAcceptedRequests() {
                return acceptedRequests;
            }

            @NotNull
            public final CounterMetric getRetries() {
                return retries;
            }

            @NotNull
            public final CounterMetric getSingleInstanceErrors() {
                return singleInstanceErrors;
            }

            @NotNull
            public final CounterMetric getSingleInstanceTimeouts() {
                return singleInstanceTimeouts;
            }

            @NotNull
            public final OrderedJsonObject statsJson() {
                OrderedJsonObject orderedJsonObject;
                OrderedJsonObject $this$statsJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
                boolean bl = false;
                $this$statsJson_u24lambda_u240.put((Object)"rejected_requests", (Object)Companion.getRejectedRequests().get());
                $this$statsJson_u24lambda_u240.put((Object)"accepted_requests", (Object)Companion.getAcceptedRequests().get());
                $this$statsJson_u24lambda_u240.put((Object)"retries", (Object)Companion.getRetries().get());
                $this$statsJson_u24lambda_u240.put((Object)"instance_errors", (Object)Companion.getSingleInstanceErrors().get());
                $this$statsJson_u24lambda_u240.put((Object)"instance_timeout", (Object)Companion.getSingleInstanceTimeouts().get());
                return orderedJsonObject;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

