/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import java.io.IOException;
import org.jitsi.xmpp.extensions.coin.MediaPacketExtension;
import org.jitsi.xmpp.extensions.coin.ParsingUtils;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class MediaProvider
extends ExtensionElementProvider<MediaPacketExtension> {
    public MediaPacketExtension parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        boolean done = false;
        String id = parser.getAttributeValue("", "id");
        if (id == null) {
            throw new SmackParsingException.RequiredAttributeMissingException("Coin media must contains src-id element");
        }
        MediaPacketExtension ext = new MediaPacketExtension(id);
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                switch (elementName) {
                    case "display-text": {
                        ext.setDisplayText(ParsingUtils.parseText(parser));
                        break;
                    }
                    case "label": {
                        ext.setLabel(ParsingUtils.parseText(parser));
                        break;
                    }
                    case "src-id": {
                        ext.setSrcID(ParsingUtils.parseText(parser));
                        break;
                    }
                    case "status": {
                        ext.setStatus(ParsingUtils.parseText(parser));
                        break;
                    }
                    case "type": {
                        ext.setType(ParsingUtils.parseText(parser));
                    }
                }
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("media")) continue;
            done = true;
        }
        return ext;
    }
}

