/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.extensions.bytearray;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.ByteKt;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.utils.ByteArrayUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0004\n\u0002\b\f\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u001a\"\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\n\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0010\u001a\u0012\u0010\u0013\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u0012\u0010\u0015\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u001f\u0010\u0017\u001a\u00020\u00022\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001b\u001a\"\u0010\u001c\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004\u001a\"\u0010 \u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004\u001a\"\u0010!\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004\u001a\n\u0010#\u001a\u00020\u0002*\u00020\u0002\u001a\u0015\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002H\u0086\u0002\u001a\u001e\u0010(\u001a\u00020)*\u00020\u00022\b\b\u0002\u0010*\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020\u0004\u001a\u001a\u0010,\u001a\u00020\u0004*\u00020\u00022\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004\"\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"putBits", "", "", "byteIndex", "", "destBitPos", "src", "", "numBits", "getBitAsBool", "", "byteOffset", "bitOffset", "putBitAsBoolean", "isSet", "getShort", "", "putShort", "value", "get3Bytes", "put3Bytes", "getInt", "putInt", "byteArrayOf", "elements", "", "", "([Ljava/lang/Number;)[B", "shiftDataRight", "startPos", "endPos", "numBytes", "shiftDataLeft", "shiftData", "delta", "cloneFromPool", "plus", "other", "HEX_CHARS", "", "toHex", "", "offset", "length", "hashCodeOfSegment", "start", "end", "rtp"})
@SourceDebugExtension(value={"SMAP\nByteArrayExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteArrayExtensions.kt\norg/jitsi/rtp/extensions/bytearray/ByteArrayExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,157:1\n11102#2:158\n11437#2,3:159\n*S KotlinDebug\n*F\n+ 1 ByteArrayExtensions.kt\norg/jitsi/rtp/extensions/bytearray/ByteArrayExtensionsKt\n*L\n57#1:158\n57#1:159,3\n*E\n"})
public final class ByteArrayExtensionsKt {
    @NotNull
    private static final char[] HEX_CHARS;

    public static final void putBits(@NotNull byte[] $this$putBits, int byteIndex, int destBitPos, byte src, int numBits) {
        Intrinsics.checkNotNullParameter((Object)$this$putBits, (String)"<this>");
        byte by = $this$putBits[byteIndex];
        $this$putBits[byteIndex] = by = ByteKt.putBits(by, destBitPos, numBits, src);
    }

    public static final boolean getBitAsBool(@NotNull byte[] $this$getBitAsBool, int byteOffset, int bitOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$getBitAsBool, (String)"<this>");
        return ByteKt.getBitAsBool($this$getBitAsBool[byteOffset], bitOffset);
    }

    public static final void putBitAsBoolean(@NotNull byte[] $this$putBitAsBoolean, int byteIndex, int destBitPos, boolean isSet) {
        Intrinsics.checkNotNullParameter((Object)$this$putBitAsBoolean, (String)"<this>");
        byte by = $this$putBitAsBoolean[byteIndex];
        $this$putBitAsBoolean[byteIndex] = by = ByteKt.putBit(by, destBitPos, isSet);
    }

    public static final short getShort(@NotNull byte[] $this$getShort, int byteIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getShort, (String)"<this>");
        return ByteArrayUtils.readShort((byte[])$this$getShort, (int)byteIndex);
    }

    public static final void putShort(@NotNull byte[] $this$putShort, int byteIndex, short value) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        ByteArrayUtils.writeShort((byte[])$this$putShort, (int)byteIndex, (short)value);
    }

    public static final int get3Bytes(@NotNull byte[] $this$get3Bytes, int byteIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$get3Bytes, (String)"<this>");
        return ByteArrayUtils.readUint24((byte[])$this$get3Bytes, (int)byteIndex);
    }

    public static final void put3Bytes(@NotNull byte[] $this$put3Bytes, int byteIndex, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$put3Bytes, (String)"<this>");
        ByteArrayUtils.writeUint24((byte[])$this$put3Bytes, (int)byteIndex, (int)value);
    }

    public static final int getInt(@NotNull byte[] $this$getInt, int byteIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getInt, (String)"<this>");
        return ByteArrayUtils.readInt((byte[])$this$getInt, (int)byteIndex);
    }

    public static final void putInt(@NotNull byte[] $this$putInt, int byteIndex, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$putInt, (String)"<this>");
        ByteArrayUtils.writeInt((byte[])$this$putInt, (int)byteIndex, (int)value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] byteArrayOf(Number ... elements) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Number[] $this$map$iv = elements;
        boolean $i$f$map = false;
        Number[] numberArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.byteValue());
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }

    public static final void shiftDataRight(@NotNull byte[] $this$shiftDataRight, int startPos, int endPos, int numBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$shiftDataRight, (String)"<this>");
        if (numBytes < 0) {
            throw new Exception("");
        }
        int index = endPos;
        if (startPos <= index) {
            while (true) {
                $this$shiftDataRight[index + numBytes] = $this$shiftDataRight[index];
                if (index == startPos) break;
                --index;
            }
        }
    }

    public static final void shiftDataLeft(@NotNull byte[] $this$shiftDataLeft, int startPos, int endPos, int numBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$shiftDataLeft, (String)"<this>");
        int index = startPos;
        if (index <= endPos) {
            while (true) {
                $this$shiftDataLeft[index - numBytes] = $this$shiftDataLeft[index];
                if (index == endPos) break;
                ++index;
            }
        }
    }

    public static final void shiftData(@NotNull byte[] $this$shiftData, int startPos, int endPos, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shiftData, (String)"<this>");
        if (delta < 0) {
            ByteArrayExtensionsKt.shiftDataLeft($this$shiftData, startPos, endPos, Math.abs(delta));
        } else if (delta > 0) {
            ByteArrayExtensionsKt.shiftDataRight($this$shiftData, startPos, endPos, delta);
        }
    }

    @NotNull
    public static final byte[] cloneFromPool(@NotNull byte[] $this$cloneFromPool) {
        Intrinsics.checkNotNullParameter((Object)$this$cloneFromPool, (String)"<this>");
        byte[] clone = (byte[])BufferPool.Companion.getGetArray().invoke((Object)$this$cloneFromPool.length);
        System.arraycopy($this$cloneFromPool, 0, clone, 0, $this$cloneFromPool.length);
        return clone;
    }

    @NotNull
    public static final byte[] plus(@NotNull byte[] $this$plus, @NotNull byte[] other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        byte[] newArray = (byte[])BufferPool.Companion.getGetArray().invoke((Object)($this$plus.length + other.length));
        System.arraycopy($this$plus, 0, newArray, 0, $this$plus.length);
        System.arraycopy(other, 0, newArray, $this$plus.length, other.length);
        return newArray;
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        StringBuffer result = new StringBuffer();
        int n = RangesKt.coerceAtMost((int)(offset + length), (int)$this$toHex.length);
        for (int i = offset; i < n; ++i) {
            int position = i - offset;
            if (position != 0) {
                if (position % 16 == 0) {
                    result.append("\n");
                } else if (position % 4 == 0) {
                    result.append(" ");
                }
            }
            byte by = $this$toHex[i];
            int firstIndex = (by & 0xF0) >> 4;
            int secondIndex = by & 0xF;
            result.append(HEX_CHARS[firstIndex]);
            result.append(HEX_CHARS[secondIndex]);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String toHex$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byArray.length - n;
        }
        return ByteArrayExtensionsKt.toHex(byArray, n, n2);
    }

    public static final int hashCodeOfSegment(@NotNull byte[] $this$hashCodeOfSegment, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)$this$hashCodeOfSegment, (String)"<this>");
        int result = 1;
        int n = RangesKt.coerceIn((int)end, (int)0, (int)$this$hashCodeOfSegment.length);
        for (int i = RangesKt.coerceIn((int)start, (int)0, (int)$this$hashCodeOfSegment.length); i < n; ++i) {
            result = 31 * result + $this$hashCodeOfSegment[i];
        }
        return result;
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_CHARS = cArray;
    }
}

