/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fBI\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u001b\u0010\r\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\u0013R\u001b\u0010\u000e\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001b\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpReportBlock;", "", "ssrc", "", "fractionLost", "", "cumulativePacketsLost", "extendedHighestSeqNum", "interarrivalJitter", "lastSrTimestamp", "delaySinceLastSr", "<init>", "(JIIJJJJ)V", "seqNumCycles", "seqNum", "(JIIIIJJJ)V", "getSsrc", "()J", "getFractionLost", "()I", "getCumulativePacketsLost", "getExtendedHighestSeqNum", "getInterarrivalJitter", "getLastSrTimestamp", "getDelaySinceLastSr", "getSeqNumCycles", "seqNumCycles$delegate", "Lkotlin/Lazy;", "getSeqNum", "seqNum$delegate", "writeTo", "", "buf", "", "offset", "Companion", "rtp"})
public final class RtcpReportBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long ssrc;
    private final int fractionLost;
    private final int cumulativePacketsLost;
    private final long extendedHighestSeqNum;
    private final long interarrivalJitter;
    private final long lastSrTimestamp;
    private final long delaySinceLastSr;
    @NotNull
    private final Lazy seqNumCycles$delegate;
    @NotNull
    private final Lazy seqNum$delegate;
    public static final int SIZE_BYTES = 24;
    public static final int SSRC_OFFSET = 0;
    public static final int FRACTION_LOST_OFFSET = 4;
    public static final int CUMULATIVE_PACKETS_LOST_OFFSET = 5;
    public static final int EXTENDED_HIGHEST_SEQ_NUM_OFFSET = 8;
    public static final int INTERARRIVAL_JITTER_OFFSET = 12;
    public static final int LAST_SR_TIMESTAMP_OFFSET = 16;
    public static final int DELAY_SINCE_LAST_SR_OFFSET = 20;

    public RtcpReportBlock(long ssrc, int fractionLost, int cumulativePacketsLost, long extendedHighestSeqNum, long interarrivalJitter, long lastSrTimestamp, long delaySinceLastSr) {
        this.ssrc = ssrc;
        this.fractionLost = fractionLost;
        this.cumulativePacketsLost = cumulativePacketsLost;
        this.extendedHighestSeqNum = extendedHighestSeqNum;
        this.interarrivalJitter = interarrivalJitter;
        this.lastSrTimestamp = lastSrTimestamp;
        this.delaySinceLastSr = delaySinceLastSr;
        this.seqNumCycles$delegate = LazyKt.lazy(() -> RtcpReportBlock.seqNumCycles_delegate$lambda$0(this));
        this.seqNum$delegate = LazyKt.lazy(() -> RtcpReportBlock.seqNum_delegate$lambda$1(this));
    }

    public final long getSsrc() {
        return this.ssrc;
    }

    public final int getFractionLost() {
        return this.fractionLost;
    }

    public final int getCumulativePacketsLost() {
        return this.cumulativePacketsLost;
    }

    public final long getExtendedHighestSeqNum() {
        return this.extendedHighestSeqNum;
    }

    public final long getInterarrivalJitter() {
        return this.interarrivalJitter;
    }

    public final long getLastSrTimestamp() {
        return this.lastSrTimestamp;
    }

    public final long getDelaySinceLastSr() {
        return this.delaySinceLastSr;
    }

    public RtcpReportBlock(long ssrc, int fractionLost, int cumulativePacketsLost, int seqNumCycles, int seqNum, long interarrivalJitter, long lastSrTimestamp, long delaySinceLastSr) {
        this(ssrc, fractionLost, cumulativePacketsLost, UnsignedKt.toPositiveLong((seqNumCycles << 16) + (short)seqNum), interarrivalJitter, lastSrTimestamp, delaySinceLastSr);
    }

    public final int getSeqNumCycles() {
        Lazy lazy = this.seqNumCycles$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getSeqNum() {
        Lazy lazy = this.seqNum$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final void writeTo(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Companion.setSsrc(buf, offset, this.ssrc);
        Companion.setFractionLost(buf, offset, this.fractionLost);
        Companion.setCumulativePacketsLost(buf, offset, this.cumulativePacketsLost);
        Companion.setExtendedHighestSeqNum(buf, offset, this.extendedHighestSeqNum);
        Companion.setInterarrivalJitter(buf, offset, this.interarrivalJitter);
        Companion.setLastSrTimestamp(buf, offset, this.lastSrTimestamp);
        Companion.setDelaySinceLastSr(buf, offset, this.delaySinceLastSr);
    }

    private static final int seqNumCycles_delegate$lambda$0(RtcpReportBlock this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return UnsignedKt.toPositiveInt(this$0.extendedHighestSeqNum >>> 16);
    }

    private static final int seqNum_delegate$lambda$1(RtcpReportBlock this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return UnsignedKt.toPositiveInt((short)this$0.extendedHighestSeqNum);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013J\u0016\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013J\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013J\u0016\u0010#\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpReportBlock$Companion;", "", "<init>", "()V", "SIZE_BYTES", "", "SSRC_OFFSET", "FRACTION_LOST_OFFSET", "CUMULATIVE_PACKETS_LOST_OFFSET", "EXTENDED_HIGHEST_SEQ_NUM_OFFSET", "INTERARRIVAL_JITTER_OFFSET", "LAST_SR_TIMESTAMP_OFFSET", "DELAY_SINCE_LAST_SR_OFFSET", "fromBuffer", "Lorg/jitsi/rtp/rtcp/RtcpReportBlock;", "buffer", "", "offset", "getSsrc", "", "setSsrc", "", "buf", "baseOffset", "value", "getFractionLost", "setFractionLost", "getCumulativePacketsLost", "setCumulativePacketsLost", "getExtendedHighestSeqNum", "setExtendedHighestSeqNum", "getInterarrivalJitter", "setInterarrivalJitter", "getLastSrTimestamp", "setLastSrTimestamp", "getDelaySinceLastSr", "setDelaySinceLastSr", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RtcpReportBlock fromBuffer(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long ssrc = this.getSsrc(buffer, offset);
            int fractionLost = this.getFractionLost(buffer, offset);
            int cumulativePacketsLost = this.getCumulativePacketsLost(buffer, offset);
            long extendedHighestSeqNum = this.getExtendedHighestSeqNum(buffer, offset);
            long interarrivalJitter = this.getInterarrivalJitter(buffer, offset);
            long lastSrTimestamp = this.getLastSrTimestamp(buffer, offset);
            long delaySinceLastSr = this.getDelaySinceLastSr(buffer, offset);
            return new RtcpReportBlock(ssrc, fractionLost, cumulativePacketsLost, extendedHighestSeqNum, interarrivalJitter, lastSrTimestamp, delaySinceLastSr);
        }

        public final long getSsrc(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return FieldParsersKt.getIntAsLong(buffer, offset + 0);
        }

        public final void setSsrc(@NotNull byte[] buf, int baseOffset, long value) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 0, (int)value);
        }

        public final int getFractionLost(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return FieldParsersKt.getByteAsInt(buffer, offset + 4);
        }

        public final void setFractionLost(@NotNull byte[] buf, int baseOffset, int value) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            buf[baseOffset + 4] = (byte)value;
        }

        public final int getCumulativePacketsLost(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return FieldParsersKt.get3BytesAsInt(buffer, offset + 5);
        }

        public final void setCumulativePacketsLost(@NotNull byte[] buffer, int offset, int value) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            ByteArrayExtensionsKt.put3Bytes(buffer, offset + 5, value);
        }

        public final long getExtendedHighestSeqNum(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return FieldParsersKt.getIntAsLong(buffer, offset + 8);
        }

        public final void setExtendedHighestSeqNum(@NotNull byte[] buf, int baseOffset, long value) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 8, (int)value);
        }

        public final long getInterarrivalJitter(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return FieldParsersKt.getIntAsLong(buffer, offset + 12);
        }

        public final void setInterarrivalJitter(@NotNull byte[] buf, int baseOffset, long value) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 12, (int)value);
        }

        public final long getLastSrTimestamp(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return FieldParsersKt.getIntAsLong(buffer, offset + 16);
        }

        public final void setLastSrTimestamp(@NotNull byte[] buf, int baseOffset, long value) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 16, (int)value);
        }

        public final long getDelaySinceLastSr(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return FieldParsersKt.getIntAsLong(buffer, offset + 20);
        }

        public final void setDelaySinceLastSr(@NotNull byte[] buf, int baseOffset, long value) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 20, (int)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

