/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayUtils;
import org.jitsi.rtp.rtcp.CnameSdesItem;
import org.jitsi.rtp.rtcp.EmptySdesItem;
import org.jitsi.rtp.rtcp.SdesItemType;
import org.jitsi.rtp.rtcp.UnknownSdesItem;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jitsi/rtp/rtcp/SdesItem;", "", "type", "Lorg/jitsi/rtp/rtcp/SdesItemType;", "<init>", "(Lorg/jitsi/rtp/rtcp/SdesItemType;)V", "getType", "()Lorg/jitsi/rtp/rtcp/SdesItemType;", "sizeBytes", "", "getSizeBytes", "()I", "Companion", "rtp"})
public abstract class SdesItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdesItemType type;
    public static final int SDES_ITEM_HEADER_SIZE = 2;
    public static final int TYPE_OFFSET = 0;
    public static final int LENGTH_OFFSET = 1;
    public static final int DATA_OFFSET = 2;

    public SdesItem(@NotNull SdesItemType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
    }

    @NotNull
    public final SdesItemType getType() {
        return this.type;
    }

    public abstract int getSizeBytes();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/rtp/rtcp/SdesItem$Companion;", "", "<init>", "()V", "SDES_ITEM_HEADER_SIZE", "", "TYPE_OFFSET", "LENGTH_OFFSET", "DATA_OFFSET", "getType", "buf", "", "baseOffset", "getLength", "copyData", "dataLength", "parse", "Lorg/jitsi/rtp/rtcp/SdesItem;", "offset", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int getType(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getByteAsInt(buf, baseOffset + 0);
        }

        public final int getLength(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return FieldParsersKt.getByteAsInt(buf, baseOffset + 1);
        }

        @NotNull
        public final byte[] copyData(@NotNull byte[] buf, int baseOffset, int dataLength) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            if (dataLength <= 0) {
                return ByteArrayUtils.Companion.getEmptyByteArray();
            }
            byte[] copy = (byte[])BufferPool.Companion.getGetArray().invoke((Object)dataLength);
            System.arraycopy(buf, baseOffset + 2, copy, 0, dataLength);
            return copy;
        }

        @NotNull
        public final SdesItem parse(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int typeValue = this.getType(buf, offset);
            SdesItemType type = SdesItemType.Companion.fromInt(typeValue);
            if (WhenMappings.$EnumSwitchMapping$0[type.ordinal()] != 2) {
                int length = this.getLength(buf, offset);
                return WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 1 ? (SdesItem)new CnameSdesItem(buf, offset, length) : (SdesItem)new UnknownSdesItem(typeValue, buf, offset, length);
            }
            return EmptySdesItem.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SdesItemType.values().length];
                try {
                    nArray[SdesItemType.CNAME.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SdesItemType.EMPTY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

