/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorStatelessSubset;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyException;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.DTI;
import org.jitsi.rtp.rtp.header_extensions.DecodeTargetLayer;
import org.jitsi.rtp.rtp.header_extensions.Resolution;
import org.jitsi.rtp.rtp.header_extensions.TemplateFrameInfo;
import org.jitsi.rtp.util.BitReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0019J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\u0012\u0010'\u001a\u00020%2\b\u0010#\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u00102\u001a\u00020%H\u0002J\b\u00103\u001a\u00020\u0019H\u0002J\b\u00107\u001a\u00020%H\u0003J\b\u00108\u001a\u00020%H\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\b\u0010:\u001a\u00020%H\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\b\u0010<\u001a\u00020%H\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\b\u0010>\u001a\u00020%H\u0002J\b\u0010?\u001a\u00020%H\u0002R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorReader;", "", "buffer", "", "offset", "", "length", "<init>", "([BII)V", "ext", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "(Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;)V", "getLength", "()I", "startOfFrame", "", "endOfFrame", "frameDependencyTemplateId", "frameNumber", "customDtis", "", "Lorg/jitsi/rtp/rtp/header_extensions/DTI;", "customFdiffs", "customChains", "localTemplateDependencyStructure", "Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;", "templateDependencyStructure", "activeDecodeTargetsBitmask", "Ljava/lang/Integer;", "reader", "Lorg/jitsi/rtp/util/BitReader;", "parseStateless", "Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorStatelessSubset;", "parse", "Lorg/jitsi/rtp/rtp/header_extensions/Av1DependencyDescriptorHeaderExtension;", "dep", "reset", "", "readMandatoryDescriptorFields", "readExtendedDescriptorFields", "templateIdOffset", "templateInfo", "", "Lorg/jitsi/rtp/rtp/header_extensions/TemplateFrameInfo;", "decodeTargetProtectedBy", "decodeTargetLayers", "Lorg/jitsi/rtp/rtp/header_extensions/DecodeTargetLayer;", "maxRenderResolutions", "Lorg/jitsi/rtp/rtp/header_extensions/Resolution;", "dtCnt", "resetDependencyStructureInfo", "readTemplateDependencyStructure", "templateCnt", "maxSpatialId", "maxTemporalId", "readTemplateLayers", "readTemplateDtis", "readFrameDtis", "readTemplateFdiffs", "readFrameFdiffs", "readTemplateChains", "readFrameChains", "readDecodeTargetLayers", "readRenderResolutions", "rtp"})
public final class Av1DependencyDescriptorReader {
    private final int length;
    private boolean startOfFrame;
    private boolean endOfFrame;
    private int frameDependencyTemplateId;
    private int frameNumber;
    @Nullable
    private List<? extends DTI> customDtis;
    @Nullable
    private List<Integer> customFdiffs;
    @Nullable
    private List<Integer> customChains;
    @Nullable
    private Av1TemplateDependencyStructure localTemplateDependencyStructure;
    @Nullable
    private Av1TemplateDependencyStructure templateDependencyStructure;
    @Nullable
    private Integer activeDecodeTargetsBitmask;
    @NotNull
    private final BitReader reader;
    private int templateIdOffset;
    @NotNull
    private final List<TemplateFrameInfo> templateInfo;
    @NotNull
    private final List<Integer> decodeTargetProtectedBy;
    @NotNull
    private final List<DecodeTargetLayer> decodeTargetLayers;
    @NotNull
    private final List<Resolution> maxRenderResolutions;
    private int dtCnt;
    private int templateCnt;
    private int maxSpatialId;
    private int maxTemporalId;

    public Av1DependencyDescriptorReader(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.length = length;
        this.reader = new BitReader(buffer, offset, this.length);
        this.templateInfo = new ArrayList();
        this.decodeTargetProtectedBy = new ArrayList();
        this.decodeTargetLayers = new ArrayList();
        this.maxRenderResolutions = new ArrayList();
    }

    public final int getLength() {
        return this.length;
    }

    public Av1DependencyDescriptorReader(@NotNull RtpPacket.HeaderExtension ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        this(ext.getBuffer(), ext.getDataOffset(), ext.getDataLengthBytes());
    }

    @NotNull
    public final Av1DependencyDescriptorStatelessSubset parseStateless() {
        this.reset();
        this.readMandatoryDescriptorFields();
        if (this.length > 3) {
            boolean templateDependencyStructurePresent = this.reader.bitAsBoolean();
            this.reader.skipBits(4);
            if (templateDependencyStructurePresent) {
                this.localTemplateDependencyStructure = this.readTemplateDependencyStructure();
            }
        }
        return new Av1DependencyDescriptorStatelessSubset(this.startOfFrame, this.endOfFrame, this.frameDependencyTemplateId, this.frameNumber, this.localTemplateDependencyStructure);
    }

    @NotNull
    public final Av1DependencyDescriptorHeaderExtension parse(@Nullable Av1TemplateDependencyStructure dep) {
        this.reset();
        this.readMandatoryDescriptorFields();
        if (this.length > 3) {
            this.readExtendedDescriptorFields(dep);
        } else {
            if (dep == null) {
                throw new Av1DependencyException("No external dependency structure specified for non-first packet");
            }
            this.templateDependencyStructure = dep;
        }
        Av1TemplateDependencyStructure av1TemplateDependencyStructure = this.templateDependencyStructure;
        Intrinsics.checkNotNull((Object)av1TemplateDependencyStructure);
        return new Av1DependencyDescriptorHeaderExtension(this.startOfFrame, this.endOfFrame, this.frameDependencyTemplateId, this.frameNumber, this.localTemplateDependencyStructure, this.activeDecodeTargetsBitmask, this.customDtis, this.customFdiffs, this.customChains, av1TemplateDependencyStructure);
    }

    private final void reset() {
        this.reader.reset();
    }

    private final void readMandatoryDescriptorFields() {
        this.startOfFrame = this.reader.bitAsBoolean();
        this.endOfFrame = this.reader.bitAsBoolean();
        this.frameDependencyTemplateId = this.reader.bits(6);
        this.frameNumber = this.reader.bits(16);
    }

    private final void readExtendedDescriptorFields(Av1TemplateDependencyStructure dep) {
        boolean templateDependencyStructurePresent = this.reader.bitAsBoolean();
        boolean activeDecodeTargetsPresent = this.reader.bitAsBoolean();
        boolean customDtisFlag = this.reader.bitAsBoolean();
        boolean customFdiffsFlag = this.reader.bitAsBoolean();
        boolean customChainsFlag = this.reader.bitAsBoolean();
        if (templateDependencyStructurePresent) {
            this.templateDependencyStructure = this.localTemplateDependencyStructure = this.readTemplateDependencyStructure();
        } else {
            if (dep == null) {
                throw new Av1DependencyException("No external dependency structure specified for non-first packet");
            }
            this.templateDependencyStructure = dep;
        }
        if (activeDecodeTargetsPresent) {
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = this.templateDependencyStructure;
            Intrinsics.checkNotNull((Object)av1TemplateDependencyStructure);
            this.activeDecodeTargetsBitmask = this.reader.bits(av1TemplateDependencyStructure.getDecodeTargetCount());
        } else if (templateDependencyStructurePresent) {
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = this.templateDependencyStructure;
            Intrinsics.checkNotNull((Object)av1TemplateDependencyStructure);
            this.activeDecodeTargetsBitmask = (1 << av1TemplateDependencyStructure.getDecodeTargetCount()) - 1;
        }
        if (customDtisFlag) {
            this.customDtis = this.readFrameDtis();
        }
        if (customFdiffsFlag) {
            this.customFdiffs = this.readFrameFdiffs();
        }
        if (customChainsFlag) {
            this.customChains = this.readFrameChains();
        }
    }

    private final void resetDependencyStructureInfo() {
        this.templateCnt = 0;
        this.templateInfo.clear();
        this.decodeTargetProtectedBy.clear();
        this.decodeTargetLayers.clear();
        this.maxRenderResolutions.clear();
    }

    private final Av1TemplateDependencyStructure readTemplateDependencyStructure() {
        this.resetDependencyStructureInfo();
        this.templateIdOffset = this.reader.bits(6);
        int dtCntMinusOne = this.reader.bits(5);
        this.dtCnt = dtCntMinusOne + 1;
        this.readTemplateLayers();
        this.readTemplateDtis();
        this.readTemplateFdiffs();
        this.readTemplateChains();
        this.readDecodeTargetLayers();
        boolean resolutionsPresent = this.reader.bitAsBoolean();
        if (resolutionsPresent) {
            this.readRenderResolutions();
        }
        return new Av1TemplateDependencyStructure(this.templateIdOffset, CollectionsKt.toList((Iterable)this.templateInfo), CollectionsKt.toList((Iterable)this.decodeTargetProtectedBy), CollectionsKt.toList((Iterable)this.decodeTargetLayers), CollectionsKt.toList((Iterable)this.maxRenderResolutions), this.maxSpatialId, this.maxTemporalId);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Artifact of generated Kotlin code.")
    private final void readTemplateLayers() {
        int temporalId = 0;
        int spatialId = 0;
        int nextLayerIdc = 0;
        do {
            this.templateInfo.add(this.templateCnt, new TemplateFrameInfo(spatialId, temporalId, null, null, null, 28, null));
            int n = this.templateCnt;
            this.templateCnt = n + 1;
            nextLayerIdc = this.reader.bits(2);
            switch (nextLayerIdc) {
                case 1: {
                    if (this.maxTemporalId >= ++temporalId) break;
                    this.maxTemporalId = temporalId;
                    break;
                }
                case 2: {
                    temporalId = 0;
                    ++spatialId;
                }
            }
        } while (nextLayerIdc != 3);
        if (!(this.templateInfo.size() == this.templateCnt)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.maxSpatialId = spatialId;
    }

    private final void readTemplateDtis() {
        int n = this.templateCnt;
        for (int templateIndex = 0; templateIndex < n; ++templateIndex) {
            int n2 = this.dtCnt;
            for (int dtIndex = 0; dtIndex < n2; ++dtIndex) {
                this.templateInfo.get(templateIndex).getDti().add(dtIndex, DTI.Companion.fromInt(this.reader.bits(2)));
            }
        }
    }

    private final List<DTI> readFrameDtis() {
        Av1TemplateDependencyStructure av1TemplateDependencyStructure = this.templateDependencyStructure;
        Intrinsics.checkNotNull((Object)av1TemplateDependencyStructure);
        int n = av1TemplateDependencyStructure.getDecodeTargetCount();
        ArrayList<DTI> arrayList = new ArrayList<DTI>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<DTI> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(DTI.Companion.fromInt(this.reader.bits(2)));
        }
        return arrayList;
    }

    private final void readTemplateFdiffs() {
        int n = this.templateCnt;
        for (int templateIndex = 0; templateIndex < n; ++templateIndex) {
            int fdiffCnt = 0;
            boolean fdiffFollowsFlag = this.reader.bitAsBoolean();
            while (fdiffFollowsFlag) {
                int fdiffMinusOne = this.reader.bits(4);
                this.templateInfo.get(templateIndex).getFdiff().add(fdiffCnt, fdiffMinusOne + 1);
                ++fdiffCnt;
                fdiffFollowsFlag = this.reader.bitAsBoolean();
            }
            if (fdiffCnt == this.templateInfo.get(templateIndex).getFdiffCnt()) continue;
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final List<Integer> readFrameFdiffs() {
        List list;
        List $this$readFrameFdiffs_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int nextFdiffSize = this.reader.bits(2);
        while (nextFdiffSize != 0) {
            int fdiffMinus1 = this.reader.bits(4 * nextFdiffSize);
            $this$readFrameFdiffs_u24lambda_u241.add(fdiffMinus1 + 1);
            nextFdiffSize = this.reader.bits(2);
        }
        return CollectionsKt.build((List)list);
    }

    private final void readTemplateChains() {
        int chainCount = this.reader.ns(this.dtCnt + 1);
        if (chainCount != 0) {
            int n = this.dtCnt;
            for (int dtIndex = 0; dtIndex < n; ++dtIndex) {
                this.decodeTargetProtectedBy.add(dtIndex, this.reader.ns(chainCount));
            }
            n = this.templateCnt;
            for (int templateIndex = 0; templateIndex < n; ++templateIndex) {
                for (int chainIndex = 0; chainIndex < chainCount; ++chainIndex) {
                    this.templateInfo.get(templateIndex).getChains().add(chainIndex, this.reader.bits(4));
                }
                if (this.templateInfo.get(templateIndex).getChains().size() == chainCount) continue;
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
    }

    private final List<Integer> readFrameChains() {
        Av1TemplateDependencyStructure av1TemplateDependencyStructure = this.templateDependencyStructure;
        Intrinsics.checkNotNull((Object)av1TemplateDependencyStructure);
        int n = av1TemplateDependencyStructure.getChainCount();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Integer> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.reader.bits(8));
        }
        return arrayList;
    }

    private final void readDecodeTargetLayers() {
        int n = this.dtCnt;
        for (int dtIndex = 0; dtIndex < n; ++dtIndex) {
            int spatialId = 0;
            int temporalId = 0;
            int n2 = this.templateCnt;
            for (int templateIndex = 0; templateIndex < n2; ++templateIndex) {
                if (this.templateInfo.get(templateIndex).getDti().get(dtIndex) == DTI.NOT_PRESENT) continue;
                if (this.templateInfo.get(templateIndex).getSpatialId() > spatialId) {
                    spatialId = this.templateInfo.get(templateIndex).getSpatialId();
                }
                if (this.templateInfo.get(templateIndex).getTemporalId() <= temporalId) continue;
                temporalId = this.templateInfo.get(templateIndex).getTemporalId();
            }
            this.decodeTargetLayers.add(dtIndex, new DecodeTargetLayer(spatialId, temporalId));
        }
        if (!(this.decodeTargetLayers.size() == this.dtCnt)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void readRenderResolutions() {
        int spatialId = 0;
        int n = this.maxSpatialId;
        if (spatialId <= n) {
            while (true) {
                int widthMinus1 = this.reader.bits(16);
                int heightMinus1 = this.reader.bits(16);
                this.maxRenderResolutions.add(spatialId, new Resolution(widthMinus1 + 1, heightMinus1 + 1));
                if (spatialId == n) break;
                ++spatialId;
            }
        }
    }
}

