/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.cc.allocation.MediaSourceContainer;
import org.jitsi.videobridge.cc.allocation.ReceiverConstraintsMap;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001:\u0001kB!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010*\u001a\u00020\u0019J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020)J\u001b\u0010/\u001a\u00020,2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0004\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u000206H&J\u0010\u0010D\u001a\u0004\u0018\u0001022\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020%J\u000e\u0010G\u001a\u00020,2\u0006\u0010F\u001a\u00020%J\b\u0010H\u001a\u00020\u0005H\u0016J\b\u0010I\u001a\u00020,H\u0016J\b\u0010J\u001a\u00020\u0019H&J\u0010\u0010O\u001a\u00020,2\u0006\u0010P\u001a\u000206H&J\b\u0010O\u001a\u00020,H&J\u0018\u0010U\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010V\u001a\u00020WH\u0002J\u0010\u0010Z\u001a\u00020,2\u0006\u0010[\u001a\u00020\\H&J\u0010\u0010]\u001a\u00020,2\u0006\u0010^\u001a\u00020_H&J\u0010\u0010`\u001a\u00020,2\u0006\u0010a\u001a\u00020\u0019H&J\u0018\u0010b\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010c\u001a\u00020\u001eH$J\u001e\u0010d\u001a\u00020,2\u0006\u0010e\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u001eJ\u0010\u0010g\u001a\u00020,2\u0006\u0010h\u001a\u00020\u0000H\u0016J\u000e\u0010i\u001a\u00020,2\u0006\u0010e\u001a\u00020\u0005J\u0016\u0010j\u001a\u00020,2\u0006\u0010e\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00107\u001a\b\u0012\u0004\u0012\u00020608X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0016\u0010;\u001a\u0004\u0018\u00010<8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0012\u0010?\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001bR\u0016\u0010A\u001a\u0004\u0018\u0001028DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0016\u0010K\u001a\u0004\u0018\u00010L8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0014\u0010Q\u001a\u00020R8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0012\u0010X\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u001bR\u0012\u0010Y\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010\u001b\u00a8\u0006l"}, d2={"Lorg/jitsi/videobridge/AbstractEndpoint;", "Lorg/jitsi/videobridge/cc/allocation/MediaSourceContainer;", "conference", "Lorg/jitsi/videobridge/Conference;", "id", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/videobridge/Conference;Ljava/lang/String;Lorg/jitsi/utils/logging2/Logger;)V", "getConference", "()Lorg/jitsi/videobridge/Conference;", "getId", "()Ljava/lang/String;", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "receiverVideoConstraints", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jitsi/videobridge/cc/allocation/ReceiverConstraintsMap;", "value", "statsId", "getStatsId", "setStatsId", "(Ljava/lang/String;)V", "", "isExpired", "()Z", "maxReceiverVideoConstraints", "", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "getMaxReceiverVideoConstraints", "()Ljava/util/Map;", "setMaxReceiverVideoConstraints", "(Ljava/util/Map;)V", "eventEmitter", "Lorg/jitsi/utils/event/EventEmitter;", "Lorg/jitsi/videobridge/AbstractEndpoint$EventHandler;", "getEventEmitter", "()Lorg/jitsi/utils/event/EventEmitter;", "videoTypeCache", "Lorg/jitsi/nlj/VideoType;", "hasVideoAvailable", "setVideoType", "", "sourceName", "videoType", "applyVideoTypeCache", "mediaSourceDescs", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "([Lorg/jitsi/nlj/MediaSourceDesc;)V", "receivesSsrc", "ssrc", "", "ssrcs", "", "getSsrcs", "()Ljava/util/Set;", "messageTransport", "Lorg/jitsi/videobridge/AbstractEndpointMessageTransport;", "getMessageTransport", "()Lorg/jitsi/videobridge/AbstractEndpointMessageTransport;", "visitor", "getVisitor", "mediaSource", "getMediaSource", "()Lorg/jitsi/nlj/MediaSourceDesc;", "findMediaSourceDesc", "addEventHandler", "eventHandler", "removeEventHandler", "toString", "expire", "shouldExpire", "lastIncomingActivity", "Ljava/time/Instant;", "getLastIncomingActivity", "()Ljava/time/Instant;", "requestKeyframe", "mediaSsrc", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "receiverVideoConstraintsChanged", "newMaxHeight", "", "isSendingAudio", "isSendingVideo", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "setExtmapAllowMixed", "allow", "sendVideoConstraints", "maxVideoConstraints", "addReceiver", "receiverId", "newVideoConstraints", "otherEndpointExpired", "expired", "removeReceiver", "removeSourceReceiver", "EventHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAbstractEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractEndpoint.kt\norg/jitsi/videobridge/AbstractEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,347:1\n1747#2,3:348\n1282#3,2:351\n215#4,2:353\n*S KotlinDebug\n*F\n+ 1 AbstractEndpoint.kt\norg/jitsi/videobridge/AbstractEndpoint\n*L\n102#1:348,3\n164#1:351,2\n223#1:353,2\n*E\n"})
public abstract class AbstractEndpoint
implements MediaSourceContainer {
    @NotNull
    private final Conference conference;
    @NotNull
    private final String id;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, ReceiverConstraintsMap> receiverVideoConstraints;
    @Nullable
    private String statsId;
    private boolean isExpired;
    @NotNull
    private Map<String, VideoConstraints> maxReceiverVideoConstraints;
    @NotNull
    private final EventEmitter<EventHandler> eventEmitter;
    @NotNull
    private final Map<String, VideoType> videoTypeCache;

    protected AbstractEndpoint(@NotNull Conference conference, @NotNull String id, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.conference = conference;
        this.id = id;
        Logger logger = parentLogger.createChildLogger(this.getClass().getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"epId", (Object)this.id)));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"createChildLogger(...)");
        this.logger = logger;
        this.receiverVideoConstraints = new ConcurrentHashMap();
        this.maxReceiverVideoConstraints = new LinkedHashMap();
        this.eventEmitter = (EventEmitter)new SyncEventEmitter();
        this.videoTypeCache = new LinkedHashMap();
    }

    @NotNull
    public final Conference getConference() {
        return this.conference;
    }

    @Override
    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final String getStatsId() {
        return this.statsId;
    }

    public final void setStatsId(@Nullable String value) {
        this.statsId = value;
        if (value != null) {
            this.logger.addContext("stats_id", value);
        }
    }

    public final boolean isExpired() {
        return this.isExpired;
    }

    @NotNull
    protected final Map<String, VideoConstraints> getMaxReceiverVideoConstraints() {
        return this.maxReceiverVideoConstraints;
    }

    protected final void setMaxReceiverVideoConstraints(@NotNull Map<String, VideoConstraints> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.maxReceiverVideoConstraints = map;
    }

    @NotNull
    protected final EventEmitter<EventHandler> getEventEmitter() {
        return this.eventEmitter;
    }

    public final boolean hasVideoAvailable() {
        boolean bl;
        block4: {
            for (MediaSourceDesc source : this.getMediaSources()) {
                if (source.getVideoType() == VideoType.NONE) continue;
                return true;
            }
            Iterable $this$any$iv = this.videoTypeCache.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VideoType it = (VideoType)element$iv;
                    boolean bl2 = false;
                    if (!(it != VideoType.NONE)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void setVideoType(@NotNull String sourceName, @NotNull VideoType videoType) {
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)videoType, (String)"videoType");
        MediaSourceDesc mediaSourceDesc = this.findMediaSourceDesc(sourceName);
        if (mediaSourceDesc != null && mediaSourceDesc.getVideoType() != videoType) {
            if (mediaSourceDesc.getVideoType().isEnabled() && videoType.isEnabled()) {
                this.logger.warn((Object)("Changing video type from " + mediaSourceDesc.getVideoType() + " to " + videoType + " for " + sourceName + ". This will not trigger re-signaling the mapping."));
            }
            mediaSourceDesc.setVideoType(videoType);
            this.conference.getSpeechActivity().endpointVideoAvailabilityChanged();
        }
        this.videoTypeCache.put(sourceName, videoType);
    }

    protected final void applyVideoTypeCache(@NotNull MediaSourceDesc[] mediaSourceDescs) {
        Intrinsics.checkNotNullParameter((Object)mediaSourceDescs, (String)"mediaSourceDescs");
        for (MediaSourceDesc mediaSourceDesc : mediaSourceDescs) {
            VideoType videoType = this.videoTypeCache.get(mediaSourceDesc.getSourceName());
            if (videoType == null) continue;
            mediaSourceDesc.setVideoType(videoType);
            this.videoTypeCache.remove(mediaSourceDesc.getSourceName());
        }
    }

    public abstract boolean receivesSsrc(long var1);

    @NotNull
    public abstract Set<Long> getSsrcs();

    @Nullable
    public AbstractEndpointMessageTransport getMessageTransport() {
        return null;
    }

    public abstract boolean getVisitor();

    @Nullable
    protected final MediaSourceDesc getMediaSource() {
        return (MediaSourceDesc)ArraysKt.firstOrNull((Object[])this.getMediaSources());
    }

    @Nullable
    public final MediaSourceDesc findMediaSourceDesc(@NotNull String sourceName) {
        MediaSourceDesc mediaSourceDesc;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
            MediaSourceDesc[] $this$firstOrNull$iv = this.getMediaSources();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)sourceName, (Object)it.getSourceName())) continue;
                mediaSourceDesc = element$iv;
                break block1;
            }
            mediaSourceDesc = null;
        }
        return mediaSourceDesc;
    }

    public final void addEventHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.eventEmitter.addHandler((Object)eventHandler);
    }

    public final void removeEventHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        this.eventEmitter.removeHandler((Object)eventHandler);
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + " " + this.id;
    }

    public void expire() {
        this.logger.debug((Object)"Expiring.");
        this.isExpired = true;
        this.conference.endpointExpired(this);
    }

    public abstract boolean shouldExpire();

    @Nullable
    public Instant getLastIncomingActivity() {
        return ClockUtils.NEVER;
    }

    public abstract void requestKeyframe(long var1);

    public abstract void requestKeyframe();

    @NotNull
    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        JSONObject receiverVideoConstraints = new JSONObject();
        Map $this$forEach$iv = this.receiverVideoConstraints;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String sourceName = (String)entry.getKey();
            ReceiverConstraintsMap receiverConstraints = (ReceiverConstraintsMap)entry.getValue();
            ((Map)receiverVideoConstraints).put(sourceName, receiverConstraints.getDebugState());
        }
        ((Map)debugState).put("receiverVideoConstraints", receiverVideoConstraints);
        ((Map)debugState).put("maxReceiverVideoConstraints", new HashMap<String, VideoConstraints>(this.maxReceiverVideoConstraints));
        ((Map)debugState).put("expired", this.isExpired);
        ((Map)debugState).put("statsId", this.statsId);
        return debugState;
    }

    private final void receiverVideoConstraintsChanged(String sourceName, int newMaxHeight) {
        VideoConstraints newReceiverMaxVideoConstraints = new VideoConstraints(newMaxHeight, -1.0);
        VideoConstraints oldReceiverMaxVideoConstraints = this.maxReceiverVideoConstraints.get(sourceName);
        if (!Intrinsics.areEqual((Object)newReceiverMaxVideoConstraints, (Object)oldReceiverMaxVideoConstraints)) {
            this.maxReceiverVideoConstraints.put(sourceName, newReceiverMaxVideoConstraints);
            this.sendVideoConstraints(sourceName, newReceiverMaxVideoConstraints);
        }
    }

    public abstract boolean isSendingAudio();

    public abstract boolean isSendingVideo();

    public abstract void addPayloadType(@NotNull PayloadType var1);

    public abstract void addRtpExtension(@NotNull RtpExtension var1);

    public abstract void setExtmapAllowMixed(boolean var1);

    protected abstract void sendVideoConstraints(@NotNull String var1, @NotNull VideoConstraints var2);

    public final void addReceiver(@NotNull String receiverId, @NotNull String sourceName, @NotNull VideoConstraints newVideoConstraints) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)newVideoConstraints, (String)"newVideoConstraints");
        ReceiverConstraintsMap receiverConstraintsMap = this.receiverVideoConstraints.computeIfAbsent(sourceName, arg_0 -> AbstractEndpoint.addReceiver$lambda$4(AbstractEndpoint::addReceiver$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)receiverConstraintsMap, (String)"computeIfAbsent(...)");
        ReceiverConstraintsMap sourceConstraints = receiverConstraintsMap;
        VideoConstraints oldVideoConstraints = sourceConstraints.put(receiverId, newVideoConstraints);
        if (oldVideoConstraints == null || !Intrinsics.areEqual((Object)oldVideoConstraints, (Object)newVideoConstraints)) {
            this.logger.debug(() -> AbstractEndpoint.addReceiver$lambda$5(receiverId, sourceName, newVideoConstraints));
            this.receiverVideoConstraintsChanged(sourceName, sourceConstraints.getMaxHeight());
        }
    }

    public void otherEndpointExpired(@NotNull AbstractEndpoint expired) {
        Intrinsics.checkNotNullParameter((Object)expired, (String)"expired");
        this.removeReceiver(expired.id);
    }

    public final void removeReceiver(@NotNull String receiverId) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        for (Map.Entry entry : ((Map)this.receiverVideoConstraints).entrySet()) {
            String sourceName = (String)entry.getKey();
            ReceiverConstraintsMap sourceConstraints = (ReceiverConstraintsMap)entry.getValue();
            if (sourceConstraints.remove(receiverId) == null) continue;
            this.logger.debug(() -> AbstractEndpoint.removeReceiver$lambda$6(receiverId, sourceName));
            this.receiverVideoConstraintsChanged(sourceName, sourceConstraints.getMaxHeight());
        }
    }

    public final void removeSourceReceiver(@NotNull String receiverId, @NotNull String sourceName) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        ReceiverConstraintsMap sourceConstraints = this.receiverVideoConstraints.get(sourceName);
        if (sourceConstraints != null && sourceConstraints.remove(receiverId) != null) {
            this.logger.debug(() -> AbstractEndpoint.removeSourceReceiver$lambda$7(receiverId, sourceName));
            this.receiverVideoConstraintsChanged(sourceName, sourceConstraints.getMaxHeight());
        }
    }

    private static final ReceiverConstraintsMap addReceiver$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ReceiverConstraintsMap();
    }

    private static final ReceiverConstraintsMap addReceiver$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ReceiverConstraintsMap)$tmp0.invoke(p0);
    }

    private static final String addReceiver$lambda$5(String $receiverId, String $sourceName, VideoConstraints $newVideoConstraints) {
        Intrinsics.checkNotNullParameter((Object)$receiverId, (String)"$receiverId");
        Intrinsics.checkNotNullParameter((Object)$sourceName, (String)"$sourceName");
        Intrinsics.checkNotNullParameter((Object)$newVideoConstraints, (String)"$newVideoConstraints");
        return "Changed receiver constraints: " + $receiverId + "->" + $sourceName + ": " + $newVideoConstraints.getMaxHeight();
    }

    private static final String removeReceiver$lambda$6(String $receiverId, String $sourceName) {
        Intrinsics.checkNotNullParameter((Object)$receiverId, (String)"$receiverId");
        Intrinsics.checkNotNullParameter((Object)$sourceName, (String)"$sourceName");
        return "Removed receiver " + $receiverId + " for " + $sourceName;
    }

    private static final String removeSourceReceiver$lambda$7(String $receiverId, String $sourceName) {
        Intrinsics.checkNotNullParameter((Object)$receiverId, (String)"$receiverId");
        Intrinsics.checkNotNullParameter((Object)$sourceName, (String)"$sourceName");
        return "Removed receiver " + $receiverId + " for " + $sourceName;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/videobridge/AbstractEndpoint$EventHandler;", "", "sourcesChanged", "", "jitsi-videobridge"})
    public static interface EventHandler {
        public void sourcesChanged();
    }
}

