/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.videobridge.Av1DDCodecState;
import org.jitsi.videobridge.CodecDeltas;
import org.jitsi.videobridge.CodecState;
import org.jitsi.videobridge.ReceiveSsrc;
import org.jitsi.videobridge.RtpState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/videobridge/SendSsrc;", "", "ssrc", "", "<init>", "(J)V", "getSsrc", "()J", "state", "Lorg/jitsi/videobridge/RtpState;", "sequenceNumberDelta", "", "timestampDelta", "codecDeltas", "Lorg/jitsi/videobridge/CodecDeltas;", "rewriteRtp", "", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "sending", "", "recv", "Lorg/jitsi/videobridge/ReceiveSsrc;", "rewriteRtcp", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "toString", "", "jitsi-videobridge"})
public final class SendSsrc {
    private final long ssrc;
    @NotNull
    private final RtpState state;
    private int sequenceNumberDelta;
    private long timestampDelta;
    @Nullable
    private CodecDeltas codecDeltas;

    public SendSsrc(long ssrc) {
        this.ssrc = ssrc;
        this.state = new RtpState();
    }

    public final long getSsrc() {
        return this.ssrc;
    }

    public final void rewriteRtp(@NotNull RtpPacket packet, boolean sending, @NotNull ReceiveSsrc recv) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)recv, (String)"recv");
        if (sending) {
            if (!recv.getHasDeltas()) {
                if (this.state.getValid()) {
                    if (recv.getState().getValid()) {
                        this.sequenceNumberDelta = RtpUtils.Companion.getSequenceNumberDelta(this.state.getLastSequenceNumber(), recv.getState().getLastSequenceNumber());
                        this.timestampDelta = RtpUtils.Companion.getTimestampDiff(this.state.getLastTimestamp(), recv.getState().getLastTimestamp());
                        CodecState codecState = this.state.getCodecState();
                        this.codecDeltas = codecState != null ? codecState.getDeltas(recv.getState().getCodecState()) : null;
                    } else {
                        int prevSequenceNumber = RtpUtils.Companion.applySequenceNumberDelta(packet.getSequenceNumber(), -1);
                        long prevTimestamp = RtpUtils.Companion.applyTimestampDelta(packet.getTimestamp(), -960L);
                        this.sequenceNumberDelta = RtpUtils.Companion.getSequenceNumberDelta(this.state.getLastSequenceNumber(), prevSequenceNumber);
                        this.timestampDelta = RtpUtils.Companion.getTimestampDiff(this.state.getLastTimestamp(), prevTimestamp);
                        CodecState codecState = this.state.getCodecState();
                        this.codecDeltas = codecState != null ? codecState.getDeltas(packet) : null;
                    }
                }
                recv.setHasDeltas(true);
            }
            if (packet instanceof Av1DDPacket && !(this.state.getCodecState() instanceof Av1DDCodecState) && this.state.getAv1PersistentState() != null) {
                CodecState codecState = this.state.getAv1PersistentState();
                this.codecDeltas = codecState != null ? codecState.getDeltas(packet) : null;
            }
            recv.getState().update(packet);
            packet.setSsrc(this.ssrc);
            packet.setSequenceNumber(RtpUtils.Companion.applySequenceNumberDelta(packet.getSequenceNumber(), this.sequenceNumberDelta));
            packet.setTimestamp(RtpUtils.Companion.applyTimestampDelta(packet.getTimestamp(), this.timestampDelta));
            CodecDeltas codecDeltas = this.codecDeltas;
            if (codecDeltas != null) {
                codecDeltas.rewritePacket(packet);
            }
            this.state.update(packet);
        } else {
            recv.getState().update(packet);
        }
    }

    public final void rewriteRtcp(@NotNull RtcpPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        packet.setSenderSsrc(this.ssrc);
        if (packet instanceof RtcpSrPacket) {
            ((RtcpSrPacket)packet).getSenderInfo().setRtpTimestamp(RtpUtils.Companion.applyTimestampDelta(((RtcpSrPacket)packet).getSenderInfo().getRtpTimestamp(), this.timestampDelta));
        }
    }

    @NotNull
    public String toString() {
        return this.ssrc + "{" + this.state + ",\u2206=" + this.sequenceNumberDelta + "/" + this.timestampDelta + "/" + this.codecDeltas + "}";
    }
}

