/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.videobridge.CodecDeltas;
import org.jitsi.videobridge.CodecState;
import org.jitsi.videobridge.Vp9CodecDeltas;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/Vp9CodecState;", "Lorg/jitsi/videobridge/CodecState;", "lastTl0Index", "", "<init>", "(I)V", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "(Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;)V", "getLastTl0Index", "()I", "getDeltas", "Lorg/jitsi/videobridge/CodecDeltas;", "otherState", "Lorg/jitsi/rtp/rtp/RtpPacket;", "toString", "", "jitsi-videobridge"})
final class Vp9CodecState
implements CodecState {
    private final int lastTl0Index;

    public Vp9CodecState(int lastTl0Index) {
        this.lastTl0Index = lastTl0Index;
    }

    public final int getLastTl0Index() {
        return this.lastTl0Index;
    }

    public Vp9CodecState(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this(packet.getTL0PICIDX());
    }

    @Override
    @Nullable
    public CodecDeltas getDeltas(@Nullable CodecState otherState) {
        if (!(otherState instanceof Vp9CodecState)) {
            return null;
        }
        int tl0IndexDelta = VpxUtils.Companion.getTl0PicIdxDelta(this.lastTl0Index, ((Vp9CodecState)otherState).lastTl0Index);
        return new Vp9CodecDeltas(tl0IndexDelta);
    }

    @Override
    @Nullable
    public CodecDeltas getDeltas(@NotNull RtpPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!(packet instanceof Vp9Packet)) {
            return null;
        }
        int tl0IndexDelta = ((Vp9Packet)packet).getHasTL0PICIDX() ? VpxUtils.Companion.getTl0PicIdxDelta(this.lastTl0Index, VpxUtils.Companion.applyTl0PicIdxDelta(((Vp9Packet)packet).getTL0PICIDX(), -1)) : 0;
        return new Vp9CodecDeltas(tl0IndexDelta);
    }

    @NotNull
    public String toString() {
        return "[VP9 TL0Idx]" + this.lastTl0Index;
    }
}

