/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.GenericAdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.av1.Av1DDAdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.vp8.VP8AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.vp9.Vp9AdaptiveSourceProjectionContext;
import org.json.simple.JSONObject;

public class AdaptiveSourceProjection {
    private final Logger logger;
    private final long targetSsrc;
    private final DiagnosticContext diagnosticContext;
    private AdaptiveSourceProjectionContext context;
    private int targetIndex = -1;
    private final HashMap<Class<? extends AdaptiveSourceProjectionContext>, Object> persistentStates = new HashMap();
    private final Runnable keyframeRequester;

    public AdaptiveSourceProjection(@NotNull DiagnosticContext diagnosticContext, @NotNull MediaSourceDesc source, Runnable keyframeRequester, Logger parentLogger) {
        this.targetSsrc = source.getPrimarySSRC();
        this.diagnosticContext = diagnosticContext;
        this.logger = parentLogger.createChildLogger(AdaptiveSourceProjection.class.getName(), Map.of("targetSsrc", Long.toString(this.targetSsrc), "srcEpId", Objects.toString(source.getOwner(), ""), "srcName", source.getSourceName()));
        this.keyframeRequester = keyframeRequester;
    }

    public void setTargetIndex(int value) {
        this.targetIndex = value;
    }

    public boolean accept(@NotNull PacketInfo packetInfo) {
        VideoRtpPacket videoRtpPacket = (VideoRtpPacket)packetInfo.packetAs();
        AdaptiveSourceProjectionContext contextCopy = this.getContext(videoRtpPacket);
        if (contextCopy == null) {
            return false;
        }
        if (videoRtpPacket.getEncodingId() == -1) {
            this.logger.warn((Object)("Dropping an RTP packet, because egress was unable to find an associated layer/encoding. rtpPacket=" + videoRtpPacket));
            return false;
        }
        int targetIndexCopy = this.targetIndex;
        boolean accept = contextCopy.accept(packetInfo, targetIndexCopy);
        if (contextCopy.needsKeyframe() && targetIndexCopy > -1) {
            this.keyframeRequester.run();
        }
        return accept;
    }

    private AdaptiveSourceProjectionContext getContext(@NotNull VideoRtpPacket rtpPacket) {
        int payloadType = rtpPacket.getPayloadType();
        if (rtpPacket instanceof Vp8Packet) {
            boolean projectable;
            boolean bl = projectable = ((Vp8Packet)rtpPacket).getHasTemporalLayerIndex() && ((Vp8Packet)rtpPacket).getHasPictureId();
            if (projectable && !(this.context instanceof VP8AdaptiveSourceProjectionContext)) {
                RtpState rtpState = this.getRtpState();
                this.logger.debug(() -> "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " VP8 context for source packet ssrc " + rtpPacket.getSsrc());
                this.context = new VP8AdaptiveSourceProjectionContext(this.diagnosticContext, rtpState, this.logger);
            } else if (!(projectable || this.context instanceof GenericAdaptiveSourceProjectionContext && ((GenericAdaptiveSourceProjectionContext)this.context).getPayloadType() == payloadType)) {
                RtpState rtpState = this.getRtpState();
                this.logger.debug(() -> {
                    boolean hasTemporalLayer = ((Vp8Packet)rtpPacket).getHasTemporalLayerIndex();
                    boolean hasPictureId = ((Vp8Packet)rtpPacket).getHasPictureId();
                    return "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " generic context for non-scalable VP8 payload  (packet is " + rtpPacket.getClass().getSimpleName() + ", ssrc " + rtpPacket.getSsrc() + ", hasTL=" + hasTemporalLayer + ", hasPID=" + hasPictureId + ")";
                });
                this.context = new GenericAdaptiveSourceProjectionContext(payloadType, rtpState, this.logger);
            }
            return this.context;
        }
        if (rtpPacket instanceof Vp9Packet) {
            if (!(this.context instanceof Vp9AdaptiveSourceProjectionContext)) {
                RtpState rtpState = this.getRtpState();
                this.logger.debug(() -> "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " VP9 context for source packet ssrc " + rtpPacket.getSsrc());
                this.context = new Vp9AdaptiveSourceProjectionContext(this.diagnosticContext, rtpState, this.logger);
            }
            return this.context;
        }
        if (rtpPacket instanceof Av1DDPacket) {
            if (!(this.context instanceof Av1DDAdaptiveSourceProjectionContext)) {
                RtpState rtpState = this.getRtpState();
                this.logger.debug(() -> "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " AV1 DD context for source packet ssrc " + rtpPacket.getSsrc());
                this.context = new Av1DDAdaptiveSourceProjectionContext(this.diagnosticContext, rtpState, this.persistentStates.get(Av1DDAdaptiveSourceProjectionContext.class), this.logger);
            }
            return this.context;
        }
        if (!(this.context instanceof GenericAdaptiveSourceProjectionContext) || ((GenericAdaptiveSourceProjectionContext)this.context).getPayloadType() != payloadType) {
            RtpState rtpState = this.getRtpState();
            this.logger.debug(() -> "adaptive source projection " + (this.context == null ? "creating new" : "changing to") + " generic context for payload type " + rtpPacket.getPayloadType());
            this.context = new GenericAdaptiveSourceProjectionContext(payloadType, rtpState, this.logger);
        }
        return this.context;
    }

    @NotNull
    private RtpState getRtpState() {
        if (this.context == null) {
            return new RtpState(this.targetSsrc, 1, 1L);
        }
        this.savePersistentState();
        return this.context.getRtpState();
    }

    private void savePersistentState() {
        if (this.context == null) {
            return;
        }
        Object state = this.context.getPersistentState();
        if (state != null) {
            if (this.context.getClass() != Av1DDAdaptiveSourceProjectionContext.class) {
                this.logger.warn((Object)("Got unexpected context persistent state from class " + this.context.getClass().getSimpleName()));
            }
            this.persistentStates.put(this.context.getClass(), state);
        } else if (this.persistentStates.get(this.context.getClass()) != null) {
            this.persistentStates.remove(this.context.getClass());
        }
    }

    public void rewriteRtp(@NotNull PacketInfo packetInfo) throws RewriteException {
        AdaptiveSourceProjectionContext contextCopy = this.context;
        if (contextCopy != null) {
            contextCopy.rewriteRtp(packetInfo);
        }
    }

    public boolean rewriteRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        AdaptiveSourceProjectionContext contextCopy = this.context;
        if (contextCopy == null) {
            return true;
        }
        return contextCopy.rewriteRtcp(rtcpSrPacket);
    }

    public long getTargetSsrc() {
        return this.targetSsrc;
    }

    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put((Object)"targetSsrc", (Object)this.targetSsrc);
        AdaptiveSourceProjectionContext contextCopy = this.context;
        debugState.put((Object)"context", (Object)(contextCopy == null ? null : contextCopy.getDebugState()));
        debugState.put((Object)"targetIndex", (Object)this.targetIndex);
        return debugState;
    }
}

