/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.concurrent.PeriodicRunnable;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.videobridge.cc.allocation.BitrateControllerStatusSnapshot;
import org.jitsi.videobridge.cc.config.BandwidthProbingConfig;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002)*B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0017\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\b\u0010&\u001a\u00020\u0015H\u0016J\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lorg/jitsi/videobridge/cc/BandwidthProbing;", "Lorg/jitsi/utils/concurrent/PeriodicRunnable;", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$Listener;", "probingDataSender", "Lorg/jitsi/videobridge/cc/BandwidthProbing$ProbingDataSender;", "statusSnapshotSupplier", "Ljava/util/function/Supplier;", "Lorg/jitsi/videobridge/cc/allocation/BitrateControllerStatusSnapshot;", "<init>", "(Lorg/jitsi/videobridge/cc/BandwidthProbing$ProbingDataSender;Ljava/util/function/Supplier;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "lastTotalNeededBps", "", "lastMaxPaddingBps", "lastPaddingBps", "zeroStats", "", "probingBitrate", "Lorg/jitsi/nlj/util/BitrateTracker;", "bytesLeftOver", "", "latestBwe", "diagnosticsContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "getDiagnosticsContext", "()Lorg/jitsi/utils/logging/DiagnosticContext;", "setDiagnosticsContext", "(Lorg/jitsi/utils/logging/DiagnosticContext;)V", "bandwidthEstimationChanged", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "run", "getDebugState", "Lorg/json/simple/JSONObject;", "Companion", "ProbingDataSender", "jitsi-videobridge"})
public final class BandwidthProbing
extends PeriodicRunnable
implements BandwidthEstimator.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProbingDataSender probingDataSender;
    @NotNull
    private final Supplier<BitrateControllerStatusSnapshot> statusSnapshotSupplier;
    private boolean enabled;
    private long lastTotalNeededBps;
    private long lastMaxPaddingBps;
    private long lastPaddingBps;
    @NotNull
    private final BitrateTracker probingBitrate;
    private int bytesLeftOver;
    private long latestBwe;
    @Nullable
    private DiagnosticContext diagnosticsContext;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(BandwidthProbing.class);

    public BandwidthProbing(@NotNull ProbingDataSender probingDataSender, @NotNull Supplier<BitrateControllerStatusSnapshot> statusSnapshotSupplier) {
        Intrinsics.checkNotNullParameter((Object)probingDataSender, (String)"probingDataSender");
        Intrinsics.checkNotNullParameter(statusSnapshotSupplier, (String)"statusSnapshotSupplier");
        super(BandwidthProbingConfig.config.getPaddingPeriodMs());
        this.probingDataSender = probingDataSender;
        this.statusSnapshotSupplier = statusSnapshotSupplier;
        this.probingBitrate = new BitrateTracker(DurationKt.getSecs((int)5), DurationKt.getMs((int)100), null, 4, null);
        this.latestBwe = -1L;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private final void zeroStats() {
        this.lastTotalNeededBps = 0L;
        this.lastMaxPaddingBps = 0L;
        this.lastPaddingBps = 0L;
    }

    @Nullable
    public final DiagnosticContext getDiagnosticsContext() {
        return this.diagnosticsContext;
    }

    public final void setDiagnosticsContext(@Nullable DiagnosticContext diagnosticContext) {
        this.diagnosticsContext = diagnosticContext;
    }

    public void bandwidthEstimationChanged-_2icLw0(double newValue) {
        this.latestBwe = (long)newValue;
    }

    public void run() {
        block9: {
            super.run();
            if (!this.enabled) {
                this.zeroStats();
                return;
            }
            BitrateControllerStatusSnapshot bitrateControllerStatusSnapshot = this.statusSnapshotSupplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)bitrateControllerStatusSnapshot, (String)"get(...)");
            BitrateControllerStatusSnapshot bitrateControllerStatus = bitrateControllerStatusSnapshot;
            long totalNeededBps = bitrateControllerStatus.getCurrentIdealBps() - bitrateControllerStatus.getCurrentTargetBps();
            if (totalNeededBps < 1L || !bitrateControllerStatus.getHasNonIdealLayer()) {
                this.bytesLeftOver = 0;
                this.zeroStats();
                return;
            }
            long latestBweCopy = this.latestBwe;
            if (bitrateControllerStatus.getCurrentIdealBps() <= latestBweCopy) {
                this.zeroStats();
                return;
            }
            long maxPaddingBps = latestBweCopy - bitrateControllerStatus.getCurrentTargetBps();
            long paddingBps = RangesKt.coerceAtMost((long)totalNeededBps, (long)maxPaddingBps);
            this.lastTotalNeededBps = totalNeededBps;
            this.lastMaxPaddingBps = maxPaddingBps;
            this.lastPaddingBps = paddingBps;
            DiagnosticContext.TimeSeriesPoint timeSeriesPoint = null;
            double newBytesNeeded = (double)(BandwidthProbingConfig.config.getPaddingPeriodMs() * paddingBps) / 1000.0 / 8.0;
            double bytesNeeded = newBytesNeeded + (double)this.bytesLeftOver;
            if (timeSeriesLogger.isTraceEnabled()) {
                DiagnosticContext diagnosticContext = this.diagnosticsContext;
                if (diagnosticContext != null) {
                    DiagnosticContext diagnosticsContext = diagnosticContext;
                    boolean bl = false;
                    timeSeriesPoint = diagnosticsContext.makeTimeSeriesPoint("sent_padding").addField("padding_bps", (Object)paddingBps).addField("total_ideal_bps", (Object)bitrateControllerStatus.getCurrentIdealBps()).addField("total_target_bps", (Object)bitrateControllerStatus.getCurrentTargetBps()).addField("needed_bps", (Object)totalNeededBps).addField("max_padding_bps", (Object)maxPaddingBps).addField("bwe_bps", (Object)latestBweCopy).addField("bytes_needed", (Object)bytesNeeded).addField("prev_bytes_left_over", (Object)this.bytesLeftOver);
                }
            }
            if (bytesNeeded >= 1.0) {
                int bytesSent = this.probingDataSender.sendProbing(bitrateControllerStatus.getActiveSsrcs(), (int)bytesNeeded);
                BitrateTracker.update$default((BitrateTracker)this.probingBitrate, (DataSize)DataSizeKt.getBytes((int)bytesSent), (long)0L, (int)2, null);
                this.bytesLeftOver = (int)RangesKt.coerceAtLeast((double)(bytesNeeded - (double)bytesSent), (double)0.0);
                DiagnosticContext.TimeSeriesPoint timeSeriesPoint2 = timeSeriesPoint;
                if (timeSeriesPoint2 != null && (timeSeriesPoint2 = timeSeriesPoint2.addField("bytes_sent", (Object)bytesSent)) != null) {
                    timeSeriesPoint2.addField("new_bytes_left_over", (Object)this.bytesLeftOver);
                }
            } else {
                this.bytesLeftOver = (int)RangesKt.coerceAtLeast((double)bytesNeeded, (double)0.0);
            }
            if (!timeSeriesLogger.isTraceEnabled()) break block9;
            TimeSeriesLogger timeSeriesLogger = BandwidthProbing.timeSeriesLogger;
            if (timeSeriesLogger != null) {
                timeSeriesLogger.trace((Map)timeSeriesPoint);
            }
        }
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$getDebugState_u24lambda_u241 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$getDebugState_u24lambda_u241.put((Object)"enabled", (Object)this.enabled);
        $this$getDebugState_u24lambda_u241.put((Object)"latestBwe", (Object)this.latestBwe);
        $this$getDebugState_u24lambda_u241.put((Object)"lastTotalNeededBps", (Object)this.lastTotalNeededBps);
        $this$getDebugState_u24lambda_u241.put((Object)"lastMaxPaddingBps", (Object)this.lastMaxPaddingBps);
        $this$getDebugState_u24lambda_u241.put((Object)"lastPaddingBps", (Object)this.lastPaddingBps);
        $this$getDebugState_u24lambda_u241.put((Object)"probingBps", (Object)BitrateTracker.getRateBps$default((BitrateTracker)this.probingBitrate, (long)0L, (int)1, null));
        return jSONObject;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/BandwidthProbing$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/BandwidthProbing$ProbingDataSender;", "", "sendProbing", "", "mediaSsrcs", "", "", "numBytes", "jitsi-videobridge"})
    public static interface ProbingDataSender {
        public int sendProbing(@NotNull Collection<Long> var1, int var2);
    }
}

