/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BE\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "", "allocations", "", "Lorg/jitsi/videobridge/cc/allocation/SingleAllocation;", "oversending", "", "idealBps", "", "targetBps", "suspendedSources", "", "", "<init>", "(Ljava/util/Set;ZJJLjava/util/List;)V", "getAllocations", "()Ljava/util/Set;", "getOversending", "()Z", "getIdealBps", "()J", "getTargetBps", "hasSuspendedSources", "getHasSuspendedSources", "forwardedSources", "getForwardedSources", "isTheSameAs", "other", "toString", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nBandwidthAllocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BandwidthAllocation.kt\norg/jitsi/videobridge/cc/allocation/BandwidthAllocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n766#2:111\n857#2,2:112\n1603#2,9:114\n1855#2:123\n1856#2:125\n1612#2:126\n1726#2,2:127\n1747#2,3:129\n1728#2:132\n1855#2,2:133\n1#3:124\n*S KotlinDebug\n*F\n+ 1 BandwidthAllocation.kt\norg/jitsi/videobridge/cc/allocation/BandwidthAllocation\n*L\n36#1:111\n36#1:112,2\n36#1:114,9\n36#1:123\n36#1:125\n36#1:126\n43#1:127,2\n44#1:129,3\n43#1:132\n62#1:133,2\n36#1:124\n*E\n"})
public final class BandwidthAllocation {
    @NotNull
    private final Set<SingleAllocation> allocations;
    private final boolean oversending;
    private final long idealBps;
    private final long targetBps;
    @NotNull
    private final List<String> suspendedSources;
    private final boolean hasSuspendedSources;
    @NotNull
    private final Set<String> forwardedSources;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending, long idealBps, long targetBps, @NotNull List<String> suspendedSources) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(allocations, (String)"allocations");
        Intrinsics.checkNotNullParameter(suspendedSources, (String)"suspendedSources");
        this.allocations = allocations;
        this.oversending = oversending;
        this.idealBps = idealBps;
        this.targetBps = targetBps;
        this.suspendedSources = suspendedSources;
        this.hasSuspendedSources = !((Collection)this.suspendedSources).isEmpty();
        Iterable iterable = this.allocations;
        BandwidthAllocation bandwidthAllocation = this;
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SingleAllocation it = (SingleAllocation)element$iv$iv;
            boolean bl = false;
            if (!it.isForwarded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SingleAllocation it = (SingleAllocation)element$iv$iv;
            boolean bl2 = false;
            MediaSourceDesc mediaSourceDesc = it.getMediaSource();
            if ((mediaSourceDesc != null ? mediaSourceDesc.getSourceName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        bandwidthAllocation.forwardedSources = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public /* synthetic */ BandwidthAllocation(Set set, boolean bl, long l, long l2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        if ((n & 8) != 0) {
            l2 = -1L;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(set, bl, l, l2, list);
    }

    @NotNull
    public final Set<SingleAllocation> getAllocations() {
        return this.allocations;
    }

    public final boolean getOversending() {
        return this.oversending;
    }

    public final long getIdealBps() {
        return this.idealBps;
    }

    public final long getTargetBps() {
        return this.targetBps;
    }

    public final boolean getHasSuspendedSources() {
        return this.hasSuspendedSources;
    }

    @NotNull
    public final Set<String> getForwardedSources() {
        return this.forwardedSources;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTheSameAs(@NotNull BandwidthAllocation other) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.allocations.size() != other.allocations.size()) return false;
        if (this.oversending != other.oversending) return false;
        Iterable $this$all$iv = this.allocations;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            boolean bl2;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            SingleAllocation allocation = (SingleAllocation)element$iv;
            boolean bl3 = false;
            Iterable $this$any$iv = other.allocations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv2 = iterator2.next();
                SingleAllocation otherAllocation = (SingleAllocation)element$iv2;
                boolean bl4 = false;
                if (Intrinsics.areEqual((Object)allocation.getEndpointId(), (Object)otherAllocation.getEndpointId())) {
                    MediaSourceDesc mediaSourceDesc = allocation.getMediaSource();
                    MediaSourceDesc mediaSourceDesc2 = otherAllocation.getMediaSource();
                    if (Intrinsics.areEqual((Object)(mediaSourceDesc != null ? Long.valueOf(mediaSourceDesc.getPrimarySSRC()) : null), (Object)(mediaSourceDesc2 != null ? Long.valueOf(mediaSourceDesc2.getPrimarySSRC()) : null))) {
                        MediaSourceDesc mediaSourceDesc3 = allocation.getMediaSource();
                        MediaSourceDesc mediaSourceDesc4 = otherAllocation.getMediaSource();
                        if ((mediaSourceDesc3 != null ? mediaSourceDesc3.getVideoType() : null) == (mediaSourceDesc4 != null ? mediaSourceDesc4.getVideoType() : null)) {
                            RtpLayerDesc rtpLayerDesc = allocation.getTargetLayer();
                            RtpLayerDesc rtpLayerDesc2 = otherAllocation.getTargetLayer();
                            if (Intrinsics.areEqual((Object)(rtpLayerDesc != null ? Integer.valueOf(rtpLayerDesc.getIndex()) : null), (Object)(rtpLayerDesc2 != null ? Integer.valueOf(rtpLayerDesc2.getIndex()) : null))) {
                                bl2 = true;
                                continue;
                            }
                        }
                    }
                }
                bl2 = false;
            } while (!bl2);
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public String toString() {
        return "oversending=" + this.oversending + " " + CollectionsKt.joinToString$default((Iterable)this.allocations, null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject $this$_get_debugState__u24lambda_u246 = jSONObject2 = new JSONObject();
        boolean bl = false;
        $this$_get_debugState__u24lambda_u246.put((Object)"idealBps", (Object)this.idealBps);
        $this$_get_debugState__u24lambda_u246.put((Object)"targetBps", (Object)this.targetBps);
        $this$_get_debugState__u24lambda_u246.put((Object)"oversending", (Object)this.oversending);
        $this$_get_debugState__u24lambda_u246.put((Object)"has_suspended_sources", (Object)this.hasSuspendedSources);
        $this$_get_debugState__u24lambda_u246.put((Object)"suspended_sources", this.suspendedSources);
        JSONObject $this$_get_debugState__u24lambda_u246_u24lambda_u245 = jSONObject = new JSONObject();
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.allocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleAllocation it = (SingleAllocation)element$iv;
            boolean bl3 = false;
            Object object = it.getMediaSource();
            if (object == null || (object = object.getSourceName()) == null) {
                object = it.getEndpointId();
            }
            Object name = object;
            $this$_get_debugState__u24lambda_u246_u24lambda_u245.put(name, (Object)it.getDebugState());
        }
        JSONObject allocations = jSONObject;
        $this$_get_debugState__u24lambda_u246.put((Object)"allocations", (Object)allocations);
        return jSONObject2;
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending, long idealBps, long targetBps) {
        Intrinsics.checkNotNullParameter(allocations, (String)"allocations");
        this(allocations, oversending, idealBps, targetBps, null, 16, null);
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending, long idealBps) {
        Intrinsics.checkNotNullParameter(allocations, (String)"allocations");
        this(allocations, oversending, idealBps, 0L, null, 24, null);
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending) {
        Intrinsics.checkNotNullParameter(allocations, (String)"allocations");
        this(allocations, oversending, 0L, 0L, null, 28, null);
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations) {
        Intrinsics.checkNotNullParameter(allocations, (String)"allocations");
        this(allocations, false, 0L, 0L, null, 30, null);
    }
}

