/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorReader;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyException;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.av1.Av1DDFrameProjection;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0089\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0006\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0014\u001a\u00020\t\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018B\u0019\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u001bJ\u000e\u0010=\u001a\u00020>2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\u0000J\u000e\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\u001aJ\u000e\u0010G\u001a\u00020>2\u0006\u0010F\u001a\u00020\u001aJ\u000e\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020\u0000J\b\u0010J\u001a\u00020KH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010&\"\u0004\b'\u0010(R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\"\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010+\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010+\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010 R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010 R\u001e\u0010\b\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010&R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010&R\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010&R\u001c\u00105\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010&\"\u0004\b<\u0010(\u00a8\u0006L"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "", "ssrc", "", "timestamp", "earliestKnownSequenceNumber", "", "latestKnownSequenceNumber", "seenStartOfFrame", "", "seenEndOfFrame", "seenMarker", "frameInfo", "Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;", "frameNumber", "index", "templateId", "structure", "Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;", "activeDecodeTargets", "isKeyframe", "rawDependencyDescriptor", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "<init>", "(JJIIZZZLorg/jitsi/rtp/rtp/header_extensions/FrameInfo;IIILorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;Ljava/lang/Integer;ZLorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;)V", "packet", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "(Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;I)V", "getSsrc", "()J", "getTimestamp", "getFrameNumber", "()I", "getIndex", "getTemplateId", "getActiveDecodeTargets", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "()Z", "setKeyframe", "(Z)V", "getRawDependencyDescriptor", "()Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "value", "getFrameInfo", "()Lorg/jitsi/rtp/rtp/header_extensions/FrameInfo;", "getStructure", "()Lorg/jitsi/rtp/rtp/header_extensions/Av1TemplateDependencyStructure;", "getEarliestKnownSequenceNumber", "getLatestKnownSequenceNumber", "getSeenStartOfFrame", "getSeenEndOfFrame", "getSeenMarker", "projection", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "getProjection", "()Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "setProjection", "(Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;)V", "isAccepted", "setAccepted", "addPacket", "", "updateParse", "templateDependencyStructure", "logger", "Lorg/jitsi/utils/logging2/Logger;", "matchesSSRC", "av1Frame", "matchesFrame", "pkt", "validateConsistency", "isImmediatelyAfter", "otherFrame", "toString", "", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAv1DDFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDFrame.kt\norg/jitsi/videobridge/cc/av1/Av1DDFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public final class Av1DDFrame {
    private final long ssrc;
    private final long timestamp;
    private final int frameNumber;
    private final int index;
    private final int templateId;
    @Nullable
    private final Integer activeDecodeTargets;
    private boolean isKeyframe;
    @Nullable
    private final RtpPacket.HeaderExtension rawDependencyDescriptor;
    @Nullable
    private FrameInfo frameInfo;
    @Nullable
    private Av1TemplateDependencyStructure structure;
    private int earliestKnownSequenceNumber;
    private int latestKnownSequenceNumber;
    private boolean seenStartOfFrame;
    private boolean seenEndOfFrame;
    private boolean seenMarker;
    @Nullable
    private Av1DDFrameProjection projection;
    private boolean isAccepted;

    public Av1DDFrame(long ssrc, long timestamp, int earliestKnownSequenceNumber, int latestKnownSequenceNumber, boolean seenStartOfFrame, boolean seenEndOfFrame, boolean seenMarker, @Nullable FrameInfo frameInfo, int frameNumber, int index, int templateId, @Nullable Av1TemplateDependencyStructure structure, @Nullable Integer activeDecodeTargets, boolean isKeyframe, @Nullable RtpPacket.HeaderExtension rawDependencyDescriptor) {
        boolean bl;
        this.ssrc = ssrc;
        this.timestamp = timestamp;
        this.frameNumber = frameNumber;
        this.index = index;
        this.templateId = templateId;
        this.activeDecodeTargets = activeDecodeTargets;
        this.isKeyframe = isKeyframe;
        this.rawDependencyDescriptor = rawDependencyDescriptor;
        this.frameInfo = frameInfo;
        this.structure = structure;
        this.earliestKnownSequenceNumber = earliestKnownSequenceNumber;
        this.latestKnownSequenceNumber = latestKnownSequenceNumber;
        this.seenStartOfFrame = seenStartOfFrame;
        this.seenEndOfFrame = seenEndOfFrame;
        this.seenMarker = seenMarker;
        boolean bl2 = bl = (this.index & 0xFFFF) == this.frameNumber;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final long getSsrc() {
        return this.ssrc;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getFrameNumber() {
        return this.frameNumber;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getTemplateId() {
        return this.templateId;
    }

    @Nullable
    public final Integer getActiveDecodeTargets() {
        return this.activeDecodeTargets;
    }

    public final boolean isKeyframe() {
        return this.isKeyframe;
    }

    public final void setKeyframe(boolean bl) {
        this.isKeyframe = bl;
    }

    @Nullable
    public final RtpPacket.HeaderExtension getRawDependencyDescriptor() {
        return this.rawDependencyDescriptor;
    }

    @Nullable
    public final FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    @Nullable
    public final Av1TemplateDependencyStructure getStructure() {
        return this.structure;
    }

    public final int getEarliestKnownSequenceNumber() {
        return this.earliestKnownSequenceNumber;
    }

    public final int getLatestKnownSequenceNumber() {
        return this.latestKnownSequenceNumber;
    }

    public final boolean getSeenStartOfFrame() {
        return this.seenStartOfFrame;
    }

    public final boolean getSeenEndOfFrame() {
        return this.seenEndOfFrame;
    }

    public final boolean getSeenMarker() {
        return this.seenMarker;
    }

    @Nullable
    public final Av1DDFrameProjection getProjection() {
        return this.projection;
    }

    public final void setProjection(@Nullable Av1DDFrameProjection av1DDFrameProjection) {
        this.projection = av1DDFrameProjection;
    }

    public final boolean isAccepted() {
        return this.isAccepted;
    }

    public final void setAccepted(boolean bl) {
        this.isAccepted = bl;
    }

    public Av1DDFrame(@NotNull Av1DDPacket packet, int index) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        long l = packet.getSsrc();
        long l2 = packet.getTimestamp();
        int n = packet.getSequenceNumber();
        int n2 = packet.getSequenceNumber();
        boolean bl = packet.isStartOfFrame();
        boolean bl2 = packet.isEndOfFrame();
        boolean bl3 = packet.isMarked();
        FrameInfo frameInfo = packet.getFrameInfo();
        int n3 = packet.getStatelessDescriptor().getFrameNumber();
        int n4 = packet.getStatelessDescriptor().getFrameDependencyTemplateId();
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = packet.getDescriptor();
        Object object2 = av1DependencyDescriptorHeaderExtension != null ? av1DependencyDescriptorHeaderExtension.getStructure() : null;
        Integer n5 = packet.getActiveDecodeTargets();
        boolean bl4 = packet.isKeyframe();
        if (packet.getFrameInfo() == null) {
            RtpPacket.HeaderExtension headerExtension = packet.getHeaderExtension(packet.getAv1DDHeaderExtensionId());
            object = headerExtension != null ? headerExtension.clone() : null;
        } else {
            object = null;
        }
        this(l, l2, n, n2, bl, bl2, bl3, frameInfo, n3, index, n4, (Av1TemplateDependencyStructure)object2, n5, bl4, (RtpPacket.HeaderExtension)object);
    }

    public final void addPacket(@NotNull Av1DDPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!this.matchesFrame(packet)) {
            boolean bl = false;
            String string = "Non-matching packet added to frame";
            throw new IllegalArgumentException(string.toString());
        }
        int seq = packet.getSequenceNumber();
        if (RtpUtilsKt.isOlderThan((int)seq, (int)this.earliestKnownSequenceNumber)) {
            this.earliestKnownSequenceNumber = seq;
        }
        if (RtpUtilsKt.isNewerThan((int)seq, (int)this.latestKnownSequenceNumber)) {
            this.latestKnownSequenceNumber = seq;
        }
        if (packet.isStartOfFrame()) {
            this.seenStartOfFrame = true;
        }
        if (packet.isEndOfFrame()) {
            this.seenEndOfFrame = true;
        }
        if (packet.isMarked()) {
            this.seenMarker = true;
        }
        if (this.structure == null) {
            Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = packet.getDescriptor();
            if ((av1DependencyDescriptorHeaderExtension != null ? av1DependencyDescriptorHeaderExtension.getStructure() : null) != null) {
                Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension2 = packet.getDescriptor();
                Object object = this.structure = av1DependencyDescriptorHeaderExtension2 != null ? av1DependencyDescriptorHeaderExtension2.getStructure() : null;
            }
        }
        if (this.frameInfo == null && packet.getFrameInfo() != null) {
            this.frameInfo = packet.getFrameInfo();
        }
    }

    public final void updateParse(@NotNull Av1TemplateDependencyStructure templateDependencyStructure, @NotNull Logger logger) {
        Av1DDFrame av1DDFrame;
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension;
        Intrinsics.checkNotNullParameter((Object)templateDependencyStructure, (String)"templateDependencyStructure");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (this.rawDependencyDescriptor == null) {
            return;
        }
        Av1DependencyDescriptorReader parser = new Av1DependencyDescriptorReader(this.rawDependencyDescriptor);
        try {
            av1DependencyDescriptorHeaderExtension = parser.parse(templateDependencyStructure);
        }
        catch (Av1DependencyException e) {
            logger.warn((Object)("Could not parse updated AV1 Dependency Descriptor: " + e.getMessage()));
            return;
        }
        Av1DependencyDescriptorHeaderExtension descriptor = av1DependencyDescriptorHeaderExtension;
        this.structure = descriptor.getStructure();
        Av1DDFrame av1DDFrame2 = this;
        try {
            av1DDFrame = av1DDFrame2;
            av1DependencyDescriptorHeaderExtension = descriptor.getFrameInfo();
        }
        catch (Av1DependencyException e) {
            av1DDFrame = av1DDFrame2;
            logger.warn((Object)("Could not extract frame info from updated AV1 Dependency Descriptor: " + e.getMessage()));
            av1DependencyDescriptorHeaderExtension = null;
        }
        av1DDFrame.frameInfo = av1DependencyDescriptorHeaderExtension;
    }

    public final boolean matchesSSRC(@NotNull Av1DDFrame av1Frame) {
        Intrinsics.checkNotNullParameter((Object)av1Frame, (String)"av1Frame");
        return this.ssrc == av1Frame.ssrc;
    }

    public final boolean matchesFrame(@NotNull Av1DDPacket pkt) {
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        return this.ssrc == pkt.getSsrc() && this.timestamp == pkt.getTimestamp() && this.frameNumber == pkt.getFrameNumber();
    }

    public final void validateConsistency(@NotNull Av1DDPacket pkt) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        if (this.frameInfo == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.frameInfo, (Object)pkt.getFrameInfo())) {
            return;
        }
        StringBuilder $this$validateConsistency_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Av1DDPacket $this$validateConsistency_u24lambda_u242_u24lambda_u241 = pkt;
        boolean bl2 = false;
        $this$validateConsistency_u24lambda_u242.append("Packet ssrc " + $this$validateConsistency_u24lambda_u242_u24lambda_u241.getSsrc() + ", seq " + $this$validateConsistency_u24lambda_u242_u24lambda_u241.getSequenceNumber() + ", frame number " + $this$validateConsistency_u24lambda_u242_u24lambda_u241.getFrameNumber() + ", timestamp " + $this$validateConsistency_u24lambda_u242_u24lambda_u241.getTimestamp() + " ");
        $this$validateConsistency_u24lambda_u242.append("packet template " + $this$validateConsistency_u24lambda_u242_u24lambda_u241.getStatelessDescriptor().getFrameDependencyTemplateId() + " ");
        $this$validateConsistency_u24lambda_u242.append("frame info " + $this$validateConsistency_u24lambda_u242_u24lambda_u241.getFrameInfo() + " ");
        $this$validateConsistency_u24lambda_u242.append("is not consistent with frame " + this);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        throw new RuntimeException(string2);
    }

    public final boolean isImmediatelyAfter(@NotNull Av1DDFrame otherFrame) {
        Intrinsics.checkNotNullParameter((Object)otherFrame, (String)"otherFrame");
        return this.frameNumber == RtpUtils.Companion.applySequenceNumberDelta(otherFrame.frameNumber, 1);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u243.append(this.ssrc + ", ");
        $this$toString_u24lambda_u243.append("seq " + this.earliestKnownSequenceNumber + "-" + this.latestKnownSequenceNumber + " ");
        $this$toString_u24lambda_u243.append("frame number " + this.frameNumber + ", timestamp " + this.timestamp + ": ");
        $this$toString_u24lambda_u243.append("frame template " + this.templateId + " info " + this.frameInfo);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

