/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp8;

import java.time.Clock;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.PictureIdIndexTracker;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.vp8.VP8Frame;

public class VP8FrameMap {
    static final int FRAME_MAP_SIZE = 500;
    private final FrameHistory frameHistory = new FrameHistory(500);
    private final Logger logger;

    public VP8FrameMap(@NotNull Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(VP8FrameMap.class.getName());
    }

    public synchronized VP8Frame findFrame(@NotNull Vp8Packet packet) {
        return this.frameHistory.get(packet.getPictureId());
    }

    public int size() {
        return this.frameHistory.numCached;
    }

    @NotNull
    @Contract(value="_, _ -> new")
    private FrameInsertionResult doFrameInsert(@NotNull VP8Frame frame, Vp8Packet packet) {
        try {
            frame.validateConsistency(packet);
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
        frame.addPacket(packet);
        return new FrameInsertionResult(frame, false, false);
    }

    private boolean isLargeJump(@NotNull Vp8Packet packet) {
        VP8Frame latestFrame = this.frameHistory.getLatestFrame();
        if (latestFrame == null) {
            return false;
        }
        int picDelta = VpxUtils.getExtendedPictureIdDelta((int)packet.getPictureId(), (int)latestFrame.getPictureId());
        if (picDelta > 500) {
            return true;
        }
        long tsDelta = RtpUtils.getTimestampDiff((long)packet.getTimestamp(), (long)latestFrame.getTimestamp());
        if (picDelta < 0) {
            if (tsDelta > 0L) {
                return true;
            }
            if (RtpUtils.getSequenceNumberDelta((int)packet.getSequenceNumber(), (int)latestFrame.getLatestKnownSequenceNumber()) > 0) {
                return true;
            }
        }
        return tsDelta > 90000000L;
    }

    public synchronized FrameInsertionResult insertPacket(@NotNull Vp8Packet packet) {
        int pictureId = packet.getPictureId();
        if (pictureId == -1) {
            return null;
        }
        if (this.isLargeJump(packet)) {
            this.frameHistory.indexTracker.resetAt(pictureId);
            VP8Frame frame = new VP8Frame(packet);
            if (!this.frameHistory.insert(pictureId, frame)) {
                return null;
            }
            return new FrameInsertionResult(frame, true, true);
        }
        VP8Frame frame = this.frameHistory.get(pictureId);
        if (frame != null) {
            if (!frame.matchesFrame(packet)) {
                if (frame.getPictureId() != pictureId) {
                    throw new IllegalStateException("Frame map returned frame with picture ID " + frame.getPictureId() + " when asked for frame with picture ID " + pictureId);
                }
                this.logger.warn((Object)("Cannot insert packet in frame map: frame with ssrc " + frame.getSsrc() + ", timestamp " + frame.getTimestamp() + ", and sequence number range " + frame.getEarliestKnownSequenceNumber() + "-" + frame.getLatestKnownSequenceNumber() + ", and packet " + packet.getSequenceNumber() + " with ssrc " + packet.getSsrc() + ", timestamp " + packet.getTimestamp() + ", and sequence number " + packet.getSequenceNumber() + " both have picture ID " + pictureId));
                return null;
            }
            return this.doFrameInsert(frame, packet);
        }
        frame = new VP8Frame(packet);
        if (!this.frameHistory.insert(pictureId, frame)) {
            return null;
        }
        return new FrameInsertionResult(frame, true, false);
    }

    @Nullable
    public synchronized VP8Frame nextFrame(@NotNull VP8Frame frame) {
        return this.frameHistory.findAfter(frame, f -> true);
    }

    @Nullable
    public synchronized VP8Frame nextFrameWith(@NotNull VP8Frame frame, Predicate<VP8Frame> pred) {
        return this.frameHistory.findAfter(frame, pred);
    }

    @Nullable
    public synchronized VP8Frame findNextTl0(@NotNull VP8Frame frame) {
        return this.nextFrameWith(frame, VP8Frame::isTL0);
    }

    @Nullable
    public synchronized VP8Frame findNextAcceptedFrame(@NotNull VP8Frame frame) {
        return this.nextFrameWith(frame, VP8Frame::isAccepted);
    }

    @Nullable
    public synchronized VP8Frame prevFrame(@NotNull VP8Frame frame) {
        return this.frameHistory.findBefore(frame, f -> true);
    }

    @Nullable
    public synchronized VP8Frame prevFrameWith(@NotNull VP8Frame frame, Predicate<VP8Frame> pred) {
        return this.frameHistory.findBefore(frame, pred);
    }

    @Nullable
    public synchronized VP8Frame findPrevAcceptedFrame(@NotNull VP8Frame frame) {
        return this.prevFrameWith(frame, VP8Frame::isAccepted);
    }

    private static class FrameHistory
    extends ArrayCache<VP8Frame> {
        int numCached = 0;
        int firstIndex = -1;
        PictureIdIndexTracker indexTracker = new PictureIdIndexTracker();

        FrameHistory(int size) {
            super(size, k -> k, false, Clock.systemUTC());
        }

        public VP8Frame get(int pictureId) {
            int index = this.indexTracker.interpret(pictureId);
            return this.getIndex(index);
        }

        private VP8Frame getIndex(int index) {
            if (index <= this.getLastIndex() - this.getSize()) {
                return null;
            }
            ArrayCache.Container c = this.getContainer(index);
            if (c == null) {
                return null;
            }
            return (VP8Frame)c.getItem();
        }

        private VP8Frame getLatestFrame() {
            return this.getIndex(this.getLastIndex());
        }

        public boolean insert(int pictureId, VP8Frame frame) {
            int index = this.indexTracker.update(pictureId);
            boolean ret = super.insertItem((Object)frame, index);
            if (ret) {
                ++this.numCached;
                if (this.firstIndex == -1 || index < this.firstIndex) {
                    this.firstIndex = index;
                }
            }
            return ret;
        }

        protected void discardItem(VP8Frame frame) {
            --this.numCached;
        }

        @Nullable
        public VP8Frame findBefore(VP8Frame frame, Predicate<VP8Frame> pred) {
            int lastIndex = this.getLastIndex();
            if (lastIndex == -1) {
                return null;
            }
            int index = this.indexTracker.interpret(frame.getPictureId());
            int searchStartIndex = Integer.min(index - 1, lastIndex);
            int searchEndIndex = Integer.max(lastIndex - this.getSize(), this.firstIndex - 1);
            return this.doFind(pred, searchStartIndex, searchEndIndex, -1);
        }

        @Nullable
        public VP8Frame findAfter(VP8Frame frame, Predicate<VP8Frame> pred) {
            int lastIndex = this.getLastIndex();
            if (lastIndex == -1) {
                return null;
            }
            int index = this.indexTracker.interpret(frame.getPictureId());
            if (index >= lastIndex) {
                return null;
            }
            int searchStartIndex = Integer.max(index + 1, Integer.max(lastIndex - this.getSize() + 1, this.firstIndex));
            return this.doFind(pred, searchStartIndex, lastIndex + 1, 1);
        }

        @Nullable
        private VP8Frame doFind(Predicate<VP8Frame> pred, int startIndex, int endIndex, int increment) {
            for (int index = startIndex; index != endIndex; index += increment) {
                VP8Frame frame = this.getIndex(index);
                if (frame == null || !pred.test(frame)) continue;
                return frame;
            }
            return null;
        }
    }

    public static class FrameInsertionResult {
        private VP8Frame frame;
        private boolean newFrame;
        private boolean reset;

        private FrameInsertionResult(VP8Frame frame, boolean newFrame, boolean reset) {
            this.frame = frame;
            this.newFrame = newFrame;
            this.reset = reset;
        }

        public VP8Frame getFrame() {
            return this.frame;
        }

        public boolean isNewFrame() {
            return this.newFrame;
        }

        public boolean isReset() {
            return this.reset;
        }
    }
}

