/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.dcsctp;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.dcsctp4j.DcSctpMessage;
import org.jitsi.dcsctp4j.DcSctpOptions;
import org.jitsi.dcsctp4j.DcSctpSocketCallbacks;
import org.jitsi.dcsctp4j.DcSctpSocketFactory;
import org.jitsi.dcsctp4j.DcSctpSocketInterface;
import org.jitsi.dcsctp4j.Metrics;
import org.jitsi.dcsctp4j.SendOptions;
import org.jitsi.dcsctp4j.SendStatus;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.rtp.Packet;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.sctp.SctpConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "", "name", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Ljava/lang/String;Lorg/jitsi/utils/logging2/Logger;)V", "getName", "()Ljava/lang/String;", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "lock", "socket", "Lorg/jitsi/dcsctp4j/DcSctpSocketInterface;", "start", "", "callbacks", "Lorg/jitsi/dcsctp4j/DcSctpSocketCallbacks;", "options", "Lorg/jitsi/dcsctp4j/DcSctpOptions;", "handleIncomingSctp", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "stop", "connect", "send", "Lorg/jitsi/dcsctp4j/SendStatus;", "message", "Lorg/jitsi/dcsctp4j/DcSctpMessage;", "Lorg/jitsi/dcsctp4j/SendOptions;", "handleTimeout", "timeoutId", "", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nDcSctpTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DcSctpTransport.kt\norg/jitsi/videobridge/dcsctp/DcSctpTransport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class DcSctpTransport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Object lock;
    @Nullable
    private DcSctpSocketInterface socket;
    @NotNull
    private static final Lazy<DcSctpSocketFactory> factory$delegate = LazyKt.lazy(DcSctpTransport::factory_delegate$lambda$9);
    public static final long DEFAULT_MAX_TIMER_DURATION = 3000L;
    @NotNull
    private static final Lazy<DcSctpOptions> DEFAULT_SOCKET_OPTIONS$delegate = LazyKt.lazy(DcSctpTransport::DEFAULT_SOCKET_OPTIONS_delegate$lambda$12);
    @NotNull
    private static final Lazy<SendOptions> DEFAULT_SEND_OPTIONS$delegate = LazyKt.lazy(DcSctpTransport::DEFAULT_SEND_OPTIONS_delegate$lambda$14);
    public static final int DEFAULT_SCTP_PORT = 5000;

    public DcSctpTransport(@NotNull String name, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.name = name;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.lock = new Object();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull DcSctpSocketCallbacks callbacks, @NotNull DcSctpOptions options) {
        Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.socket = DcSctpTransport.Companion.getFactory().create(this.name, callbacks, null, options);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void start$default(DcSctpTransport dcSctpTransport, DcSctpSocketCallbacks dcSctpSocketCallbacks, DcSctpOptions dcSctpOptions, int n, Object object) {
        if ((n & 2) != 0) {
            dcSctpOptions = Companion.getDEFAULT_SOCKET_OPTIONS();
        }
        dcSctpTransport.start(dcSctpSocketCallbacks, dcSctpOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleIncomingSctp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        Packet packet = packetInfo.getPacket();
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            DcSctpSocketInterface dcSctpSocketInterface = this.socket;
            if (dcSctpSocketInterface != null) {
                dcSctpSocketInterface.receivePacket(packet.getBuffer(), packet.getOffset(), packet.getLength());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            DcSctpSocketInterface dcSctpSocketInterface = this.socket;
            if (dcSctpSocketInterface != null) {
                dcSctpSocketInterface.close();
            }
            this.socket = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            DcSctpSocketInterface dcSctpSocketInterface = this.socket;
            if (dcSctpSocketInterface != null) {
                dcSctpSocketInterface.connect();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SendStatus send(@NotNull DcSctpMessage message, @NotNull SendOptions options) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            DcSctpSocketInterface dcSctpSocketInterface = this.socket;
            if (dcSctpSocketInterface == null || (dcSctpSocketInterface = dcSctpSocketInterface.send(message, options)) == null) {
                dcSctpSocketInterface = SendStatus.kErrorShuttingDown;
            }
            DcSctpSocketInterface dcSctpSocketInterface2 = dcSctpSocketInterface;
            return dcSctpSocketInterface2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTimeout(long timeoutId) {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            DcSctpSocketInterface dcSctpSocketInterface = this.socket;
            if (dcSctpSocketInterface != null) {
                dcSctpSocketInterface.handleTimeout(timeoutId);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        Metrics $i$a$-synchronized-DcSctpTransport$getDebugState$metrics$22;
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-DcSctpTransport$getDebugState$metrics$22 = false;
            DcSctpSocketInterface dcSctpSocketInterface = this.socket;
            $i$a$-synchronized-DcSctpTransport$getDebugState$metrics$22 = dcSctpSocketInterface != null ? dcSctpSocketInterface.getMetrics() : null;
        }
        Metrics metrics = $i$a$-synchronized-DcSctpTransport$getDebugState$metrics$22;
        OrderedJsonObject $this$getDebugState_u24lambda_u247 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        if (metrics != null) {
            $this$getDebugState_u24lambda_u247.put((Object)"tx_packets_count", (Object)metrics.getTxPacketsCount());
            $this$getDebugState_u24lambda_u247.put((Object)"tx_messages_count", (Object)metrics.getTxMessagesCount());
            $this$getDebugState_u24lambda_u247.put((Object)"rtx_packets_count", (Object)metrics.getRtxPacketsCount());
            $this$getDebugState_u24lambda_u247.put((Object)"rtx_bytes_count", (Object)metrics.getRtxBytesCount());
            $this$getDebugState_u24lambda_u247.put((Object)"cwnd_bytes", (Object)metrics.getCwndBytes());
            $this$getDebugState_u24lambda_u247.put((Object)"srtt_ms", (Object)metrics.getSrttMs());
            $this$getDebugState_u24lambda_u247.put((Object)"unack_data_count", (Object)metrics.getUnackDataCount());
            $this$getDebugState_u24lambda_u247.put((Object)"rx_packets_count", (Object)metrics.getRxPacketsCount());
            $this$getDebugState_u24lambda_u247.put((Object)"rx_messages_count", (Object)metrics.getRxMessagesCount());
            $this$getDebugState_u24lambda_u247.put((Object)"peer_rwnd_bytes", (Object)metrics.getPeerRwndBytes());
            $this$getDebugState_u24lambda_u247.put((Object)"peer_implementation", (Object)metrics.getPeerImplementation().name());
            $this$getDebugState_u24lambda_u247.put((Object)"uses_message_interleaving", (Object)metrics.usesMessageInterleaving());
            $this$getDebugState_u24lambda_u247.put((Object)"uses_zero_checksum", (Object)metrics.usesZeroChecksum());
            $this$getDebugState_u24lambda_u247.put((Object)"negotiated_maximum_incoming_streams", (Object)metrics.getNegotiatedMaximumIncomingStreams());
            $this$getDebugState_u24lambda_u247.put((Object)"negotiated_maximum_outgoing_streams", (Object)metrics.getNegotiatedMaximumOutgoingStreams());
        }
        return orderedJsonObject;
    }

    private static final DcSctpSocketFactory factory_delegate$lambda$9() {
        if (!SctpConfig.config.enabled()) {
            boolean bl = false;
            String string = "SCTP is disabled in configuration";
            throw new IllegalStateException(string.toString());
        }
        return new DcSctpSocketFactory();
    }

    private static final DcSctpOptions DEFAULT_SOCKET_OPTIONS_delegate$lambda$12() {
        DcSctpOptions dcSctpOptions;
        if (!SctpConfig.config.enabled()) {
            boolean $i$a$-check-DcSctpTransport$Companion$DEFAULT_SOCKET_OPTIONS$2$22 = false;
            String $i$a$-check-DcSctpTransport$Companion$DEFAULT_SOCKET_OPTIONS$2$22 = "SCTP is disabled in configuration";
            throw new IllegalStateException($i$a$-check-DcSctpTransport$Companion$DEFAULT_SOCKET_OPTIONS$2$22.toString());
        }
        DcSctpOptions $this$DEFAULT_SOCKET_OPTIONS_delegate_u24lambda_u2412_u24lambda_u2411 = dcSctpOptions = new DcSctpOptions();
        boolean bl = false;
        $this$DEFAULT_SOCKET_OPTIONS_delegate_u24lambda_u2412_u24lambda_u2411.setMaxTimerBackoffDuration(Long.valueOf(3000L));
        $this$DEFAULT_SOCKET_OPTIONS_delegate_u24lambda_u2412_u24lambda_u2411.setMaxRetransmissions(null);
        $this$DEFAULT_SOCKET_OPTIONS_delegate_u24lambda_u2412_u24lambda_u2411.setMaxInitRetransmits(null);
        return dcSctpOptions;
    }

    private static final SendOptions DEFAULT_SEND_OPTIONS_delegate$lambda$14() {
        if (!SctpConfig.config.enabled()) {
            boolean bl = false;
            String string = "SCTP is disabled in configuration";
            throw new IllegalStateException(string.toString());
        }
        return new SendOptions();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\t\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/videobridge/dcsctp/DcSctpTransport$Companion;", "", "<init>", "()V", "factory", "Lorg/jitsi/dcsctp4j/DcSctpSocketFactory;", "getFactory", "()Lorg/jitsi/dcsctp4j/DcSctpSocketFactory;", "factory$delegate", "Lkotlin/Lazy;", "DEFAULT_MAX_TIMER_DURATION", "", "DEFAULT_SOCKET_OPTIONS", "Lorg/jitsi/dcsctp4j/DcSctpOptions;", "getDEFAULT_SOCKET_OPTIONS", "()Lorg/jitsi/dcsctp4j/DcSctpOptions;", "DEFAULT_SOCKET_OPTIONS$delegate", "DEFAULT_SEND_OPTIONS", "Lorg/jitsi/dcsctp4j/SendOptions;", "getDEFAULT_SEND_OPTIONS", "()Lorg/jitsi/dcsctp4j/SendOptions;", "DEFAULT_SEND_OPTIONS$delegate", "DEFAULT_SCTP_PORT", "", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        private final DcSctpSocketFactory getFactory() {
            Lazy lazy = factory$delegate;
            return (DcSctpSocketFactory)lazy.getValue();
        }

        @NotNull
        public final DcSctpOptions getDEFAULT_SOCKET_OPTIONS() {
            Lazy lazy = DEFAULT_SOCKET_OPTIONS$delegate;
            return (DcSctpOptions)lazy.getValue();
        }

        @NotNull
        public final SendOptions getDEFAULT_SEND_OPTIONS() {
            Lazy lazy = DEFAULT_SEND_OPTIONS$delegate;
            return (SendOptions)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

