/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.stats.DelayStats;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.stats.BucketStats;
import org.jitsi.videobridge.metrics.Metrics;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.xmpp.config.XmppClientConnectionConfig;
import org.jitsi.xmpp.extensions.colibri.ForcefulShutdownIQ;
import org.jitsi.xmpp.extensions.colibri.GracefulShutdownIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.health.HealthCheckIQ;
import org.jitsi.xmpp.mucclient.ConnectionStateListener;
import org.jitsi.xmpp.mucclient.IQListener;
import org.jitsi.xmpp.mucclient.MucClient;
import org.jitsi.xmpp.mucclient.MucClientConfiguration;
import org.jitsi.xmpp.mucclient.MucClientManager;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.iqversion.packet.Version;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u0000 62\u00020\u0001:\u0003456B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001d\u001a\u00020\u001a*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010)\u001a\u00020$*\u00020$2\u0006\u0010*\u001a\u00020$H\u0002J7\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\f\u00102\u001a\b\u0012\u0004\u0012\u0002H,00H\u0002\u00a2\u0006\u0002\u00103R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00067"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection;", "Lorg/jitsi/xmpp/mucclient/IQListener;", "<init>", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "mucClientManager", "Lorg/jitsi/xmpp/mucclient/MucClientManager;", "getMucClientManager", "()Lorg/jitsi/xmpp/mucclient/MucClientManager;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "eventHandler", "Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;", "getEventHandler", "()Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;", "setEventHandler", "(Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;)V", "start", "", "stop", "updateMetrics", "setPresenceExtension", "extension", "Lorg/jivesoftware/smack/packet/ExtensionElement;", "addMucClient", "", "jsonObject", "Lorg/json/simple/JSONObject;", "matches", "Lorg/jitsi/xmpp/mucclient/MucClientConfiguration;", "other", "getMucClientIds", "", "removeMucClient", "handleIq", "Lorg/jivesoftware/smack/packet/IQ;", "iq", "mucClient", "Lorg/jitsi/xmpp/mucclient/MucClient;", "handleIqRequest", "setResponseTo", "request", "measureDelay", "T", "delayStats", "Lorg/jitsi/nlj/stats/DelayStats;", "context", "Lkotlin/Function0;", "", "block", "(Lorg/jitsi/nlj/stats/DelayStats;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "EventHandler", "ColibriRequest", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nXmppConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmppConnection.kt\norg/jitsi/videobridge/xmpp/XmppConnection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,341:1\n1855#2,2:342\n1#3:344\n63#4,4:345\n63#4,4:349\n*S KotlinDebug\n*F\n+ 1 XmppConnection.kt\norg/jitsi/videobridge/xmpp/XmppConnection\n*L\n79#1:342,2\n211#1:345,4\n216#1:349,4\n*E\n"})
public final class XmppConnection
implements IQListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
    @NotNull
    private final MucClientManager mucClientManager = new MucClientManager(FEATURES);
    @NotNull
    private final AtomicBoolean running = new AtomicBoolean(false);
    @Nullable
    private EventHandler eventHandler;
    @NotNull
    private static final String[] FEATURES;
    @NotNull
    private static final List<Long> delayThresholds;
    @NotNull
    private static final DelayStats colibriProcessingDelayStats;
    @NotNull
    private static final DelayStats colibriDelayStats;
    @NotNull
    private static final DelayStats healthDelayStats;
    @NotNull
    private static final DelayStats versionDelayStats;
    @NotNull
    private static final LongGaugeMetric mucClientsConfigured;
    @NotNull
    private static final LongGaugeMetric mucClientsConnected;
    @NotNull
    private static final LongGaugeMetric mucsConfigured;
    @NotNull
    private static final LongGaugeMetric mucsJoined;

    @NotNull
    public final MucClientManager getMucClientManager() {
        return this.mucClientManager;
    }

    @Nullable
    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public final void setEventHandler(@Nullable EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public final void start() {
        if (this.running.compareAndSet(false, true)) {
            MucClientManager mucClientManager;
            MucClientManager $this$start_u24lambda_u240 = mucClientManager = this.mucClientManager;
            boolean bl = false;
            $this$start_u24lambda_u240.registerIQ((IQ)new HealthCheckIQ());
            $this$start_u24lambda_u240.registerIQ((IQ)new Version());
            $this$start_u24lambda_u240.registerIQ((IQ)new ForcefulShutdownIQ());
            $this$start_u24lambda_u240.registerIQ((IQ)new GracefulShutdownIQ());
            $this$start_u24lambda_u240.registerIQ("conference-modify", "jitsi:colibri2", false);
            $this$start_u24lambda_u240.setIQListener((IQListener)this);
            $this$start_u24lambda_u240.addConnectionStateListener(new ConnectionStateListener(){

                public void connected(MucClient mucClient) {
                    Intrinsics.checkNotNullParameter((Object)mucClient, (String)"mucClient");
                }

                public void closed(MucClient mucClient) {
                    Intrinsics.checkNotNullParameter((Object)mucClient, (String)"mucClient");
                    CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.INSTANCE.getXmppDisconnects(), null, (int)1, null);
                }

                public void closedOnError(MucClient mucClient) {
                    Intrinsics.checkNotNullParameter((Object)mucClient, (String)"mucClient");
                    CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.INSTANCE.getXmppDisconnects(), null, (int)1, null);
                }

                public void reconnecting(MucClient mucClient) {
                    Intrinsics.checkNotNullParameter((Object)mucClient, (String)"mucClient");
                }

                public void reconnectionFailed(MucClient mucClient) {
                    Intrinsics.checkNotNullParameter((Object)mucClient, (String)"mucClient");
                }

                public void pingFailed(MucClient mucClient) {
                    Intrinsics.checkNotNullParameter((Object)mucClient, (String)"mucClient");
                }
            });
            Iterable $this$forEach$iv = XmppClientConnectionConfig.config.getClientConfigs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MucClientConfiguration cfg = (MucClientConfiguration)element$iv;
                boolean bl2 = false;
                this.mucClientManager.addMucClient(cfg);
            }
            Metrics.INSTANCE.getMetricsUpdater().addUpdateTask(() -> XmppConnection.start$lambda$2(this));
        } else {
            this.logger.info((Object)"Already started");
        }
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.mucClientManager.stop();
        }
    }

    public final void updateMetrics() {
        LongGaugeMetric.set$default((LongGaugeMetric)mucClientsConfigured, (long)this.mucClientManager.getClientCount(), null, (int)2, null);
        LongGaugeMetric.set$default((LongGaugeMetric)mucClientsConnected, (long)this.mucClientManager.getClientConnectedCount(), null, (int)2, null);
        LongGaugeMetric.set$default((LongGaugeMetric)mucsConfigured, (long)this.mucClientManager.getMucCount(), null, (int)2, null);
        LongGaugeMetric.set$default((LongGaugeMetric)mucsJoined, (long)this.mucClientManager.getMucJoinedCount(), null, (int)2, null);
    }

    public final void setPresenceExtension(@NotNull ExtensionElement extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.mucClientManager.setPresenceExtension(extension);
    }

    public final boolean addMucClient(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        if (!(jsonObject.get((Object)"id") instanceof String)) {
            return false;
        }
        Object object = jsonObject.get((Object)"id");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        MucClientConfiguration config = new MucClientConfiguration((String)object);
        for (Object key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (!(key instanceof String) || !(value instanceof String) || Intrinsics.areEqual(key, (Object)"id")) continue;
            config.setProperty((String)key, (String)value);
        }
        if (!config.isComplete()) {
            this.logger.info((Object)"Not adding a MucClient, configuration incomplete.");
            return false;
        }
        MucClient mucClient = this.mucClientManager.getMucClient(config.getId());
        if (mucClient != null) {
            MucClient existingMucClient = mucClient;
            boolean bl = false;
            MucClientConfiguration mucClientConfiguration = existingMucClient.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)mucClientConfiguration, (String)"getConfig(...)");
            if (!this.matches(mucClientConfiguration, config)) {
                this.logger.warn((Object)("Config for " + config.getId() + " has changed, removing the old MucClient. Existing config=" + existingMucClient.getConfig() + ", new config=" + config));
                this.mucClientManager.removeMucClient(config.getId());
            } else {
                this.logger.info((Object)("Ignoring request to add a MucClient that matches an existing one. Existing config=" + existingMucClient.getConfig() + ", new config=" + config));
            }
        }
        this.logger.info((Object)("Adding MucClient for " + config.getId()));
        this.mucClientManager.addMucClient(config);
        return true;
    }

    private final boolean matches(MucClientConfiguration $this$matches, MucClientConfiguration other) {
        return Intrinsics.areEqual((Object)$this$matches.getHostname(), (Object)other.getHostname()) && Intrinsics.areEqual((Object)$this$matches.getPort(), (Object)other.getPort()) && Intrinsics.areEqual((Object)$this$matches.getDomain(), (Object)other.getDomain()) && Intrinsics.areEqual((Object)$this$matches.getUsername(), (Object)other.getUsername());
    }

    @NotNull
    public final String getMucClientIds() {
        JSONArray jSONArray;
        JSONArray $this$getMucClientIds_u24lambda_u244 = jSONArray = new JSONArray();
        boolean bl = false;
        $this$getMucClientIds_u24lambda_u244.addAll((Collection)this.mucClientManager.getMucClientIds());
        String string = jSONArray.toJSONString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(...)");
        return string;
    }

    public final boolean removeMucClient(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Object id = jsonObject.get((Object)"id");
        if (!(id instanceof String)) {
            this.logger.info((Object)("Invalid ID: " + id));
            return false;
        }
        this.logger.info((Object)("Removing muc client " + id));
        return this.mucClientManager.removeMucClient((String)id);
    }

    @Nullable
    public IQ handleIq(@Nullable IQ iq, @NotNull MucClient mucClient) {
        IQ iQ;
        Intrinsics.checkNotNullParameter((Object)mucClient, (String)"mucClient");
        if (iq == null) {
            return null;
        }
        if (!(iq instanceof ConferenceModifyIQ)) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)("RECV: " + XmlStringBuilderUtil.Companion.toStringOpt(iq)));
            }
        }
        IQ.Type type = iq.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                IQ iQ2 = this.handleIqRequest(iq, mucClient);
                if (iQ2 != null) {
                    IQ iQ3;
                    IQ it = iQ3 = iQ2;
                    boolean bl = false;
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl2 = false;
                        logger.debug((Object)("SENT: " + XmlStringBuilderUtil.Companion.toStringOpt(it)));
                    }
                    iQ = iQ3;
                    break;
                }
                iQ = null;
                break;
            }
            default: {
                iQ = null;
            }
        }
        return iQ;
    }

    private final IQ handleIqRequest(IQ iq, MucClient mucClient) {
        IQ response;
        IQ iQ;
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler == null) {
            return ErrorUtilKt.createError$default((IQ)iq, (StanzaError.Condition)StanzaError.Condition.service_unavailable, (String)"Service unavailable", null, (int)8, null);
        }
        EventHandler handler = eventHandler;
        IQ iQ2 = iq;
        if (iQ2 instanceof Version) {
            iQ = (IQ)this.measureDelay(versionDelayStats, (Function0<? extends CharSequence>)((Function0)() -> XmppConnection.handleIqRequest$lambda$8(iq)), () -> XmppConnection.handleIqRequest$lambda$9(handler, iq));
        } else if (iQ2 instanceof ConferenceModifyIQ) {
            handler.colibriRequestReceived(new ColibriRequest((ConferenceModifyIQ)iq, colibriDelayStats, colibriProcessingDelayStats, 0L, arg_0 -> XmppConnection.handleIqRequest$lambda$10(this, iq, mucClient, arg_0), 8, null));
            iQ = null;
        } else {
            iQ = iQ2 instanceof HealthCheckIQ ? (IQ)this.measureDelay(healthDelayStats, (Function0<? extends CharSequence>)((Function0)() -> XmppConnection.handleIqRequest$lambda$11(iq)), () -> XmppConnection.handleIqRequest$lambda$12(handler, iq)) : ErrorUtilKt.createError$default((IQ)iq, (StanzaError.Condition)StanzaError.Condition.service_unavailable, (String)("Unsupported IQ request " + iq.getChildElementName()), null, (int)8, null);
        }
        IQ iQ3 = response = iQ;
        return iQ3 != null ? this.setResponseTo(iQ3, iq) : null;
    }

    private final IQ setResponseTo(IQ $this$setResponseTo, IQ request) {
        IQ iQ;
        IQ $this$setResponseTo_u24lambda_u2413 = iQ = $this$setResponseTo;
        boolean bl = false;
        $this$setResponseTo_u24lambda_u2413.setFrom(request.getTo());
        $this$setResponseTo_u24lambda_u2413.setStanzaId(request.getStanzaId());
        $this$setResponseTo_u24lambda_u2413.setTo(request.getFrom());
        return iQ;
    }

    private final <T> T measureDelay(DelayStats delayStats, Function0<? extends CharSequence> context, Function0<? extends T> block) {
        long start2 = System.currentTimeMillis();
        Object result = block.invoke();
        long delayMs = System.currentTimeMillis() - start2;
        delayStats.addDelay(delayMs);
        if (delayMs > 100L) {
            this.logger.warn((Object)("Took " + delayMs + " ms to handle IQ: " + context.invoke()));
        }
        return (T)result;
    }

    private static final Unit start$lambda$2(XmppConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateMetrics();
        return Unit.INSTANCE;
    }

    private static final CharSequence handleIqRequest$lambda$8(IQ $iq) {
        Intrinsics.checkNotNullParameter((Object)$iq, (String)"$iq");
        return XmlStringBuilderUtil.Companion.toStringOpt($iq);
    }

    private static final IQ handleIqRequest$lambda$9(EventHandler $handler, IQ $iq) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)$iq, (String)"$iq");
        return $handler.versionIqReceived((Version)$iq);
    }

    private static final Unit handleIqRequest$lambda$10(XmppConnection this$0, IQ $iq, MucClient $mucClient, IQ response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$iq, (String)"$iq");
        Intrinsics.checkNotNullParameter((Object)$mucClient, (String)"$mucClient");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this$0.setResponseTo(response, $iq);
        $mucClient.sendStanza((Stanza)response);
        return Unit.INSTANCE;
    }

    private static final CharSequence handleIqRequest$lambda$11(IQ $iq) {
        Intrinsics.checkNotNullParameter((Object)$iq, (String)"$iq");
        return XmlStringBuilderUtil.Companion.toStringOpt($iq);
    }

    private static final IQ handleIqRequest$lambda$12(EventHandler $handler, IQ $iq) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        Intrinsics.checkNotNullParameter((Object)$iq, (String)"$iq");
        return $handler.healthCheckIqReceived((HealthCheckIQ)$iq);
    }

    @JvmStatic
    @NotNull
    public static final OrderedJsonObject getStatsJson() {
        return Companion.getStatsJson();
    }

    static {
        Object[] objectArray = new String[]{"http://jitsi.org/protocol/healthcheck", "urn:xmpp:jingle:apps:dtls:0", "urn:xmpp:jingle:transports:ice-udp:1", "jabber:iq:version"};
        FEATURES = objectArray;
        objectArray = new Long[]{0L, 5L, 50L, 100L, 1000L, Long.MAX_VALUE};
        delayThresholds = CollectionsKt.listOf((Object[])objectArray);
        colibriProcessingDelayStats = new DelayStats(delayThresholds);
        colibriDelayStats = new DelayStats(delayThresholds);
        healthDelayStats = new DelayStats(delayThresholds);
        versionDelayStats = new DelayStats(delayThresholds);
        mucClientsConfigured = MetricsContainer.registerLongGauge$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"muc_clients_configured", (String)"Number of MUC clients that are configured.", (long)0L, null, (int)12, null);
        mucClientsConnected = MetricsContainer.registerLongGauge$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"muc_clients_connected", (String)"Number of MUC clients that are connected.", (long)0L, null, (int)12, null);
        mucsConfigured = MetricsContainer.registerLongGauge$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"mucs_connected", (String)"Number of MUCs that are configured.", (long)0L, null, (int)12, null);
        mucsJoined = MetricsContainer.registerLongGauge$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"mucs_joined", (String)"Number of MUCs that are joined.", (long)0L, null, (int)12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\u0015\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection$ColibriRequest;", "", "request", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "totalDelayStats", "Lorg/jitsi/nlj/stats/DelayStats;", "processingDelayStats", "receiveTime", "", "callback", "Lkotlin/Function1;", "Lorg/jivesoftware/smack/packet/IQ;", "", "<init>", "(Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;Lorg/jitsi/nlj/stats/DelayStats;Lorg/jitsi/nlj/stats/DelayStats;JLkotlin/jvm/functions/Function1;)V", "getRequest", "()Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "getTotalDelayStats", "()Lorg/jitsi/nlj/stats/DelayStats;", "getProcessingDelayStats", "getReceiveTime", "()J", "getCallback", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-videobridge"})
    public static final class ColibriRequest {
        @NotNull
        private final ConferenceModifyIQ request;
        @NotNull
        private final DelayStats totalDelayStats;
        @NotNull
        private final DelayStats processingDelayStats;
        private final long receiveTime;
        @NotNull
        private final Function1<IQ, Unit> callback;

        public ColibriRequest(@NotNull ConferenceModifyIQ request, @NotNull DelayStats totalDelayStats, @NotNull DelayStats processingDelayStats, long receiveTime, @NotNull Function1<? super IQ, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)totalDelayStats, (String)"totalDelayStats");
            Intrinsics.checkNotNullParameter((Object)processingDelayStats, (String)"processingDelayStats");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.request = request;
            this.totalDelayStats = totalDelayStats;
            this.processingDelayStats = processingDelayStats;
            this.receiveTime = receiveTime;
            this.callback = callback;
        }

        public /* synthetic */ ColibriRequest(ConferenceModifyIQ conferenceModifyIQ, DelayStats delayStats, DelayStats delayStats2, long l, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                l = System.currentTimeMillis();
            }
            this(conferenceModifyIQ, delayStats, delayStats2, l, (Function1<? super IQ, Unit>)function1);
        }

        @NotNull
        public final ConferenceModifyIQ getRequest() {
            return this.request;
        }

        @NotNull
        public final DelayStats getTotalDelayStats() {
            return this.totalDelayStats;
        }

        @NotNull
        public final DelayStats getProcessingDelayStats() {
            return this.processingDelayStats;
        }

        public final long getReceiveTime() {
            return this.receiveTime;
        }

        @NotNull
        public final Function1<IQ, Unit> getCallback() {
            return this.callback;
        }

        @NotNull
        public final ConferenceModifyIQ component1() {
            return this.request;
        }

        @NotNull
        public final DelayStats component2() {
            return this.totalDelayStats;
        }

        @NotNull
        public final DelayStats component3() {
            return this.processingDelayStats;
        }

        public final long component4() {
            return this.receiveTime;
        }

        @NotNull
        public final Function1<IQ, Unit> component5() {
            return this.callback;
        }

        @NotNull
        public final ColibriRequest copy(@NotNull ConferenceModifyIQ request, @NotNull DelayStats totalDelayStats, @NotNull DelayStats processingDelayStats, long receiveTime, @NotNull Function1<? super IQ, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)totalDelayStats, (String)"totalDelayStats");
            Intrinsics.checkNotNullParameter((Object)processingDelayStats, (String)"processingDelayStats");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            return new ColibriRequest(request, totalDelayStats, processingDelayStats, receiveTime, callback);
        }

        public static /* synthetic */ ColibriRequest copy$default(ColibriRequest colibriRequest, ConferenceModifyIQ conferenceModifyIQ, DelayStats delayStats, DelayStats delayStats2, long l, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                conferenceModifyIQ = colibriRequest.request;
            }
            if ((n & 2) != 0) {
                delayStats = colibriRequest.totalDelayStats;
            }
            if ((n & 4) != 0) {
                delayStats2 = colibriRequest.processingDelayStats;
            }
            if ((n & 8) != 0) {
                l = colibriRequest.receiveTime;
            }
            if ((n & 0x10) != 0) {
                function1 = colibriRequest.callback;
            }
            return colibriRequest.copy(conferenceModifyIQ, delayStats, delayStats2, l, function1);
        }

        @NotNull
        public String toString() {
            return "ColibriRequest(request=" + this.request + ", totalDelayStats=" + this.totalDelayStats + ", processingDelayStats=" + this.processingDelayStats + ", receiveTime=" + this.receiveTime + ", callback=" + this.callback + ")";
        }

        public int hashCode() {
            int result = this.request.hashCode();
            result = result * 31 + this.totalDelayStats.hashCode();
            result = result * 31 + this.processingDelayStats.hashCode();
            result = result * 31 + Long.hashCode(this.receiveTime);
            result = result * 31 + this.callback.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColibriRequest)) {
                return false;
            }
            ColibriRequest colibriRequest = (ColibriRequest)other;
            if (!Intrinsics.areEqual((Object)this.request, (Object)colibriRequest.request)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.totalDelayStats, (Object)colibriRequest.totalDelayStats)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.processingDelayStats, (Object)colibriRequest.processingDelayStats)) {
                return false;
            }
            if (this.receiveTime != colibriRequest.receiveTime) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, colibriRequest.callback);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection$Companion;", "", "<init>", "()V", "FEATURES", "", "", "[Ljava/lang/String;", "delayThresholds", "", "", "colibriProcessingDelayStats", "Lorg/jitsi/nlj/stats/DelayStats;", "colibriDelayStats", "healthDelayStats", "versionDelayStats", "mucClientsConfigured", "Lorg/jitsi/metrics/LongGaugeMetric;", "getMucClientsConfigured", "()Lorg/jitsi/metrics/LongGaugeMetric;", "mucClientsConnected", "getMucClientsConnected", "mucsConfigured", "getMucsConfigured", "mucsJoined", "getMucsJoined", "getStatsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongGaugeMetric getMucClientsConfigured() {
            return mucClientsConfigured;
        }

        @NotNull
        public final LongGaugeMetric getMucClientsConnected() {
            return mucClientsConnected;
        }

        @NotNull
        public final LongGaugeMetric getMucsConfigured() {
            return mucsConfigured;
        }

        @NotNull
        public final LongGaugeMetric getMucsJoined() {
            return mucsJoined;
        }

        @JvmStatic
        @NotNull
        public final OrderedJsonObject getStatsJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$getStatsJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$getStatsJson_u24lambda_u240.put((Object)"colibri", (Object)BucketStats.toJson$default((BucketStats)((BucketStats)colibriDelayStats), null, (int)1, null));
            $this$getStatsJson_u24lambda_u240.put((Object)"colibri_processing", (Object)BucketStats.toJson$default((BucketStats)((BucketStats)colibriProcessingDelayStats), null, (int)1, null));
            $this$getStatsJson_u24lambda_u240.put((Object)"health", (Object)BucketStats.toJson$default((BucketStats)((BucketStats)healthDelayStats), null, (int)1, null));
            $this$getStatsJson_u24lambda_u240.put((Object)"version", (Object)BucketStats.toJson$default((BucketStats)((BucketStats)versionDelayStats), null, (int)1, null));
            return orderedJsonObject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jitsi/videobridge/xmpp/XmppConnection$EventHandler;", "", "colibriRequestReceived", "", "request", "Lorg/jitsi/videobridge/xmpp/XmppConnection$ColibriRequest;", "versionIqReceived", "Lorg/jivesoftware/smack/packet/IQ;", "iq", "Lorg/jivesoftware/smackx/iqversion/packet/Version;", "healthCheckIqReceived", "Lorg/jitsi/xmpp/extensions/health/HealthCheckIQ;", "jitsi-videobridge"})
    public static interface EventHandler {
        public void colibriRequestReceived(@NotNull ColibriRequest var1);

        @NotNull
        public IQ versionIqReceived(@NotNull Version var1);

        @NotNull
        public IQ healthCheckIqReceived(@NotNull HealthCheckIQ var1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IQ.Type.values().length];
            try {
                nArray[IQ.Type.get.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IQ.Type.set.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

