/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpEncodingDescKt;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.utils.ArrayUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B1\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\"\u001a\u00020#H\u0002J\u001d\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001e\u00a2\u0006\u0004\b(\u0010)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u001eJ\u0010\u00100\u001a\u0004\u0018\u00010\u00182\u0006\u0010'\u001a\u00020\u001eJ\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u0018022\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u00106\u001a\u00020\u001bJ\u0019\u00107\u001a\b\u0012\u0004\u0012\u00020\u00180\u00032\u0006\u00106\u001a\u00020\u001b\u00a2\u0006\u0002\u00108J!\u00109\u001a\u00020#2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00032\u0006\u00106\u001a\u00020\u001b\u00a2\u0006\u0002\u0010:J\u0006\u0010;\u001a\u00020\u0000J\b\u0010<\u001a\u00020\u0006H\u0016J\u000e\u0010=\u001a\u00020+2\u0006\u00106\u001a\u00020\u001bJ\u000e\u0010>\u001a\u00020+2\u0006\u00106\u001a\u00020\u001bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00180\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010-\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006?"}, d2={"Lorg/jitsi/nlj/MediaSourceDesc;", "", "rtpEncodings", "", "Lorg/jitsi/nlj/RtpEncodingDesc;", "owner", "", "sourceName", "videoType", "Lorg/jitsi/nlj/VideoType;", "<init>", "([Lorg/jitsi/nlj/RtpEncodingDesc;Ljava/lang/String;Ljava/lang/String;Lorg/jitsi/nlj/VideoType;)V", "getRtpEncodings", "()[Lorg/jitsi/nlj/RtpEncodingDesc;", "[Lorg/jitsi/nlj/RtpEncodingDesc;", "getOwner", "()Ljava/lang/String;", "getSourceName", "getVideoType", "()Lorg/jitsi/nlj/VideoType;", "setVideoType", "(Lorg/jitsi/nlj/VideoType;)V", "layers", "", "Lorg/jitsi/nlj/RtpLayerDesc;", "layersById", "", "", "layersByIndex", "Ljava/util/NavigableMap;", "", "rtpLayers", "getRtpLayers", "()Ljava/util/List;", "updateLayerCache", "", "getBitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "nowMs", "idx", "getBitrate-MxRVi0s", "(JI)D", "hasRtpLayers", "", "numRtpLayers", "primarySSRC", "getPrimarySSRC", "()J", "getRtpLayerByQualityIdx", "findRtpLayerDescs", "", "videoRtpPacket", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "findRtpEncodingDesc", "ssrc", "getEncodingLayers", "(J)[Lorg/jitsi/nlj/RtpLayerDesc;", "setEncodingLayers", "([Lorg/jitsi/nlj/RtpLayerDesc;J)V", "copy", "toString", "matches", "hasSsrc", "jitsi-media-transform"})
@SuppressFBWarnings(value={"NP_ALWAYS_NULL"}, justification="False positives with 'lateinit'.")
@SourceDebugExtension(value={"SMAP\nMediaSourceDesc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaSourceDesc.kt\norg/jitsi/nlj/MediaSourceDesc\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,227:1\n1611#2,9:228\n1863#2:237\n1864#2:239\n1620#2:240\n1#3:238\n1#3:241\n12511#4,2:242\n*S KotlinDebug\n*F\n+ 1 MediaSourceDesc.kt\norg/jitsi/nlj/MediaSourceDesc\n*L\n146#1:228,9\n146#1:237\n146#1:239\n146#1:240\n146#1:238\n197#1:242,2\n*E\n"})
public final class MediaSourceDesc {
    @NotNull
    private final RtpEncodingDesc[] rtpEncodings;
    @NotNull
    private final String owner;
    @NotNull
    private final String sourceName;
    @NotNull
    private VideoType videoType;
    private List<? extends RtpLayerDesc> layers;
    @NotNull
    private final Map<Long, RtpLayerDesc> layersById;
    @NotNull
    private final NavigableMap<Integer, RtpLayerDesc> layersByIndex;

    @JvmOverloads
    public MediaSourceDesc(@NotNull RtpEncodingDesc[] rtpEncodings, @NotNull String owner, @NotNull String sourceName, @NotNull VideoType videoType) {
        Intrinsics.checkNotNullParameter((Object)rtpEncodings, (String)"rtpEncodings");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)((Object)videoType), (String)"videoType");
        this.rtpEncodings = rtpEncodings;
        this.owner = owner;
        this.sourceName = sourceName;
        this.videoType = videoType;
        this.layersById = new HashMap();
        this.layersByIndex = new TreeMap();
        this.updateLayerCache();
    }

    public /* synthetic */ MediaSourceDesc(RtpEncodingDesc[] rtpEncodingDescArray, String string, String string2, VideoType videoType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            videoType = VideoType.CAMERA;
        }
        this(rtpEncodingDescArray, string, string2, videoType);
    }

    @NotNull
    public final RtpEncodingDesc[] getRtpEncodings() {
        return this.rtpEncodings;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final String getSourceName() {
        return this.sourceName;
    }

    @NotNull
    public final VideoType getVideoType() {
        return this.videoType;
    }

    public final void setVideoType(@NotNull VideoType videoType) {
        Intrinsics.checkNotNullParameter((Object)((Object)videoType), (String)"<set-?>");
        this.videoType = videoType;
    }

    @NotNull
    public final synchronized List<RtpLayerDesc> getRtpLayers() {
        List<RtpLayerDesc> list = this.layers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layers");
            list = null;
        }
        return list;
    }

    private final void updateLayerCache() {
        this.layersById.clear();
        this.layersByIndex.clear();
        ArrayList<RtpLayerDesc> tempLayers = new ArrayList<RtpLayerDesc>();
        for (RtpEncodingDesc encoding : this.rtpEncodings) {
            for (RtpLayerDesc layer : encoding.getLayers$jitsi_media_transform()) {
                this.layersById.put(encoding.encodingId(layer), layer);
                ((Map)this.layersByIndex).put(layer.getIndex(), layer);
                tempLayers.add(layer);
            }
        }
        this.layers = Collections.unmodifiableList((List)tempLayers);
    }

    public final synchronized double getBitrate-MxRVi0s(long nowMs, int idx) {
        NavigableMap<Integer, RtpLayerDesc> navigableMap = this.layersByIndex.headMap(idx, true).descendingMap();
        Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"descendingMap(...)");
        for (Map.Entry entry : ((Map)navigableMap).entrySet()) {
            double bitrate = ((RtpLayerDesc)entry.getValue()).getBitrate-WElJv5I(nowMs);
            if (!(bitrate > 0.0)) continue;
            return bitrate;
        }
        return BandwidthKt.getBps(0);
    }

    public final synchronized boolean hasRtpLayers() {
        List<? extends RtpLayerDesc> list = this.layers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layers");
            list = null;
        }
        return !((Collection)list).isEmpty();
    }

    public final synchronized int numRtpLayers() {
        return this.layersByIndex.size();
    }

    public final long getPrimarySSRC() {
        return this.rtpEncodings[0].getPrimarySSRC();
    }

    @Nullable
    public final synchronized RtpLayerDesc getRtpLayerByQualityIdx(int idx) {
        return (RtpLayerDesc)this.layersByIndex.get(idx);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Collection<RtpLayerDesc> findRtpLayerDescs(@NotNull VideoRtpPacket videoRtpPacket) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)videoRtpPacket), (String)"videoRtpPacket");
        if (ArrayUtils.isNullOrEmpty((Object[])this.rtpEncodings)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = RtpEncodingDescKt.getEncodingIds(videoRtpPacket);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RtpLayerDesc it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if (this.layersById.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final synchronized RtpEncodingDesc findRtpEncodingDesc(long ssrc) {
        RtpEncodingDesc rtpEncodingDesc;
        block1: {
            RtpEncodingDesc[] rtpEncodingDescArray = this.rtpEncodings;
            int n = rtpEncodingDescArray.length;
            for (int i = 0; i < n; ++i) {
                RtpEncodingDesc rtpEncodingDesc2;
                RtpEncodingDesc it = rtpEncodingDesc2 = rtpEncodingDescArray[i];
                boolean bl = false;
                if (!it.hasSsrc(ssrc)) continue;
                rtpEncodingDesc = rtpEncodingDesc2;
                break block1;
            }
            rtpEncodingDesc = null;
        }
        return rtpEncodingDesc;
    }

    @NotNull
    public final synchronized RtpLayerDesc[] getEncodingLayers(long ssrc) {
        RtpEncodingDesc rtpEncodingDesc = this.findRtpEncodingDesc(ssrc);
        if (rtpEncodingDesc == null) {
            return new RtpLayerDesc[0];
        }
        RtpEncodingDesc enc = rtpEncodingDesc;
        int n = 0;
        int n2 = enc.getLayers$jitsi_media_transform().length;
        RtpLayerDesc[] rtpLayerDescArray = new RtpLayerDesc[n2];
        while (n < n2) {
            int n3 = n++;
            rtpLayerDescArray[n3] = RtpLayerDesc.copy$default(enc.getLayers$jitsi_media_transform()[n3], 0, 0, false, 7, null);
        }
        return rtpLayerDescArray;
    }

    public final synchronized void setEncodingLayers(@NotNull RtpLayerDesc[] layers, long ssrc) {
        Intrinsics.checkNotNullParameter((Object)layers, (String)"layers");
        RtpEncodingDesc rtpEncodingDesc = this.findRtpEncodingDesc(ssrc);
        if (rtpEncodingDesc == null) {
            return;
        }
        RtpEncodingDesc enc = rtpEncodingDesc;
        enc.setLayers$jitsi_media_transform(layers);
        this.updateLayerCache();
    }

    @NotNull
    public final synchronized MediaSourceDesc copy() {
        int n = 0;
        int n2 = this.rtpEncodings.length;
        RtpEncodingDesc[] rtpEncodingDescArray = new RtpEncodingDesc[n2];
        while (n < n2) {
            int n3 = n++;
            rtpEncodingDescArray[n3] = RtpEncodingDesc.copy$default(this.rtpEncodings[n3], 0L, null, 3, null);
        }
        VideoType videoType = this.videoType;
        String string = this.sourceName;
        String string2 = this.owner;
        RtpEncodingDesc[] rtpEncodingDescArray2 = rtpEncodingDescArray;
        return new MediaSourceDesc(rtpEncodingDescArray2, string2, string, videoType);
    }

    @NotNull
    public String toString() {
        return "MediaSourceDesc[name=" + this.sourceName + " owner=" + this.owner + ", videoType=" + this.videoType + ", encodings=" + ArraysKt.joinToString$default((Object[])this.rtpEncodings, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    public final boolean matches(long ssrc) {
        RtpEncodingDesc rtpEncodingDesc = (RtpEncodingDesc)ArraysKt.getOrNull((Object[])this.rtpEncodings, (int)0);
        return rtpEncodingDesc != null ? rtpEncodingDesc.getPrimarySSRC() == ssrc : false;
    }

    public final synchronized boolean hasSsrc(long ssrc) {
        boolean bl;
        block1: {
            RtpEncodingDesc[] $this$any$iv = this.rtpEncodings;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                RtpEncodingDesc element$iv;
                RtpEncodingDesc it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!it.hasSsrc(ssrc)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmOverloads
    public MediaSourceDesc(@NotNull RtpEncodingDesc[] rtpEncodings, @NotNull String owner, @NotNull String sourceName) {
        Intrinsics.checkNotNullParameter((Object)rtpEncodings, (String)"rtpEncodings");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        this(rtpEncodings, owner, sourceName, null, 8, null);
    }
}

