/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtcp.SenderInfo;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsSnapshot;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsTracker;
import org.jitsi.nlj.util.ScheduleExecutorServiceExtensionsKt;
import org.jitsi.rtp.rtcp.CompoundRtcpPacket;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacketBuilder;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.DurationKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jitsi/nlj/rtcp/RtcpRrGenerator;", "Lorg/jitsi/nlj/rtcp/RtcpListener;", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "rtcpSender", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "incomingStatisticsTracker", "Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker;", "clock", "Ljava/time/Clock;", "additionalPacketSupplier", "Lkotlin/Function0;", "", "<init>", "(Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function1;Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker;Ljava/time/Clock;Lkotlin/jvm/functions/Function0;)V", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "senderInfos", "", "", "Lorg/jitsi/nlj/rtcp/SenderInfo;", "rtcpPacketReceived", "packet", "receivedTime", "Ljava/time/Instant;", "doWork", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRtcpRrGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcpRrGenerator.kt\norg/jitsi/nlj/rtcp/RtcpRrGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,145:1\n216#2,2:146\n*S KotlinDebug\n*F\n+ 1 RtcpRrGenerator.kt\norg/jitsi/nlj/rtcp/RtcpRrGenerator\n*L\n98#1:146,2\n*E\n"})
public final class RtcpRrGenerator
implements RtcpListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledExecutorService backgroundExecutor;
    @NotNull
    private final Function1<RtcpPacket, Unit> rtcpSender;
    @NotNull
    private final IncomingStatisticsTracker incomingStatisticsTracker;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Function0<List<RtcpPacket>> additionalPacketSupplier;
    private boolean running;
    @NotNull
    private final Map<Long, SenderInfo> senderInfos;
    @NotNull
    private static final Duration reportingInterval = DurationKt.getMs((int)500);

    public RtcpRrGenerator(@NotNull ScheduledExecutorService backgroundExecutor, @NotNull Function1<? super RtcpPacket, Unit> rtcpSender, @NotNull IncomingStatisticsTracker incomingStatisticsTracker, @NotNull Clock clock, @NotNull Function0<? extends List<? extends RtcpPacket>> additionalPacketSupplier) {
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        Intrinsics.checkNotNullParameter(rtcpSender, (String)"rtcpSender");
        Intrinsics.checkNotNullParameter((Object)incomingStatisticsTracker, (String)"incomingStatisticsTracker");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(additionalPacketSupplier, (String)"additionalPacketSupplier");
        this.backgroundExecutor = backgroundExecutor;
        this.rtcpSender = rtcpSender;
        this.incomingStatisticsTracker = incomingStatisticsTracker;
        this.clock = clock;
        this.additionalPacketSupplier = additionalPacketSupplier;
        this.running = true;
        this.senderInfos = new ConcurrentHashMap();
        this.doWork();
    }

    public /* synthetic */ RtcpRrGenerator(ScheduledExecutorService scheduledExecutorService, Function1 function1, IncomingStatisticsTracker incomingStatisticsTracker, Clock clock, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = RtcpRrGenerator::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        this(scheduledExecutorService, (Function1<? super RtcpPacket, Unit>)function1, incomingStatisticsTracker, clock, (Function0<? extends List<? extends RtcpPacket>>)function0);
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    public void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (packet instanceof RtcpSrPacket) {
            SenderInfo senderInfo = this.senderInfos.computeIfAbsent(packet.getSenderSsrc(), arg_0 -> RtcpRrGenerator.rtcpPacketReceived$lambda$2(RtcpRrGenerator::rtcpPacketReceived$lambda$1, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)senderInfo, (String)"computeIfAbsent(...)");
            SenderInfo senderInfo2 = senderInfo;
            senderInfo2.setLastSrCompactedTimestamp(((RtcpSrPacket)packet).getSenderInfo().getCompactedNtpTimestamp());
            senderInfo2.setLastSrReceivedTime(receivedTime);
        }
    }

    private final void doWork() {
        if (this.running) {
            IncomingStatisticsSnapshot streamStats = this.incomingStatisticsTracker.getSnapshotOfActiveSsrcs();
            Instant now = this.clock.instant();
            List reportBlocks = new ArrayList();
            Map<Long, IncomingSsrcStats.Snapshot> $this$forEach$iv = streamStats.getSsrcStats();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, IncomingSsrcStats.Snapshot>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                SenderInfo senderInfo;
                Map.Entry<Long, IncomingSsrcStats.Snapshot> element$iv;
                Map.Entry<Long, IncomingSsrcStats.Snapshot> entry = element$iv = iterator.next();
                boolean bl = false;
                long ssrc = ((Number)entry.getKey()).longValue();
                IncomingSsrcStats.Snapshot statsSnapshot = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)this.senderInfos.computeIfAbsent(ssrc, arg_0 -> RtcpRrGenerator.doWork$lambda$5$lambda$4(RtcpRrGenerator::doWork$lambda$5$lambda$3, arg_0)), (String)"computeIfAbsent(...)");
                int fractionLost = statsSnapshot.computeFractionLost(senderInfo.getStatsSnapshot());
                senderInfo.setStatsSnapshot(statsSnapshot);
                int n = statsSnapshot.getCumulativePacketsLost();
                int n2 = statsSnapshot.getSeqNumCycles();
                int n3 = statsSnapshot.getMaxSeqNum();
                long l = (long)statsSnapshot.getJitter();
                long l2 = senderInfo.getLastSrCompactedTimestamp();
                Intrinsics.checkNotNull((Object)now);
                reportBlocks.add(new RtcpReportBlock(ssrc, fractionLost, n, n2, n3, l, l2, senderInfo.getDelaySinceLastSr(now)));
            }
            List packets = new ArrayList();
            if (!((Collection)reportBlocks).isEmpty()) {
                for (List blocks : CollectionsKt.chunked((Iterable)reportBlocks, (int)31)) {
                    packets.add(new RtcpRrPacketBuilder(null, blocks, 1, null).build());
                }
            }
            packets.addAll((Collection)this.additionalPacketSupplier.invoke());
            switch (packets.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.rtcpSender.invoke(CollectionsKt.first((List)packets));
                    break;
                }
                default: {
                    for (CompoundRtcpPacket packet : CompoundRtcpPacket.Companion.createWithMtu$default((CompoundRtcpPacket.Companion)CompoundRtcpPacket.Companion, (List)packets, (int)0, (int)2, null)) {
                        this.rtcpSender.invoke((Object)packet);
                    }
                }
            }
            ScheduleExecutorServiceExtensionsKt.schedule(this.backgroundExecutor, (KFunction<Unit>)((KFunction)new Function0<Unit>((Object)this){

                public final void invoke() {
                    RtcpRrGenerator.access$doWork((RtcpRrGenerator)this.receiver);
                }
            }), reportingInterval);
        }
    }

    private static final Unit _init_$lambda$0(RtcpPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final SenderInfo rtcpPacketReceived$lambda$1(Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SenderInfo(0L, null, null, 7, null);
    }

    private static final SenderInfo rtcpPacketReceived$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SenderInfo)$tmp0.invoke(p0);
    }

    private static final SenderInfo doWork$lambda$5$lambda$3(Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SenderInfo(0L, null, null, 7, null);
    }

    private static final SenderInfo doWork$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SenderInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$doWork(RtcpRrGenerator $this) {
        $this.doWork();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/rtcp/RtcpRrGenerator$Companion;", "", "<init>", "()V", "reportingInterval", "Ljava/time/Duration;", "getReportingInterval", "()Ljava/time/Duration;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getReportingInterval() {
            return reportingInterval;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

