/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.MediaType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0005J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/jitsi/nlj/rtcp/SenderInfo;", "", "lastSrCompactedTimestamp", "", "lastSrReceivedTime", "Ljava/time/Instant;", "statsSnapshot", "Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats$Snapshot;", "<init>", "(JLjava/time/Instant;Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats$Snapshot;)V", "getLastSrCompactedTimestamp", "()J", "setLastSrCompactedTimestamp", "(J)V", "getLastSrReceivedTime", "()Ljava/time/Instant;", "setLastSrReceivedTime", "(Ljava/time/Instant;)V", "getStatsSnapshot", "()Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats$Snapshot;", "setStatsSnapshot", "(Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats$Snapshot;)V", "hasReceivedSr", "", "getDelaySinceLastSr", "now", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
final class SenderInfo {
    private long lastSrCompactedTimestamp;
    @Nullable
    private Instant lastSrReceivedTime;
    @NotNull
    private IncomingSsrcStats.Snapshot statsSnapshot;

    public SenderInfo(long lastSrCompactedTimestamp, @Nullable Instant lastSrReceivedTime, @NotNull IncomingSsrcStats.Snapshot statsSnapshot) {
        Intrinsics.checkNotNullParameter((Object)statsSnapshot, (String)"statsSnapshot");
        this.lastSrCompactedTimestamp = lastSrCompactedTimestamp;
        this.lastSrReceivedTime = lastSrReceivedTime;
        this.statsSnapshot = statsSnapshot;
    }

    public /* synthetic */ SenderInfo(long l, Instant instant, IncomingSsrcStats.Snapshot snapshot, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            instant = null;
        }
        if ((n & 4) != 0) {
            snapshot = new IncomingSsrcStats.Snapshot(0, 0, 0, 0, 0, 0, 0.0, null, MediaType.VIDEO, 255, null);
        }
        this(l, instant, snapshot);
    }

    public final long getLastSrCompactedTimestamp() {
        return this.lastSrCompactedTimestamp;
    }

    public final void setLastSrCompactedTimestamp(long l) {
        this.lastSrCompactedTimestamp = l;
    }

    @Nullable
    public final Instant getLastSrReceivedTime() {
        return this.lastSrReceivedTime;
    }

    public final void setLastSrReceivedTime(@Nullable Instant instant) {
        this.lastSrReceivedTime = instant;
    }

    @NotNull
    public final IncomingSsrcStats.Snapshot getStatsSnapshot() {
        return this.statsSnapshot;
    }

    public final void setStatsSnapshot(@NotNull IncomingSsrcStats.Snapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"<set-?>");
        this.statsSnapshot = snapshot;
    }

    private final boolean hasReceivedSr() {
        return this.lastSrReceivedTime != null;
    }

    public final long getDelaySinceLastSr(@NotNull Instant now) {
        long l;
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (this.hasReceivedSr()) {
            Duration duration = Duration.between(this.lastSrReceivedTime, now);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
            l = DurationKt.times((Duration)duration, (int)65536).getSeconds();
        } else {
            l = 0L;
        }
        return l;
    }

    public final long component1() {
        return this.lastSrCompactedTimestamp;
    }

    @Nullable
    public final Instant component2() {
        return this.lastSrReceivedTime;
    }

    @NotNull
    public final IncomingSsrcStats.Snapshot component3() {
        return this.statsSnapshot;
    }

    @NotNull
    public final SenderInfo copy(long lastSrCompactedTimestamp, @Nullable Instant lastSrReceivedTime, @NotNull IncomingSsrcStats.Snapshot statsSnapshot) {
        Intrinsics.checkNotNullParameter((Object)statsSnapshot, (String)"statsSnapshot");
        return new SenderInfo(lastSrCompactedTimestamp, lastSrReceivedTime, statsSnapshot);
    }

    public static /* synthetic */ SenderInfo copy$default(SenderInfo senderInfo, long l, Instant instant, IncomingSsrcStats.Snapshot snapshot, int n, Object object) {
        if ((n & 1) != 0) {
            l = senderInfo.lastSrCompactedTimestamp;
        }
        if ((n & 2) != 0) {
            instant = senderInfo.lastSrReceivedTime;
        }
        if ((n & 4) != 0) {
            snapshot = senderInfo.statsSnapshot;
        }
        return senderInfo.copy(l, instant, snapshot);
    }

    @NotNull
    public String toString() {
        return "SenderInfo(lastSrCompactedTimestamp=" + this.lastSrCompactedTimestamp + ", lastSrReceivedTime=" + this.lastSrReceivedTime + ", statsSnapshot=" + this.statsSnapshot + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.lastSrCompactedTimestamp);
        result = result * 31 + (this.lastSrReceivedTime == null ? 0 : this.lastSrReceivedTime.hashCode());
        result = result * 31 + this.statsSnapshot.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SenderInfo)) {
            return false;
        }
        SenderInfo senderInfo = (SenderInfo)other;
        if (this.lastSrCompactedTimestamp != senderInfo.lastSrCompactedTimestamp) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastSrReceivedTime, (Object)senderInfo.lastSrReceivedTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.statsSnapshot, (Object)senderInfo.statsSnapshot);
    }

    public SenderInfo() {
        this(0L, null, null, 7, null);
    }
}

