/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoQualityLayerLookup;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "[Lorg/jitsi/nlj/MediaSourceDesc;", "numPacketsDroppedNoEncoding", "Ljava/util/concurrent/atomic/AtomicInteger;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "trace", "f", "Lkotlin/Function0;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "jitsi-media-transform"})
public final class VideoQualityLayerLookup
extends TransformerNode {
    @NotNull
    private final Logger logger;
    @NotNull
    private MediaSourceDesc[] sources;
    @NotNull
    private final AtomicInteger numPacketsDroppedNoEncoding;

    public VideoQualityLayerLookup(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super("Video quality layer lookup");
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.sources = new MediaSourceDesc[0];
        this.numPacketsDroppedNoEncoding = new AtomicInteger();
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        VideoRtpPacket videoPacket = (VideoRtpPacket)((Object)packetInfo.packetAs());
        Integer encodingId = MediaSourceDescKt.findRtpEncodingId(this.sources, videoPacket);
        if (encodingId == null) {
            this.logger.warn((Object)("Unable to find encoding matching packet! packet=" + videoPacket + "; sources=" + ArraysKt.joinToString$default((Object[])this.sources, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
            this.numPacketsDroppedNoEncoding.incrementAndGet();
            return null;
        }
        videoPacket.setEncodingId(encodingId);
        return packetInfo;
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof SetMediaSourcesEvent) {
            this.sources = ((SetMediaSourcesEvent)event).getMediaSourceDescs();
        }
        super.handleEvent(event);
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u240.addNumber("num_packets_dropped_no_encoding", this.numPacketsDroppedNoEncoding.get());
        return nodeStatsBlock;
    }
}

