/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import java.io.IOException;
import java.io.InputStream;

public class UDFEntryInputStream
extends InputStream {
    private UDFFileEntry entry;
    private UDFFileSystem fs;
    private long pos;
    private long rem;

    public UDFEntryInputStream(UDFFileEntry entry, UDFFileSystem fs) {
        this.fs = fs;
        this.entry = entry;
        this.pos = 0L;
        this.rem = this.entry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        this.ensureOpen();
        if (this.rem <= 0L) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int toRead = len;
        if ((long)toRead > this.rem) {
            toRead = (int)this.rem;
        }
        UDFFileSystem uDFFileSystem = this.fs;
        synchronized (uDFFileSystem) {
            if (this.fs.isClosed()) {
                throw new IOException("ISO file closed.");
            }
            read = this.fs.readFileContent(this.entry, this.pos, b, off, toRead);
        }
        if (read > 0) {
            this.pos += (long)read;
            this.rem -= (long)read;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public long skip(long n) {
        this.ensureOpen();
        int len = n > this.rem ? (int)this.rem : (int)n;
        this.pos += (long)len;
        this.rem -= (long)len;
        if (this.rem <= 0L) {
            this.close();
        }
        return len;
    }

    @Override
    public int available() {
        return Math.max((int)this.rem, 0);
    }

    public long size() {
        this.ensureOpen();
        return this.entry.getSize();
    }

    @Override
    public void close() {
        this.rem = 0L;
        this.entry = null;
        this.fs = null;
    }

    private void ensureOpen() {
        if (null == this.entry) {
            throw new IllegalStateException("stream has been closed");
        }
    }
}

