/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLBAddr;

public class LBAddr {
    public Long blockNumber;
    public Integer partitionReferenceNumber;
    public static final int LENGTH = 6;

    public LBAddr(byte[] bytes) throws InvalidLBAddr {
        this.deserialize(bytes);
    }

    public void deserialize(byte[] bytes) throws InvalidLBAddr {
        if (bytes.length < 6) {
            throw new InvalidLBAddr("logical block address descriptor too short");
        }
        this.blockNumber = UDFUtil.getUInt32(bytes, 0);
        this.partitionReferenceNumber = UDFUtil.getUInt16(bytes, 4);
    }

    public String toString() {
        return "LBAddr [blockNumber=" + this.blockNumber + ", partitionReferenceNumber=" + this.partitionReferenceNumber + "]";
    }
}

