/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.math.BigInteger;

public class LogicalVolumeHeader {
    public BigInteger uniqueId;
    public byte[] reserved;
    public static final int LENGTH = 32;

    public LogicalVolumeHeader(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
    }

    private void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 32) {
            throw new InvalidDescriptor("RegId allocation descriptor too short");
        }
        this.uniqueId = UDFUtil.getUInt64(bytes, 0);
        this.reserved = UDFUtil.getBytes(bytes, 8, 24);
    }

    public String toString() {
        return "LogicalVolumeHeader [uniqueId=" + this.uniqueId + ", reserved=" + this.reserved + "]";
    }
}

